#include <amxmodx>
#include <fakemeta>
#include <fun>
#include <zombieplague>

#define ULTIMATESEARCHTIME 2 //自动搜索时间
#define CHAINLIGHTNING_COOLDOWN 10.0 //闪电冷却时间
#define fm_get_user_button(%1) pev(%1, pev_button)

new const zclass_name[] = { "邪恶雷魔" }
new const zclass_info[] = { "生命III 速度I 闪电攻击" }
new const zclass_model[] = { "zombie_source" }
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" }

const zclass_health = 2350 // 生命
const zclass_speed = 210 // 速度
const Float:zclass_gravity = 0.85 // 重力
const Float:zclass_knockback = 1.25 // 击退

new g_zlight
new bool:ultimateused[33]
new bool:issearching[33]
new bool:lightninghit[33]
new lightning

public plugin_init()
{
	register_plugin("Zombie Light", "0.3", "[Grief.QQ]")
	register_forward(FM_PlayerPreThink, 	"fwd_playerprethink")
	register_logevent("round_start", 2, "1=Round_Start")
	register_logevent("round_end", 2, "1=Round_End")
}

public plugin_precache()
{
	precache_sound("warcraft3/LightningBolt.wav")
	precache_sound("turret/tu_ping.wav")
	lightning = precache_model("sprites/lgtning.spr")
	g_zlight = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)	
}

public zp_user_infected_post(id, infector)
{
	if (zp_get_user_zombie_class(id) == g_zlight)
	{
		client_print(id,print_chat,"鼠标对准人类按E键,10秒冷却时间,每次攻击 40HP !")
	}
}

public fwd_playerprethink(id) 
{
	new button = fm_get_user_button(id)
	new parm[2]
	parm[0]=id
	parm[1]=ULTIMATESEARCHTIME
	if((is_user_alive(id) == 1) && zp_get_user_zombie(id) && (button & IN_USE) && (zp_get_user_zombie_class(id) == g_zlight) && !ultimateused[id] && !issearching[id])
	lightsearchtarget(parm)
	//!zp_get_user_nemesis(id) && zp_get_user_survivor(id) && 
	return FMRES_IGNORED
}

public lightsearchtarget(parm[2])
{
	new id = parm[0]
	new enemy, body
	get_user_aiming(id,enemy,body)
	if ( 0<enemy<=33 && !zp_get_user_zombie(enemy))
	{
		ultimateused[id]=true
		new linewidth = 160
		new damage = 40 //闪电伤害值
		issearching[id]=false
		lightningeffect(id,enemy,linewidth,damage,id)
		new lightparm[4]
		lightparm[0]=enemy
		lightparm[1]=damage
		lightparm[2]=linewidth
		lightparm[3]=id
		new cooldownparm[1]
		cooldownparm[0]=id
		set_task(CHAINLIGHTNING_COOLDOWN,"cooldown",25,cooldownparm,1)
	}
	else
	{
		issearching[id]=true
		new counter = parm[1]
		while (counter >= 0)
		{
			counter -= 10
			if (counter==0)
				emit_sound(id,CHAN_ITEM, "turret/tu_ping.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
		}
		--parm[1]
		if (parm[1]>0 && get_user_health(id)>=0)
			set_task(0.1,"lightsearchtarget",26,parm,2)
		else
			issearching[id]=false
	}
	return PLUGIN_CONTINUE
}

public lightningeffect(id,targetid,linewidth,damage,caster)
{

	new bool:targetdied
	new bool:targetdead
	lightninghit[targetid]=true
	targetdead=false

	if (is_user_alive(targetid))
		targetdead=false
	else
		targetdead=true

	if (get_user_health(targetid)-damage<=0)
		targetdied=true

	set_user_health(targetid,get_user_health(targetid)-damage)
	if (get_user_armor(targetid)-damage<=0)
		set_user_armor(targetid,0)
	else
		set_user_armor(targetid,get_user_armor(targetid)-damage)

	if (targetdied && !targetdead)
	{
		set_user_frags(caster, get_user_frags(caster)+1)
		set_user_frags(targetid, get_user_frags(targetid)+1)
	}

	message_begin( MSG_BROADCAST, SVC_TEMPENTITY );
	write_byte( TE_BEAMENTS );
	write_short(id);	// 起始实体
	write_short(targetid);	// 目标实体
	write_short(lightning );	// 效果模型
	write_byte( 0 ); // starting frame
	write_byte( 15 );  // frame rate
	write_byte( 10 );  // life
	write_byte( linewidth );  // line width
	write_byte( 20 );  // 振幅
	write_byte( 255 );	// r, g, b
	write_byte( 255 );	// r, g, b
	write_byte( 255 );	// r, g, b
	write_byte( 200 );	// brightness
	write_byte( 0 );	// scroll speed
	message_end();

	new origin[3]
	get_user_origin(targetid,origin)

	message_begin( MSG_BROADCAST, SVC_TEMPENTITY );
	write_byte( TE_ELIGHT );
	write_short(targetid);	// entity
	write_coord(origin[0])  // initial position
	write_coord(origin[1])  // initial position
	write_coord(origin[2])  // initial position
	write_coord(100)	  // radius
	write_byte( 255 );	// r, g, b
	write_byte( 255 );	// r, g, b
	write_byte( 255 );	// r, g, b
	write_byte( 120 );  // life
	write_coord(0)	// decay rate
	message_end();

	emit_sound(id,CHAN_ITEM, "warcraft3/LightningBolt.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	return PLUGIN_CONTINUE
}

public cooldown(parm[1])
{
	ultimateused[parm[0]]=false
	return PLUGIN_CONTINUE
}

public client_connect(id)
{
	ultimateused[id]=false
	return PLUGIN_CONTINUE
}

public client_disconnect(id)
{
	ultimateused[id]=false
	return PLUGIN_CONTINUE
}

public round_start(id)
{
	ultimateused[id]=false
}

public round_end(id)
{
	ultimateused[id]=false
}
/* UTF-8 func by www.DT-Club.net */
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ ansicpg936\\ deff0{\\ fonttbl{\\ f0\\ fnil\\ fcharset134 Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang2052\\ f0\\ fs16 \n\\ par }
*/
