#include <amxmodx>
#include <amxmisc>
#include <fakemeta>
#include <fun>
#include <engine>
#include <hamsandwich>
#include <zombieplague>

#define HOOKBEAMLIFE  100
#define HOOKBEAMPOINT 1
#define HOOKKILLBEAM  99
#define HOOK_DELTA_T  0.1
#define MAXPLAYERS 32	
#define fm_get_user_button(%1) pev(%1, pev_button)

new g_trapeze
new g_hookLocation[MAXPLAYERS+1][3]
new g_hookLength[MAXPLAYERS+1]
new bool:g_hooked[MAXPLAYERS+1]
new Float:g_hookCreated[MAXPLAYERS+1]
new g_hooksLeft[MAXPLAYERS+1]
new g_spriteWeb

new const zclass_name[] = { "万恶触手" }
new const zclass_info[] = { "生命III 绕墙粘性触手" }
new const zclass_model[] = { "zombie_source" }
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" }

const zclass_health = 2200 // 生命
const zclass_speed = 185 // 速度
const Float:zclass_gravity = 0.8 // 重力
const Float:zclass_knockback = 1.3 // 击退

public plugin_init()
{
	register_plugin("[ZP] Zombie Trapeze", "0.2", "[Grief.QQ]")

	register_forward(FM_PlayerPreThink, 	"fwd_playerprethink")

	register_event("ResetHUD","newRound","b")
	register_event("DeathMsg", "trapeze_death", "a")

	register_cvar("trapeze_moveacc", "140" ) //吊线时的移动速度
	register_cvar("trapeze_reelspeed", "400" ) //吊线的速度
	register_cvar("trapeze_maxhooks", "20" ) //能吊多少次
	
	register_clcmd("+power", "trapeze_kd")
	register_clcmd("-power", "trapeze_ku")
	
	RegisterHam(Ham_TakeDamage, "player", "fw_TakeDamage")
}

public plugin_precache()
{
	precache_sound("bullchicken/bc_bite2.wav")
	g_spriteWeb = precache_model("sprites/zbeam4.spr")
	g_trapeze = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)	
}

stock playSoundDenySelect(id)
{
	client_cmd(id,"spk common/wpn_denyselect.wav")
}

public client_connect(id)
{
	client_cmd(id, "bind j +power")
	g_hooksLeft[id] = get_cvar_num("trapeze_maxhooks")
	if ( g_hooked[id] ) trapeze_hookOff(id)
	return PLUGIN_CONTINUE
}

public client_disconnect(id)
{
	client_cmd(id, "unbind j +power")
	g_hooksLeft[id] = get_cvar_num("trapeze_maxhooks")
	if ( g_hooked[id] ) trapeze_hookOff(id)
	return PLUGIN_CONTINUE
}

public newRound(id)
{
	client_cmd(id, "bind j +power")
	g_hooksLeft[id] = get_cvar_num("trapeze_maxhooks")
	if ( g_hooked[id] ) trapeze_hookOff(id)
}

public zp_user_infected_post(id, infector)
{
	if (zp_get_user_zombie_class(id) == g_trapeze)
	{
		client_print(id,print_chat,"按 J 键伸长粘性触手缠绕到墙体上！")
	}
}

public trapeze_death(id)
{
	if ( id < 1 || id > MAXPLAYERS) return
	g_hooksLeft[id] = get_cvar_num("trapeze_maxhooks")
	if ( g_hooked[id] ) trapeze_hookOff(id)
}

public trapeze_physics(parm[])
{
	new id=parm[0]
	new bool:autoReel=true
	new user_origin[3], user_look[3], user_direction[3], move_direction[3]
	new A[3], D[3], buttonadjust[3]
	new acceleration, Float:vTowards_A, Float:DvTowards_A
	new Float:velocity[3], null[3], buttonpress
	
	
	if ( !g_hooked[id]  )
		return

	if (!is_user_alive(id)) 
	{
		trapeze_hookOff(id)
		return
	}
	
	
	if ( g_hookCreated[id] + HOOKBEAMLIFE/10 <= get_gametime() )
	{
		beamentpoint(id)
	}
	
	
	beamentpoint(id)

	null[0] = 0
	null[1] = 0
	null[2] = 0

	get_user_origin(id, user_origin)
	get_user_origin(id, user_look, 2)

	entity_get_vector(id,EV_VEC_velocity,velocity)

	buttonadjust[0] = 0
	buttonadjust[1] = 0

	buttonpress = fm_get_user_button(id)

	if (buttonpress&IN_FORWARD)
	{
		buttonadjust[0] += 1
	}
	
	if (buttonpress&IN_BACK)
	{
		buttonadjust[0] -= 1
	}
	
	if (buttonpress&IN_MOVERIGHT)
	{
		buttonadjust[1] += 1
	}
	
	if (buttonpress&IN_MOVELEFT)
	{
		buttonadjust[1] -= 1
	}
	
	if (buttonpress&IN_JUMP)
	{
		buttonadjust[2] += 1
	}
	
	if (buttonpress&IN_DUCK)
	{
		buttonadjust[2] -= 1
	}

	if (buttonadjust[0] || buttonadjust[1])
	{
		user_direction[0] = user_look[0] - user_origin[0]
		user_direction[1] = user_look[1] - user_origin[1]

		move_direction[0] = buttonadjust[0] * user_direction[0] + user_direction[1] * buttonadjust[1]
		move_direction[1] = buttonadjust[0] * user_direction[1] - user_direction[0] * buttonadjust[1]
		move_direction[2] = 0

		velocity[0] += move_direction[0] * get_cvar_float("trapeze_moveacc") * HOOK_DELTA_T / get_distance(null,move_direction)
		velocity[1] += move_direction[1] * get_cvar_float("trapeze_moveacc") * HOOK_DELTA_T / get_distance(null,move_direction)
	}
	
	if (buttonadjust[2] < 0 || (buttonadjust[2] && g_hookLength[id] >= 60))
	{
		g_hookLength[id] -= floatround(buttonadjust[2] * get_cvar_float("trapeze_reelspeed") * HOOK_DELTA_T)
	}

	else if (autoReel && !(buttonpress&IN_DUCK) && g_hookLength[id] >= 200) 
	{
		buttonadjust[2] += 1
		g_hookLength[id] -= floatround(buttonadjust[2] * get_cvar_float("trapeze_reelspeed") * HOOK_DELTA_T)
	}


	A[0] = g_hookLocation[id][0] - user_origin[0]
	A[1] = g_hookLocation[id][1] - user_origin[1]
	A[2] = g_hookLocation[id][2] - user_origin[2]

	D[0] = A[0]*A[2] / get_distance(null,A)
	D[1] = A[1]*A[2] / get_distance(null,A)
	D[2] = -(A[1]*A[1] + A[0]*A[0]) / get_distance(null,A)

	new aDistance = get_distance(null,D) ? get_distance(null,D) : 1
	acceleration = (-get_cvar_num("sv_gravity")) * D[2] / aDistance

	vTowards_A = (velocity[0] * A[0] + velocity[1] * A[1] + velocity[2] * A[2]) / get_distance(null,A)
	DvTowards_A = float((get_distance(user_origin,g_hookLocation[id]) - g_hookLength[id]) * 4)

	if (get_distance(null,D) > 10) {
		velocity[0] += (acceleration * HOOK_DELTA_T * D[0]) / get_distance(null,D)
		velocity[1] += (acceleration * HOOK_DELTA_T * D[1]) / get_distance(null,D)
		velocity[2] += (acceleration * HOOK_DELTA_T * D[2]) / get_distance(null,D)
	}

	velocity[0] += ((DvTowards_A - vTowards_A) * A[0]) / get_distance(null,A)
	velocity[1] += ((DvTowards_A - vTowards_A) * A[1]) / get_distance(null,A)
	velocity[2] += ((DvTowards_A - vTowards_A) * A[2]) / get_distance(null,A)

	entity_set_vector(id,EV_VEC_velocity,velocity)
}

public trapeze_hookOn(id)
{
	new parm[2], user_origin[3]
	parm[0] = id

	if ( !is_user_alive(id) ) return PLUGIN_HANDLED

	if ( g_hooksLeft[id] == 0 )
	{
		playSoundDenySelect(id)
		client_print(id,print_center,"你的所有触手已经断了,请等下局!")
		return PLUGIN_HANDLED
	}

	if ( g_hooksLeft[id] > 0 ) g_hooksLeft[id]--

	if ( g_hooksLeft[id]>=0 && g_hooksLeft[id]<5 )
	{
		client_print(id, print_center, "[提示] 你还有 %d 条触手!", g_hooksLeft[id] )
	}

	g_hooked[id] = true
	get_user_origin(id, user_origin)
	get_user_origin(id, g_hookLocation[id], 3)
	g_hookLength[id] = get_distance(g_hookLocation[id],user_origin)
	beamentpoint(id)
	emit_sound(id, CHAN_STATIC, "bullchicken/bc_bite2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	set_task(HOOK_DELTA_T, "trapeze_physics", id, parm, 2, "b")

	return PLUGIN_CONTINUE
}

public trapeze_hookOff(id)
{
	g_hooked[id] = false
	killbeam(id)
	remove_task(id)
}

public beamentpoint(id)
{
	message_begin( MSG_BROADCAST, SVC_TEMPENTITY )
	write_byte( HOOKBEAMPOINT )
	write_short( id )
	write_coord( g_hookLocation[id][0] )
	write_coord( g_hookLocation[id][1] )
	write_coord( g_hookLocation[id][2] )
	write_short( g_spriteWeb )// spr
	write_byte( 0 )           // 开始帧
	write_byte( 0 )           // 振幅
	write_byte( HOOKBEAMLIFE )// 时间
	write_byte( 16 )          // 宽
	write_byte( 0 )           // noise
	write_byte( 250 )       // r, g, b
	write_byte( 0 	)       // r, g, b
	write_byte( 0 	)       // r, g, b
	write_byte( 125 )        // 亮度
	write_byte( 0 )          // 速度
	message_end( )
}

public killbeam(id)
{
	message_begin( MSG_BROADCAST, SVC_TEMPENTITY )
	write_byte( HOOKKILLBEAM )
	write_short( id )
	message_end()
}

public trapeze_kd(id)
{
	if (zp_get_user_nemesis(id)) return
	
	if(!g_hooked[id] && (is_user_alive(id) == 1) && zp_get_user_zombie(id) && (zp_get_user_zombie_class(id) == g_trapeze))
		trapeze_hookOn(id)
	else
	return
}

public trapeze_ku(id)
{
	if ( g_hooked[id] ) trapeze_hookOff(id)
}

//From faller zombie
public fw_TakeDamage(victim, inflictor, attacker, Float:damage, damage_type)
{
	// Victim is not taking damage from a fall
	if (!(damage_type & DMG_FALL))
		return HAM_IGNORED;
	
	// Victim is not a faller zombie
	if (!zp_get_user_zombie(victim) || zp_get_user_zombie_class(victim) != g_trapeze )
		return HAM_IGNORED;
	
	// Block the falling damage
	return HAM_SUPERCEDE;
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ ansicpg936\\ deff0{\\ fonttbl{\\ f0\\ fnil\\ fcharset134 Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang2052\\ f0\\ fs16 \n\\ par }
*/
