/*================================================================================
 * Please don't change plugin register information.
================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <xs>
#include <zombieplague>

#define SUPPORT_BOT_TO_USE	//支援BOT使用.(在最前面加上 // 即取消對BOT的技援)
#define BOUNCE_EFFECT	//被震波攻擊到是否會被彈開.(在最前面加上 // 即取消這項效果)
#define DROP_GUN	//被震波攻擊到是否會掉下手上的槍.(在最前面加上 // 即取消這項效果)

#define Survivor_Speed_Multiplier 0.5	//倖存者緩速效果的乘數. 減緩後的速度=原本的速度*乘數 (如乘數是1.0 就等於是原本的速度)
#define Human_Speed_Multiplier 0.1	//人類緩速效果的乘數. 減緩後的速度=原本的速度*乘數 (如乘數是1.0 就等於是原本的速度)
#define How_High_Invalid_Attack	60.0	//在震波攻擊範圍內的目標,若高度和攻擊者相差超出多少則判定攻擊無效.(人物模型的高度大約是60.0)

#define PLUGIN_NAME "[ZP] Class:Shock Wave "
#define PLUGIN_VERSION "1.1"
#define PLUGIN_AUTHOR "Jim"

const UNIT_SECOND = (1<<12)

#if defined DROP_GUN
// Weapon bitsums
const PRIMARY_WEAPONS_BIT_SUM = (1<<CSW_SCOUT)|(1<<CSW_XM1014)|(1<<CSW_MAC10)|(1<<CSW_AUG)|(1<<CSW_UMP45)|(1<<CSW_SG550)|(1<<CSW_GALIL)|(1<<CSW_FAMAS)|(1<<CSW_AWP)|(1<<CSW_MP5NAVY)|(1<<CSW_M249)|(1<<CSW_M3)|(1<<CSW_M4A1)|(1<<CSW_TMP)|(1<<CSW_G3SG1)|(1<<CSW_SG552)|(1<<CSW_AK47)|(1<<CSW_P90)
const SECONDARY_WEAPONS_BIT_SUM = (1<<CSW_P228)|(1<<CSW_ELITE)|(1<<CSW_FIVESEVEN)|(1<<CSW_USP)|(1<<CSW_GLOCK18)|(1<<CSW_DEAGLE)
#endif

// Shock Wave Zombie Attributes
new const zclass_name[] = { "碎裂恶骑士" }	//喪屍名稱
new const zclass_info[] = { "生命III 碎裂震波" }	//類型說明
new const zclass_model[] = { "zombie_source" }	//人物模組
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" }	//手的模組
const zclass_health = 2300	//血量(HP)
const zclass_speed = 220	//移動速度
const Float:zclass_gravity = 1.0	//承受重力
const Float:zclass_knockback = 1.25	//被擊退的數值

new const sound_shockwave[] = { "garg/gar_stomp1.wav" }

new bool:use_shockwave[33]
new bool:hit_key[33]
new bool:cooldown_started[33]
new bool:slowly_started[33], Float:slowly_begin_time[33]
new g_msgScreenShake,  g_shokewaveSpr
new g_zclass_shockwave
new g_shockwave_jump_height, g_shockwave_range, g_shockwave_effect_time, g_shockwave_cooldown

public plugin_init()
{
        register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	
	g_shockwave_jump_height = register_cvar("zp_shockwave_jump_height", "320") //使用震波攻擊時的跳躍高度
	g_shockwave_range = register_cvar("zp_shockwave_range", "280") //震波攻擊的有效範圍距離
	g_shockwave_effect_time = register_cvar("zp_shockwave_effect_time", "6.0") //受震波影響的時間長度(單位:秒)
	g_shockwave_cooldown = register_cvar("zp_shockwave_cooldown", "20.0")	//使用震波攻擊後的冷卻時間(單位:秒)
	
	register_forward(FM_PlayerPostThink, "fw_PlayerPostThink", 1)
	register_forward(FM_StartFrame, "fw_StartFrame")
	
	register_event("ResetHUD","NewRound","be")
	register_event("DeathMsg", "Death", "a")
	
	g_msgScreenShake = get_user_msgid("ScreenShake")
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheSound, sound_shockwave)
	g_shokewaveSpr = engfunc(EngFunc_PrecacheModel, "sprites/shockwave.spr")
	
	g_zclass_shockwave = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)
}

public zp_user_infected_post(id, infector)
{
	if (zp_get_user_zombie_class(id) == g_zclass_shockwave)
	{
		client_print(id, print_chat, "靠近人类时,站在地面上按 R 键可以放出碎裂震波,需要冷却时间%2.1f秒!", get_pcvar_float(g_shockwave_cooldown))
	}
}

public zp_user_humanized_post(id)
{
	use_shockwave[id] = false
	hit_key[id] = false
	cooldown_started[id] = false
	slowly_started[id] = false
}

public fw_StartFrame()
{
	// 設置檢查的間格時間,防止刷新太快
	static Float:last_check_time
	if (get_gametime() - last_check_time < 0.1)
		return;
	last_check_time = get_gametime()
	
	static id
	for (id = 1; id <= 32; id++)
	{
		// Not alive or zombie
		if (!is_user_alive(id) || zp_get_user_zombie(id))
			continue;
		
		if (slowly_started[id])
		{
			#if defined BOUNCE_EFFECT
			new Float:time
			time = get_gametime() - slowly_begin_time[id]
			
			if (time >= (get_pcvar_float(g_shockwave_effect_time) + 1.0)) //將緩速效果的結束時間往後延遲1.0秒
			{
				slowly_started[id] = false
			}
			else if (time > 1.0) //設定延遲1.0秒後才產生緩速的效果,以防彈開的效果被抑制
			{
				if (zp_get_user_survivor(id))
					set_speed_to_velocity(id, Survivor_Speed_Multiplier) //減緩速度的效果 (對於被震波攻擊到的"倖存者"玩家)
				else
					set_speed_to_velocity(id, Human_Speed_Multiplier) //減緩速度的效果 (對於被震波攻擊到的"人類"玩家)
			}
			#else
			if (zp_get_user_survivor(id))
				set_speed_to_velocity(id, Survivor_Speed_Multiplier) //減緩速度的效果 (對於被震波攻擊到的"倖存者"玩家)
			else
				set_speed_to_velocity(id, Human_Speed_Multiplier) //減緩速度的效果 (對於被震波攻擊到的"人類"玩家)
			
			new Float:time
			time = get_gametime() - slowly_begin_time[id]
			
			if (time >= get_pcvar_float(g_shockwave_effect_time))
				slowly_started[id] = false
			#endif
		}
	}
}

public fw_PlayerPostThink(id)
{
	if (!is_user_alive(id) || !zp_get_user_zombie(id) || (zp_get_user_zombie_class(id) != g_zclass_shockwave))
		return PLUGIN_CONTINUE
	
	if (zp_get_user_nemesis(id))
		return PLUGIN_CONTINUE
	
	if (cooldown_started[id])
		return PLUGIN_CONTINUE
	
	if (!use_shockwave[id])
	{
		#if defined SUPPORT_BOT_TO_USE
		if (is_user_bot(id))
		{
			new enemy, body
			get_user_aiming(id, enemy, body) //檢查是否正在瞄準某個目標
			
			if ((1 <= enemy <= 32) && !zp_get_user_zombie(enemy)) //檢查是否是有效的目標
			{
				new Float:origin1[3], Float:origin2[3], Float:range
				pev(id, pev_origin, origin1);
				pev(enemy, pev_origin, origin2);
				range = get_distance_f(origin1, origin2)
				
				if (is_user_on_ground(id) && (range <= get_pcvar_float(g_shockwave_range)) && (floatabs(origin2[2] - origin1[2]) <= How_High_Invalid_Attack))
				{
					new height =  get_pcvar_num(g_shockwave_jump_height)
					if (height > 0)
					{
						fm_set_user_jump_velocity(id, height) //放震波之前的跳躍動作效果
						if (fm_get_speed(id) > 0)
							use_shockwave[id] = true
					}
					else
					{
						use_shockwave[id] = true
					}
				}
			}
		}
		else
		{
		#endif
		
		static button, oldbutton
		button = pev(id, pev_button)
		oldbutton = pev(id, pev_oldbuttons)
		
		if ((button & IN_RELOAD) && (oldbutton & IN_RELOAD))
		{
			if (!hit_key[id] && is_user_on_ground(id))
			{
				hit_key[id] = true
				new height =  get_pcvar_num(g_shockwave_jump_height)
				if (height > 0)
				{
					fm_set_user_jump_velocity(id, height) //放震波之前的跳躍動作效果
					if (fm_get_speed(id) > 0)
						use_shockwave[id] = true
				}
				else
				{
					use_shockwave[id] = true
				}
			}
		}
		else
		{
			hit_key[id] = false
		}
		
		#if defined SUPPORT_BOT_TO_USE
		}
		#endif
	}
	else
	{
		if (is_user_on_ground(id))
		{
			use_shockwave[id] = false
			screen_shake(id, 10) //讓放震波攻擊的玩家畫面產生晃動
			PlaySound(id, sound_shockwave) //播放震撼效果的音效
			
			new Float:origin[3]
			pev(id, pev_origin, origin)
			create_blast(origin, 100, 100, 100, 200) //顯示震波的環狀效果
			search_in_range_target(id) //搜尋震波攻擊有效範圍內的玩家
			
			cooldown_started[id] = true
			//remove_task(id)
			set_task(get_pcvar_float(g_shockwave_cooldown), "cooldown_finish", id) //開始冷卻時間倒數
		}
	}
	
	return PLUGIN_CONTINUE
}

public search_in_range_target(id)
{
	new Float:origin1[3], Float:origin2[3], Float:range
	pev(id, pev_origin, origin1);
	
	#if defined BOUNCE_EFFECT
	new Float:velocity[3]
	#endif
	
	for (new i = 1; i <= 32; i++)
	{
		if ((i != id) && is_user_alive(i) && !zp_get_user_zombie(i))
		{
			pev(i, pev_origin, origin2);
			range = get_distance_f(origin1, origin2)
			
			if (range <= get_pcvar_float(g_shockwave_range))
			{
				PlaySound(i, sound_shockwave) //播放震撼效果的音效
				
				if (floatabs(origin2[2] - origin1[2]) <= How_High_Invalid_Attack)
				{
					screen_shake(i, 10) //讓被攻擊到的玩家畫面產生晃動
					
					#if defined BOUNCE_EFFECT
					get_speed_vector_to_entity(id, i, 500.0, velocity) //算出彈開時的向量,彈開速度設為500.0
					velocity[2] += 150.0 //加上彈開時的跳躍高度150.0
					set_pev(i, pev_velocity, velocity)
					#endif
					
					#if defined DROP_GUN
					if (!zp_get_user_survivor(i)) //設定若當玩家是倖存者時不會掉下手上的槍
						drop_current_weapon(i) //玩家丟掉目前手上的槍
					#endif
					
					slowly_started[i] = true
					slowly_begin_time[i] = get_gametime() //記綠緩速效果的開始時間
				}
			}
		}
	}
}

public cooldown_finish(id)
{
	if (cooldown_started[id] && (get_pcvar_float(g_shockwave_cooldown) >= 3.0)) //冷卻時間偌低於3秒鐘,不會顯示這個提示訊息
		client_print(id, print_center, "冷却时间%2.1f秒己过,你可以再使用碎裂震波了!", get_pcvar_float(g_shockwave_cooldown))
	
	cooldown_started[id] = false
}

public client_connect(id)
{
	use_shockwave[id] = false
	hit_key[id] = false
	cooldown_started[id] = false
	slowly_started[id] = false
	
	return PLUGIN_CONTINUE
}

public client_disconnect(id)
{
	use_shockwave[id] = false
	hit_key[id] = false
	cooldown_started[id] = false
	slowly_started[id] = false
	
	return PLUGIN_CONTINUE
}

public NewRound(id)
{
	use_shockwave[id] = false
	hit_key[id] = false
	cooldown_started[id] = false
	slowly_started[id] = false
}

public Death()
{
	new player = read_data(2)
	use_shockwave[player] = false
	hit_key[player] = false
	cooldown_started[player] = false
	slowly_started[player] = false
}

screen_shake(id, amplitude = 4, duration = 2, frequency = 10)
{
	message_begin(MSG_ONE_UNRELIABLE, g_msgScreenShake, _, id)
	write_short(UNIT_SECOND*amplitude) // 振幅
	write_short(UNIT_SECOND*duration) // 時間
	write_short(UNIT_SECOND*frequency) // 頻率
	message_end()
}

create_blast(const Float:originF[3], red, green, blue, brightness)
{
	// Smallest ring (小的光環)
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id (TE 的代碼)
	engfunc(EngFunc_WriteCoord, originF[0]) // x (X 座標)
	engfunc(EngFunc_WriteCoord, originF[1]) // y (X 座標)
	engfunc(EngFunc_WriteCoord, originF[2]) // z (Y 座標)
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis (X 軸)
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis (Y 軸)
	engfunc(EngFunc_WriteCoord, originF[2]+400.0) // z axis (Z 軸)
	write_short(g_shokewaveSpr) // sprite (Sprite 物件代碼)
	write_byte(0) // startframe (幀幅開始)
	write_byte(0) // framerate (幀幅頻率)
	write_byte(4) // life (時間長度)
	write_byte(60) // width (寬度)
	write_byte(0) // noise (響聲)
	write_byte(red) // red (顏色 R)
	write_byte(green) // green (顏色 G)
	write_byte(blue) // blue (顏色 B)
	write_byte(brightness) // brightness (顏色亮度)
	write_byte(0) // speed (速度)
	message_end()
	
	// Medium ring (中的光環)
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+300.0) // z axis
	write_short(g_shokewaveSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(red) // red
	write_byte(green) // green
	write_byte(blue) // blue
	write_byte(brightness) // brightness
	write_byte(0) // speed
	message_end()
	
	// Largest ring (大的光環)
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+200.0) // z axis
	write_short(g_shokewaveSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(red) // red
	write_byte(green) // green
	write_byte(blue) // blue
	write_byte(brightness) // brightness
	write_byte(0) // speed
	message_end()
}

PlaySound(id, const sound[])
{
	if (equal(sound[strlen(sound)-4], ".mp3"))
		client_cmd(id, "mp3 play ^"sound/%s^"", sound)
	else
		client_cmd(id, "spk ^"%s^"", sound)
}

stock set_speed_to_velocity(id, Float:scalar = 1.0)
{
	// Get our current velocity
	static Float:velocity[3]
	pev(id, pev_velocity, velocity)
	xs_vec_mul_scalar(velocity, scalar, velocity)
	set_pev(id, pev_velocity, velocity)
	
	return 1;
}

stock bool:is_user_on_ground(index)
{
	if (pev(index, pev_flags) & FL_ONGROUND)
		return true;
	
	return false;
}

stock fm_set_user_jump_velocity(index, jump_height)
{
	static Float:velocity[3]
	pev(index, pev_velocity, velocity)
	velocity[2] = float(jump_height)
	set_pev(index, pev_velocity, velocity)
	
	return 1;
}

stock fm_get_speed(entity)
{
	static Float:velocity[3]
	pev(entity, pev_velocity, velocity)
	
	return floatround(vector_length(velocity));
}

#if defined BOUNCE_EFFECT
stock get_speed_vector_to_entity(ent1, ent2, Float:speed, Float:new_velocity[3])
{
	if(!pev_valid(ent1) || !pev_valid(ent2))
		return 0;
	
	static Float:origin1[3]
	pev(ent1,pev_origin,origin1)
	static Float:origin2[3]
	pev(ent2,pev_origin,origin2)
	
	new_velocity[0] = origin2[0] - origin1[0];
	new_velocity[1] = origin2[1] - origin1[1];
	new_velocity[2] = origin2[2] - origin1[2];
	
	static Float:num
	num = speed / vector_length(new_velocity);
				
	new_velocity[0] *= num;
	new_velocity[1] *= num;
	new_velocity[2] *= num;
	
	return 1;
}
#endif

#if defined DROP_GUN
stock drop_current_weapon(id) 
{
	static weapon_id, clip, ammo
	weapon_id = get_user_weapon(id, clip, ammo)
	
	if (((1<<weapon_id) & PRIMARY_WEAPONS_BIT_SUM) || ((1<<weapon_id) & SECONDARY_WEAPONS_BIT_SUM))
	{
		static weapon_name[32]
		get_weaponname(weapon_id, weapon_name, sizeof weapon_name - 1)
		engclient_cmd(id, "drop", weapon_name)
	}
}
#endif
