/*================================================================================
	
	-----------------------------------
	-*- [ZP] Default Zombie Classes -*-
	-----------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	This plugin adds the default zombie classes to Zombie Plague.
	Feel free to modify their attributes to your liking.
	
	Note: If zombie classes are disabled, the first registered class
	will be used for all players (by default, Classic Zombie).
        修改：http://hi.baidu.com/199591015/blog
	
================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <zombieplague>

/*================================================================================
 [Plugin Customization]
=================================================================================*/

// Classic Zombie Attributes
new const zclass1_name[] = { "丧尸村民" }
new const zclass1_info[] = { "别小看他们..." }
new const zclass1_model[] = { "zombie_source" }
new const zclass1_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass1_health = 2800
const zclass1_speed = 190
const Float:zclass1_gravity = 1.0
const Float:zclass1_knockback = 1.0

// Raptor Zombie Attributes
new const zclass2_name[] = { "终极刺客" }
new const zclass2_info[] = { "生命II 速度MAX 反击退II" }
new const zclass2_model[] = { "zombie_source" }
new const zclass2_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass2_health = 2100
const zclass2_speed = 265
const Float:zclass2_gravity = 1.0
const Float:zclass2_knockback = 1.5

// Poison Zombie Attributes
new const zclass3_name[] = { "猎杀者" }
new const zclass3_info[] = { "生命III 跳跃IIII 反击退III" }
new const zclass3_model[] = { "zombie_source" }
new const zclass3_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass3_health = 2600
const zclass3_speed = 190
const Float:zclass3_gravity = 0.70
const Float:zclass3_knockback = 1.25

// Big Zombie Attributes
new const zclass4_name[] = { "丧尸村长" }
new const zclass4_info[] = { "生命MAX 速度I 反击退III" }
new const zclass4_model[] = { "zombie_source" }
new const zclass4_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass4_health = 3200
const zclass4_speed = 150
const Float:zclass4_gravity = 1.0
const Float:zclass4_knockback = 0.5

// Leech Zombie Attributes
new const zclass5_name[] = { "喋血亡灵" }
new const zclass5_info[] = { "生命III 感染加500血" }
new const zclass5_model[] = { "zombie_source" }
new const zclass5_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass5_health = 2100
const zclass5_speed = 190
const Float:zclass5_gravity = 1.0
const Float:zclass5_knockback = 1.25
const zclass5_infecthp = 500 // extra hp for infections

/*============================================================================*/

// Class IDs
new g_zclass_leech

// Zombie Classes MUST be registered on plugin_precache
public plugin_precache()
{
	register_plugin("[ZP] Default Zombie Classes", "4.3", "MeRcyLeZZ")
	
	// Register all classes
	zp_register_zombie_class(zclass1_name, zclass1_info, zclass1_model, zclass1_clawmodel, zclass1_health, zclass1_speed, zclass1_gravity, zclass1_knockback)
	zp_register_zombie_class(zclass2_name, zclass2_info, zclass2_model, zclass2_clawmodel, zclass2_health, zclass2_speed, zclass2_gravity, zclass2_knockback)
	zp_register_zombie_class(zclass3_name, zclass3_info, zclass3_model, zclass3_clawmodel, zclass3_health, zclass3_speed, zclass3_gravity, zclass3_knockback)
	zp_register_zombie_class(zclass4_name, zclass4_info, zclass4_model, zclass4_clawmodel, zclass4_health, zclass4_speed, zclass4_gravity, zclass4_knockback)
	g_zclass_leech = zp_register_zombie_class(zclass5_name, zclass5_info, zclass5_model, zclass5_clawmodel, zclass5_health, zclass5_speed, zclass5_gravity, zclass5_knockback)
}

// User Infected forward
public zp_user_infected_post(id, infector)
{
	// If attacker is a leech zombie, gets extra hp
	if (zp_get_user_zombie_class(infector) == g_zclass_leech)
		set_pev(infector, pev_health, float(pev(infector, pev_health) + zclass5_infecthp))
}
