/*==========================================================================
/
/				[ZP] Class : Zombie Regeneration
/				     ( Passive zombie skill )
/					   by The_Thing
/
/
/	Description :
/
/			This is another zombie class only this zombie are allowed to heal him self after certain time of amount he will be healing.
/			All can change by cvars.
/
/
/
/	Cvars :
/
/			zp_zclass_regen <1|0> - On or off, default is 1
/			zp_regen_time   "2"   - After how much seconds will be healing, default is after 2 seconds.
/			zp_regen_amount "25"  - How much HP you will gain in healing process, default is 25 hp in 2 seconds.
/
/
/
/	Credits :
/
/			hleV - For his created plugin.
/
/
/
/	Changelog :
/
/			06/11/2008 - v1.0 - First release
/
*/

#include <amxmodx>
#include <fakemeta>
#include <zombieplague>


new g_zclass_regen_toggle, g_time, g_amount

new const zclass8_name[] = { "不死亡灵" }
new const zclass8_info[] = { "速度III 回复生命" }
new const zclass8_model[] = { "zombie_source" }
new const zclass8_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass8_health = 2000
const zclass8_speed = 210
const Float:zclass8_gravity = 1.1
const Float:zclass8_knockback = 1.25

new g_zclass_Regen

public plugin_init() 
{
	g_zclass_regen_toggle = register_cvar("zp_zclass_regen", "1")
	g_time = register_cvar("zp_regen_time", "7")
	g_amount = register_cvar("zp_regen_amount", "20")
	
	register_event("Damage", "SetRegeneration", "be", "2>0")
}

public plugin_precache()
{
	register_plugin("[ZP] Zclass : Zombie Regenerator", "1.0", "The_Thing")
	
	g_zclass_Regen = zp_register_zombie_class(zclass8_name, zclass8_info, zclass8_model, zclass8_clawmodel, zclass8_health, zclass8_speed, zclass8_gravity, zclass8_knockback)
}

public SetRegeneration(player)
{
	if (!get_pcvar_num(g_zclass_regen_toggle) || !is_user_alive(player) || !zp_get_user_zombie(player))
	return PLUGIN_CONTINUE
	
	if (zp_get_user_zombie_class(player) != g_zclass_Regen)
	return PLUGIN_CONTINUE
	
	if (get_user_health(player) < zp_get_zombie_maxhealth(player))
		set_task(get_pcvar_float(g_time), "Regenerate", player, _, _, "b")
	
	return PLUGIN_CONTINUE
}

public Regenerate(player)
{
	if (!get_pcvar_num(g_zclass_regen_toggle) || !is_user_alive(player) || !zp_get_user_zombie(player))
	return PLUGIN_CONTINUE
	
	if (zp_get_user_zombie_class(player) != g_zclass_Regen)
	return PLUGIN_CONTINUE
	
	new regen_health = get_user_health(player)
	new max_health = zp_get_zombie_maxhealth(player) - regen_health
	
	if (max_health <= get_pcvar_num(g_amount))
	{
		set_pev(player, pev_health, regen_health + float(max_health))
		remove_task(player)
	}
	
	set_pev(player, pev_health, regen_health + get_pcvar_float(g_amount))
	
	return PLUGIN_CONTINUE
}

public zp_user_infected_post(player, infector)
{
	if (zp_get_user_zombie_class(infector) == g_zclass_Regen)
	{	
		new regen_health = get_user_health(player)
		new max_health = zp_get_zombie_maxhealth(player) - regen_health
	
		if (max_health <= get_pcvar_num(g_amount))
		{
			set_pev(infector, pev_health, regen_health + float(max_health))
			remove_task(infector)
			
			return PLUGIN_CONTINUE
		}
	
		set_pev(infector, pev_health, regen_health + get_pcvar_float(g_amount))
	}
	return PLUGIN_CONTINUE
}
