/*================================================================================
	
	---------------------------------
	-*- [提醒您] 自定义插件:心跳 1.0 -*-
	---------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	This plugin plays a heartbeat sound on humans when their health
	is under certain amount.
	
	~~~~~~~~~
	- CVARS -
	~~~~~~~~~
	
	* zp_heartbeat_hp <50> - Heartbeats start when HP is lower than this
	
	~~~~~~~~~~~~~~
	- Credits to -
	~~~~~~~~~~~~~~
	
	* ConnorMcLeod, AlexBreems: for the original plugin
	
================================================================================*/

#include <amxmodx>
#include <zombieplague>

/*================================================================================
 [Plugin Customization]
=================================================================================*/

// Sounds
new const g_heartbeat[] = "player/heartbeat1.wav"

/*============================================================================*/

new cvar_heartbeathp

public plugin_precache()
{
	precache_sound(g_heartbeat)
}

public plugin_init()
{
	register_plugin("[提醒您] Low HP Heartbeat", "1.0", "ConnorMcLeod/MeRcyLeZZ")
	
	register_event("Damage", "event_damage", "be", "2>0")
	register_event("DeathMsg", "event_deathmsg", "a")
	register_event("ResetHUD", "event_resethud", "be")
	register_event("Spectator", "event_spectator", "a")
	
	cvar_heartbeathp = register_cvar("zp_heartbeat_hp", "50")
}

public event_damage(id)
{
	if (get_user_health(id) > get_pcvar_num(cvar_heartbeathp) || zp_get_user_zombie(id))
		return;
	
	emit_sound(id, CHAN_STATIC, g_heartbeat, 0.0, 0.0, SND_STOP, PITCH_NORM)
	client_cmd(id, "spk %s", g_heartbeat)
}

public event_deathmsg()
{
	emit_sound(read_data(2), CHAN_STATIC, g_heartbeat, 0.0, 0.0, SND_STOP, PITCH_NORM)
}

public event_resethud(id)
{
	emit_sound(id, CHAN_STATIC, g_heartbeat, 0.0, 0.0, SND_STOP, PITCH_NORM)
}

public event_spectator()
{
	emit_sound(read_data(1), CHAN_STATIC, g_heartbeat, 0.0, 0.0, SND_STOP, PITCH_NORM)
}
