/*================================================================================
	
	-----------------------------------
	-*- [ZP] Zombie Classes Example -*-
	-----------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	This is just an example on how to add additional zombie classes to ZP.
	
================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <engine>
#include <fun>
#include <zombieplague>

// Zombie Attributes
new const zclass_name[] = { "神风僵尸" }
new const zclass_info[] = { "爆炸" }
new const zclass_model[] = { "zombie_source" }
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" }
const zclass_health = 500
const zclass_speed = 300
const Float:zclass_gravity = 1.0
const Float:zclass_knockback = 1.0

// Class IDs
new g_zkamikaze
new bool:haskamikaze[33] = false
new g_maxplayers
new cvar_radius
new cvar_ammoinfect
new g_msgDeathMsg

// the sprites, sounds, etc.
new const g_sndExplode[] = "weapons/c4_explode1.wav"
new explosion, g_exploSpr;
new const sprite_grenade_ring[] = "sprites/shockwave.spr"

public plugin_init()
{
	register_plugin("[ZP] Kamikaze Zombie", "0.1", "anggara_nothing")
	register_event("DeathMsg", "kamikaze_death", "a")
	cvar_radius = register_cvar("zp_zkamikaze_radius", "240")
	cvar_ammoinfect = get_cvar_pointer("zp_zombie_infect_reward")
	g_maxplayers = get_maxplayers()
	g_msgDeathMsg = get_user_msgid("DeathMsg")
}

// Zombie Classes MUST be registered on plugin_precache
public plugin_precache()
{	
	// Register the new class and store ID for reference
	g_zkamikaze = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)
	precache_sound(g_sndExplode)
	explosion = precache_model("sprites/zerogxplode.spr")
	g_exploSpr = engfunc(EngFunc_PrecacheModel, sprite_grenade_ring)
}

public zp_user_humanized_post(player)
{
	haskamikaze[player] = false
}

// User Infected forward
public zp_user_infected_post(id, infector)
{
	// Check if the infected player is using our custom zombie class
	if (zp_get_user_zombie_class(id) == g_zkamikaze)
	{
		set_user_rendering(id, kRenderFxGlowShell, 225, 0, 0, kRenderNormal, 16);
		client_print(id, print_chat, "[ZP]您使用的是神风特攻队僵尸.如果你可以爆炸死亡")
		haskamikaze[id] = true
	}
}

public zp_user_unfrozen(player)
{
	if (zp_get_user_zombie_class(player) == g_zkamikaze)
	{
		set_user_rendering(player, kRenderFxGlowShell, 225, 0, 0, kRenderNormal, 16);
	}
}

public kamikaze_death()
{
	static id;
	//new attacker = read_data(1)
	new victim = read_data(2)
	
	if(!haskamikaze[victim])
		return PLUGIN_CONTINUE;
		
	if (zp_get_user_zombie_class(victim) != g_zkamikaze || !zp_get_user_zombie(victim) || zp_get_user_nemesis(victim))
		return PLUGIN_CONTINUE;
	
	// Get origin
	static Float:originF[3]
	pev(victim, pev_origin, originF)
	
	// Custom explosion effect
	create_blast2(originF)
	
	// Napalm explosion sound
	engfunc(EngFunc_EmitSound, victim, CHAN_STATIC, g_sndExplode, 1.0, ATTN_NORM, 0, PITCH_NORM)
	
	for(id = 1; id <= g_maxplayers; id++)
	{
		while ((id = engfunc(EngFunc_FindEntityInSphere, id, originF, get_pcvar_float(cvar_radius))) != 0)
		{
			if (!is_user_alive(id) || zp_get_user_zombie(id) || zp_get_user_nemesis(id))
				return PLUGIN_CONTINUE;
			
			new Float:fOrigin[3]
			new iOrigin[3]
			entity_get_vector(id, EV_VEC_origin, fOrigin)
			FVecIVec(fOrigin,iOrigin)
			{
				message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
				write_byte(3) //TE_EXPLOSION
				write_coord(iOrigin[0])
				write_coord(iOrigin[1])
				write_coord(iOrigin[2] + 5)
				write_short(explosion)
				write_byte(30)
				write_byte(15)
				write_byte(0)
				message_end()
			}
			
			SendDeathMsg(victim, id)
			user_kill(id, 0)
			zp_set_user_ammo_packs(victim,zp_get_user_ammo_packs(victim) + get_pcvar_num(cvar_ammoinfect))
			haskamikaze[victim] = false
		}
	}
	return PLUGIN_CONTINUE;
}

create_blast2(const Float:originF[3])
{
	// Smallest ring
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+385.0) // z axis
	write_short(g_exploSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(200) // red
	write_byte(100) // green
	write_byte(0) // blue
	write_byte(200) // brightness
	write_byte(0) // speed
	message_end()
	
	// Medium ring
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+470.0) // z axis
	write_short(g_exploSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(200) // red
	write_byte(50) // green
	write_byte(0) // blue
	write_byte(200) // brightness
	write_byte(0) // speed
	message_end()
	
	// Largest ring
	engfunc(EngFunc_MessageBegin, MSG_PVS, SVC_TEMPENTITY, originF, 0)
	write_byte(TE_BEAMCYLINDER) // TE id
	engfunc(EngFunc_WriteCoord, originF[0]) // x
	engfunc(EngFunc_WriteCoord, originF[1]) // y
	engfunc(EngFunc_WriteCoord, originF[2]) // z
	engfunc(EngFunc_WriteCoord, originF[0]) // x axis
	engfunc(EngFunc_WriteCoord, originF[1]) // y axis
	engfunc(EngFunc_WriteCoord, originF[2]+555.0) // z axis
	write_short(g_exploSpr) // sprite
	write_byte(0) // startframe
	write_byte(0) // framerate
	write_byte(4) // life
	write_byte(60) // width
	write_byte(0) // noise
	write_byte(200) // red
	write_byte(0) // green
	write_byte(0) // blue
	write_byte(200) // brightness
	write_byte(0) // speed
	message_end()
}

public SendDeathMsg(attacker, victim)
{
	message_begin(MSG_BROADCAST, g_msgDeathMsg)
	write_byte(attacker) // killer
	write_byte(victim) // victim
	write_byte(1) // headshot flag
	write_string("grenade") // killer's weapon
	message_end()
}

