/*================================================================================
	
	---------------------------------
	-*- [CS插件专区提醒您] 自定义插件:回合结束 1.0 -*-
	---------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	If round ends and neither of the teams win, players will get killed by
	a large blast over the map, at the best Resident Evil style.
	
	~~~~~~~~~
	- CVARS -
	~~~~~~~~~
	
	* zp_blast_keepfrags <1/0> - Should players keep their frags when dying
	
================================================================================*/

#include <amxmodx>
#include <zombieplague>

/*================================================================================
 [Plugin Customization]
=================================================================================*/

// Notice shown to players before the blast
new const warning_notice[] = { "阳伞公司向这个地区投放了核弹..." }

// Sounds
new const sound_siren[] = { "vox/bizwarn.wav" }
new const sound_launch[] = { "weapons/mortar.wav" }
new const sound_blast[] = { "weapons/mortarhit.wav" }

/*============================================================================*/

const BLAST_TASK = 5000
new cvar_keepfrags, g_msgScreenFade, g_msgDeathMsg

public plugin_precache()
{
	precache_sound(sound_siren)
	precache_sound(sound_launch)
	precache_sound(sound_blast)
}

public plugin_init()
{
	register_plugin("[CS插件专区提醒您] Round Draw Blast", "1.0", "MeRcyLeZZ")
	
	register_event("HLTV", "event_round_start", "a", "1=0", "2=0")
	
	cvar_keepfrags = register_cvar("zp_blast_keepfrags", "1")
	
	g_msgScreenFade = get_user_msgid("ScreenFade")
	g_msgDeathMsg = get_user_msgid("DeathMsg")
}

public event_round_start()
{
	// Bugfix
	remove_task(BLAST_TASK)
}

public zp_round_ended(winteam)
{
	// No one won
	if (winteam == WIN_NO_ONE)
	{
		// Show notice
		client_print(0, print_chat, "[CS插件专区提醒您] %s", warning_notice)
		
		// Remove previous tasks and set the new ones
		remove_task(BLAST_TASK)
		set_task(0.1, "task_siren", BLAST_TASK)
		set_task(0.8, "task_launch", BLAST_TASK)
		set_task(2.5, "task_blast", BLAST_TASK)
	}
}

public task_siren()
{
	// Siren sound
	client_cmd(0, "spk %s", sound_siren)
}

public task_launch()
{
	// Launch sound
	client_cmd(0, "spk %s", sound_launch)
	
	// Screen fade effect
	message_begin(MSG_BROADCAST, g_msgScreenFade)
	write_short((1<<12)*4)	// Duration
	write_short((1<<12)*1)	// Hold time
	write_short(0x0001)	// Fade type
	write_byte (255)	// Red
	write_byte (255)	// Green
	write_byte (255)	// Blue
	write_byte (255)	// Alpha
	message_end()
}

public task_blast()
{
	// Blast sound
	client_cmd(0, "spk %s", sound_blast)
	
	static id, deathmsg_block
	
	// Get current blocking state of the deathmsg
	deathmsg_block = get_msg_block(g_msgDeathMsg)
	
	// Set it to blocked
	set_msg_block(g_msgDeathMsg, BLOCK_SET)
	
	// "Eliminate" players
	for (id = 1; id <= 32; id++)
		if (is_user_alive(id))
			user_kill(id, get_pcvar_num(cvar_keepfrags))
	
	// Set the previous blocking state
	set_msg_block(g_msgDeathMsg, deathmsg_block)
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang3082\\ f0\\ fs16 \n\\ par }
*/
