/*================================================================================
	
	----------------------------------
	-*- [ZP] 攻击移动物体 1.0 -*-
	----------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	This is just a conversion of Biohazard's object shooting feature to ZP.
	It allows humans to move func_pushables around by shooting them from a
	distance. Zombies can do the same by slashing them with the knife.
	
	~~~~~~~~~
	- CVARS -
	~~~~~~~~~
	
	* zp_pushpwr_humans <2.0> - How strong humans shoot objects away
	* zp_pushpwr_zombies <5.0> - How strong zombies shoot objects away
	* zp_push_momentum <0/1> - Convey pushable's velocity to other
	   players/entities when they collide (looks more realistic)
	
================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <xs>
#include <zombieplague>

new cvar_pushpwr_humans, cvar_pushpwr_zombies, cvar_push_momentum

public plugin_init()
{
	register_plugin("[ZP] Shootable Objects", "1.0", "MeRcyLeZZ")
	
	cvar_pushpwr_humans = register_cvar("zp_pushpwr_humans", "2.0")
	cvar_pushpwr_zombies = register_cvar("zp_pushpwr_zombies", "5.0")
	cvar_push_momentum = register_cvar("zp_push_momentum", "1")
	
	RegisterHam(Ham_TraceAttack, "func_pushable", "fw_TraceAttack_Pushable")
	RegisterHam(Ham_Touch, "func_pushable", "fw_Touch_Pushable")
}

public fw_TraceAttack_Pushable(ent, attacker, Float:damage, Float:direction[3])
{
	// Non-player attacker
	if (!is_user_connected(attacker))
		return;
	
	// Get object's velocity
	static Float:velocity[3]
	pev(ent, pev_velocity, velocity)
	
	// Calculate velocity based on direction, damage and multipliers
	xs_vec_mul_scalar(direction, damage, direction)
	xs_vec_mul_scalar(direction, zp_get_user_zombie(attacker) ? get_pcvar_float(cvar_pushpwr_zombies) : get_pcvar_float(cvar_pushpwr_humans), direction)
	
	// Add up the new vector
	xs_vec_add(velocity, direction, direction)
	
	// Vertical velocity shouldn't be affected
	direction[2] = velocity[2]
	
	// Set the final velocity
	set_pev(ent, pev_velocity, direction)
}

public fw_Touch_Pushable(self, other)
{
	// Momentum cvar disabled or touching an invalid entity
	if (!get_pcvar_num(cvar_push_momentum) || !pev_valid(other))
		return;
	
	// Get object's velocity
	static Float:velocity1[3]
	pev(self, pev_velocity, velocity1)
	
	// Transfer velocity (if any) to the colliding entity
	if (vector_length(velocity1) > 0.0)
	{
		static Float:velocity2[3]
		pev(other, pev_velocity, velocity2)
		velocity2[0] += velocity1[0]
		velocity2[1] += velocity1[1]
		set_pev(other, pev_velocity, velocity2)
	}
}
