﻿/*================================================================================
	
	-----------------------------------
	-*- [ZP] Zombie Classes Example -*-
	-----------------------------------
	
	~~~~~~~~~~~~~~~
	- Description -
	~~~~~~~~~~~~~~~
	
	This is just an example on how to add additional zombie classes in ZP.
	
================================================================================*/

#include <amxmodx>
#include <fakemeta>
#include <zombieplague>
#include <fun>
#define PLUGIN    "Test"
#define AUTHOR    "Jim"
#define VERSION    "1.0"
new pchp
new pcmaxhp
new pct
new task[33]
new g_zclassid_hpplus

// Zombie Attributes
new const zclass_name[] = { "自愈僵尸" } // 名字
new const zclass_info[] = { "|HP-|每秒8回复生命|" } // 描述
new const zclass_model[] = { "zombie_source" } // model
new const zclass_clawmodel[] = { "v_knife_zombie.mdl" } // claw model
const zclass_health = 1800 // health
const zclass_speed = 220 // speed
const Float:zclass_gravity = 1.0 // gravity
const Float:zclass_knockback = 1.0 // knockback


// Zombie Classes MUST be registered on plugin_precache
public plugin_precache()
{
	register_plugin("[ZP]Zombie hp Plus", "0.1", "HPplus")
	
	// Register the new class and store ID for reference
	g_zclassid_hpplus = zp_register_zombie_class(zclass_name, zclass_info, zclass_model, zclass_clawmodel, zclass_health, zclass_speed, zclass_gravity, zclass_knockback)	
}

public plugin_init()
{
    register_plugin(PLUGIN, VERSION, AUTHOR)
    pchp = register_cvar("recover_hp", "100")           //1次恢复多少
    pcmaxhp = register_cvar("recover_maxhp", "50000")   //恢复最高
    pct = register_cvar("recover_interval", "8")      //恢复间隔
    register_event("Damage", "event_damage", "be")
    register_event("DeathMsg", "event_death", "a")
}
public client_disconnect(id)
{
    remove_task(id)
    task[id] = 0
}
public event_death()
{
    new id = read_data(2)
    remove_task(id)
    task[id] = 0
}
public event_damage(id)
{
    if(!task[id])
    {
        task[id] = set_task(float(get_pcvar_num(pct)), "addhp", id, _, _, "b")
    }
}
public addhp(id)
{
    new maxhp = get_pcvar_num(pcmaxhp)
    new hp = get_user_health(id) + get_pcvar_num(pchp)
    if(hp < maxhp)
    {
        set_user_health(id, hp)
    }
    else
    {
        set_user_health(id, maxhp)
        remove_task(id)
        task[id] = 0
    }
}


// User Infected forward
public zp_user_infected_post(id, infector)
{
	// Check if the infected player is using our custom zombie class
	if (zp_get_user_zombie_class(id) == g_zclassid_hpplus)
		client_print(id, print_chat, "[ZP] 你现在是自愈僵尸!")
}
