#ifndef RZ_CONFIGURE_H
#define RZ_CONFIGURE_H

#include "rz_version.h"

#define RZ_CHECKS_LEVEL             1
#define DEBUGGER                    1
#define HAVE_DECL_ADDR_NO_RANDOMIZE 0
#define HAVE_DECL_PROCCTL_ASLR_CTL  0
#define HAVE_ARC4RANDOM_UNIFORM     0
#define HAVE_EXPLICIT_BZERO         0
#define HAVE_EXPLICIT_MEMSET        0
#define HAVE_CLOCK_NANOSLEEP        0
#define HAVE_SIGACTION              0
#define HAVE_PIPE                   0
#define HAVE_EXECV                  0
#define HAVE_EXECVE                 0
#define HAVE_EXECVP                 0
#define HAVE_EXECL                  0
#define HAVE_SYSTEM                 1
#define HAVE_PIPE2                  0
#define HAVE_ENVIRON                0
#define HAVE_OPENPTY                0
#define HAVE_FORKPTY                0
#define HAVE_LOGIN_TTY              0
#define HAVE_SHM_OPEN               0
#define HAVE_LIB_MAGIC              0
#define USE_LIB_MAGIC               0
#define HAVE_LIB_XXHASH             1
#define USE_LIB_XXHASH              1
#define HAVE_LIB_SSL                0
#define HAVE_LIBUV                  1
#define HAVE_PTRACE                 0
#define USE_PTRACE_WRAP             0
#define HAVE_FORK                   0
#define HAVE_STRLCPY                0
#define WANT_DYLINK                 1
#define WITH_GPL                    1
#define HAVE_JEMALLOC               0
#define IS_IOS                      0
#define RZ_BUILD_DEBUG              0

#define RZ_IS_PORTABLE 1

#define RZ_PREFIX  "D:/a/cutter/cutter/build/"
#define RZ_BINDIR  "."
#define RZ_LIBDIR  "lib"
#define RZ_INCDIR  "include/librz"
#define RZ_DATDIR  "share"
#define RZ_WWWROOT "share/www"

#define RZ_PLUGINS   "lib/plugins"
#define RZ_EXTRAS    "lib/extras"
#define RZ_BINDINGS  "lib/bindings"
#define RZ_DATDIR_RZ "share/"
#define RZ_SDB       "share/"
#define RZ_ZIGNS     "share/zigns"
#define RZ_THEMES    "share/cons"
#define RZ_FORTUNES  "share/fortunes"
#define RZ_FLAGS     "share/flag"
#define RZ_HUD       "share/hud"

#define RZ_SDB_TYPES   RZ_JOIN_2_PATHS(RZ_SDB, "types")
#define RZ_SDB_OPCODES RZ_JOIN_2_PATHS(RZ_SDB, "opcodes")
#define RZ_SDB_MAGIC   RZ_JOIN_2_PATHS(RZ_SDB, "magic")
#define RZ_SDB_FORMAT  RZ_JOIN_2_PATHS(RZ_SDB, "format")

#define RZ_HOME_CONFIGDIR RZ_JOIN_2_PATHS(".config", "rizin")
#define RZ_HOME_DATADIR   RZ_JOIN_3_PATHS(".local", "share", "rizin")
#define RZ_HOME_CACHEDIR  RZ_JOIN_2_PATHS(".cache", "rizin")

#define RZ_HOME_THEMES      RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "cons")
#define RZ_HOME_PLUGINS     RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "plugins")
#define RZ_HOME_ZIGNS       RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "zigns")
#define RZ_HOME_PDB         RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "pdb")
#define RZ_HOME_PROJECTS    RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "projects")
#define RZ_HOME_WWWROOT     RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "www")
#define RZ_HOME_SDB_TYPES   RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "types")
#define RZ_HOME_SDB_FORMAT  RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "format")
#define RZ_HOME_HUD         RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "hud")
#define RZ_HOME_BINRC       RZ_JOIN_2_PATHS(RZ_HOME_DATADIR, "rc.d")
#define RZ_HOME_BIN         RZ_JOIN_3_PATHS(RZ_HOME_DATADIR, "prefix", "bin")

#define RZ_HOME_HISTORY RZ_JOIN_2_PATHS(RZ_HOME_CACHEDIR, "history")

#define RZ_HOME_RC     RZ_JOIN_2_PATHS(RZ_HOME_CONFIGDIR, "rizinrc")
#define RZ_HOME_RC_DIR RZ_JOIN_2_PATHS(RZ_HOME_CONFIGDIR, "rizinrc.d")
#define RZ_GLOBAL_RC   RZ_JOIN_2_PATHS(RZ_DATDIR_RZ, "rizinrc")

#endif
