#!/bin/bash
PATH=/bin
export PATH
prefix=/usr
bindir=${prefix}/bin
sbindir=${prefix}/sbin

if [ ! -f /etc/X11/app-defaults/URxvt ]
then
    /usr/bin/mkdir -p /etc/X11/app-defaults
    /usr/bin/cp /etc/defaults/etc/X11/app-defaults/URxvt /etc/X11/app-defaults/URxvt
fi

################################################################
# Shortcuts
################################################################
do_mkshortcut() {
    AP=$1
    SM=$(/usr/bin/cygpath $AP)
    /usr/bin/mkdir -p "$SM/Cygwin" && \
        /usr/bin/rm -f "$SM/Cygwin/rxvt-unicode-xC.lnk" && \
    /usr/bin/mkshortcut $AP -n "Cygwin/rxvt-unicode-xC" \
        -d "Cygwin RXVT Unicode Client (X11)" \
        -w /usr/bin -i /usr/bin/cygicons-0.dll -j 9 \
        -a '-display 127.0.0.1:0.0 -ls -e /bin/bash --login' \
        /usr/bin/urxvtc-X.exe && \
    /usr/bin/chmod go+r "$SM/Cygwin/rxvt-unicode-xC.lnk" && \
        /usr/bin/rm -f "$SM/Cygwin/rxvt-unicode-xS.lnk" && \
    /usr/bin/mkshortcut $AP -n "Cygwin/rxvt-unicode-xS" \
        -d "Cygwin RXVT Unicode Standalone (X11)" \
        -w /usr/bin -i /usr/bin/cygicons-0.dll -j 6 \
        -a '-display 127.0.0.1:0.0 -ls -e /bin/bash --login' \
        /usr/bin/urxvt-X.exe && \
    /usr/bin/chmod go+r "$SM/Cygwin/rxvt-unicode-xS.lnk"
}
do_mkshortcut -AP || do_mkshortcut -P

################################################################
# Alternatives (eventually to be used in conjunction with
# additional versions of rxvt-unicode).
################################################################
${sbindir}/update-alternatives \
        --install ${bindir}/urxvt   urxvt   ${bindir}/urxvt-X.exe   30 \
        --slave   ${bindir}/urxvtc  urxvtc  ${bindir}/urxvtc-X.exe \
        --slave   ${bindir}/urxvtd  urxvtd  ${bindir}/urxvtd-X.exe

