#!/bin/bash
PATH=/bin
export PATH
prefix=/usr
sbindir=${prefix}/sbin
bindir=${prefix}/bin

if [ -f /etc/X11/app-defaults/URxvt ] && cmp -s /etc/defaults/etc/X11/app-defaults/URxvt /etc/X11/app-defaults/URxvt
then
    rm /etc/X11/app-defaults/URxvt
fi

do_rmshortcut() {
    AP=$1
    if [ -e "$(cygpath $AP)/Cygwin/rxvt-unicode-xC.lnk" ]
    then
        rm -f "$(cygpath $AP)/Cygwin/rxvt-unicode-xC.lnk" 
        rm -f "$(cygpath $AP)/Cygwin/rxvt-unicode-xS.lnk"
        rmdir --ignore-fail-on-non-empty "$(cygpath $AP)/Cygwin"
        true
    else
        false
    fi
}
do_rmshortcut -AP || do_rmshortcut -P

${sbindir}/update-alternatives --remove urxvt ${bindir}/urxvt-X.exe

