#!/bin/bash
PATH=/bin
export PATH

D=/usr/share/doc/rxvt-unicode/terminfo
TERMINFO_FILE1=${D}/rxvt-unicode.terminfo
TERMINFO_FILE2=${D}/rxvt-unicode256.terminfo
TERMCAP_FILE=${D}/rxvt-unicode.termcap

if [ -x "/usr/bin/tic.exe" -a -e ${TERMINFO_FILE1} ]
then
  /usr/bin/tic.exe ${TERMINFO_FILE1}
  /usr/bin/tic.exe ${TERMINFO_FILE2}
fi
if [ -x "/usr/bin/tic0.exe" -a -e ${TERMINFO_FILE1} ]
then
  /usr/bin/tic0.exe ${TERMINFO_FILE1}
  /usr/bin/tic0.exe ${TERMINFO_FILE2}
fi

if [ -e /etc/termcap ] ; then
  if ! grep -E '^rxvt-unicode\|' /etc/termcap >/dev/null 2>&1 ; then
    cat ${TERMCAP_FILE} >> /etc/termcap
    cat >>/etc/termcap <<EOF
rxvt-unicode256|rxvt-unicode terminal (X Window System):\\
	:tc=rxvt-unicode:
EOF
  fi
else
  cat ${TERMCAP_FILE} > /etc/termcap
  cat >>/etc/termcap <<EOF
rxvt-unicode256|rxvt-unicode terminal (X Window System):\\
	:tc=rxvt-unicode:
EOF
fi

