/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.about;

import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.InformationDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class AboutBoxDialog
extends InformationDialog {
    public static final String PRODUCT_PROP_SUB_TITLE = "subTitle";
    public static final String PRODUCT_PROP_COPYRIGHT = "copyright";
    public static final String PRODUCT_PROP_WEBSITE = "website";
    public static final String PRODUCT_PROP_EMAIL = "email";
    private final Font NAME_FONT;
    private final Font TITLE_FONT;
    private static final Log log = Log.getLog(AboutBoxDialog.class);
    private Image ABOUT_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)Platform.getProduct().getDefiningBundle().getSymbolicName(), (String)"icons/dbeaver_about.png").createImage();
    private Image splashImage;

    public AboutBoxDialog(Shell shell) {
        super(shell);
        this.NAME_FONT = new Font((Device)shell.getDisplay(), CoreMessages.dialog_about_font, 14, 1);
        this.TITLE_FONT = new Font((Device)shell.getDisplay(), CoreMessages.dialog_about_font, 10, 0);
    }

    protected boolean isBanner() {
        return true;
    }

    public boolean close() {
        this.NAME_FONT.dispose();
        this.TITLE_FONT.dispose();
        if (this.splashImage != null) {
            UIUtils.dispose((Resource)this.splashImage);
            this.splashImage = null;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CoreMessages.dialog_about_title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Label imageLabel;
        GridData gd;
        IProduct product;
        Composite group;
        Color background;
        block15: {
            background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
            parent.setBackground(background);
            group = new Composite(parent, 0);
            group.setBackground(background);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 20;
            layout.marginWidth = 20;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            product = Platform.getProduct();
            Label nameLabel = new Label(group, 0);
            nameLabel.setBackground(background);
            nameLabel.setFont(this.NAME_FONT);
            nameLabel.setText(product.getName());
            gd = new GridData(768);
            gd.horizontalAlignment = 2;
            nameLabel.setLayoutData((Object)gd);
            Label titleLabel = new Label(group, 0);
            titleLabel.setBackground(background);
            titleLabel.setFont(this.TITLE_FONT);
            titleLabel.setText(product.getProperty(PRODUCT_PROP_SUB_TITLE));
            gd = new GridData(768);
            gd.horizontalAlignment = 2;
            titleLabel.setLayoutData((Object)gd);
            titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    BusyIndicator.showWhile((Display)AboutBoxDialog.this.getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IHandlerService service = (IHandlerService)workbenchWindow.getService(IHandlerService.class);
                            if (service != null) {
                                try {
                                    service.executeCommand("org.eclipse.ui.help.installationDialog", null);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    });
                }
            });
            imageLabel = new Label(group, 0);
            imageLabel.setBackground(background);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 2;
            gd.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)gd);
            if (this.splashImage == null) {
                try {
                    URL splashResource = ApplicationRegistry.getInstance().getApplication().getContributorBundle().getResource("splash.bmp");
                    if (splashResource == null) break block15;
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (InputStream is = splashResource.openStream();){
                        Image img = new Image((Device)this.getShell().getDisplay(), is);
                        this.splashImage = new Image(img.getDevice(), 400, 200);
                        GC gc = new GC((Drawable)this.splashImage);
                        gc.setAntialias(1);
                        gc.setInterpolation(2);
                        gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, 0, 0, this.splashImage.getBounds().width, this.splashImage.getBounds().height);
                        gc.dispose();
                        img.dispose();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            }
        }
        if (this.splashImage != null) {
            imageLabel.setImage(this.splashImage);
        } else {
            imageLabel.setImage(this.ABOUT_IMAGE);
        }
        Text versionLabel = new Text(group, 0);
        versionLabel.setEditable(false);
        versionLabel.setBackground(background);
        versionLabel.setText(String.valueOf(CoreMessages.dialog_about_label_version) + GeneralUtils.getProductVersion().toString());
        gd = new GridData(768);
        gd.horizontalAlignment = 2;
        versionLabel.setLayoutData((Object)gd);
        Label releaseTimeLabel = new Label(group, 0);
        releaseTimeLabel.setBackground(background);
        releaseTimeLabel.setText("Release date: " + DateFormat.getDateInstance(1).format(GeneralUtils.getProductReleaseDate()));
        gd = new GridData(768);
        gd.horizontalAlignment = 2;
        releaseTimeLabel.setLayoutData((Object)gd);
        Label authorLabel = new Label(group, 0);
        authorLabel.setBackground(background);
        authorLabel.setText(product.getProperty(PRODUCT_PROP_COPYRIGHT));
        gd = new GridData(768);
        gd.horizontalAlignment = 2;
        authorLabel.setLayoutData((Object)gd);
        Link siteLink = UIUtils.createLink((Composite)group, (String)UIUtils.makeAnchor((String)product.getProperty(PRODUCT_PROP_WEBSITE)), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)e.text);
            }
        });
        siteLink.setBackground(background);
        gd = new GridData();
        gd.horizontalAlignment = 2;
        siteLink.setLayoutData((Object)gd);
        String infoDetails = DBWorkbench.getPlatform().getApplication().getInfoDetails();
        if (!CommonUtils.isEmpty((String)infoDetails)) {
            Text extraText = new Text(group, 2634);
            extraText.setLayoutData((Object)new GridData(768));
            extraText.setText(infoDetails);
        }
        return parent;
    }
}

