/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.parts;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2dl.ColorConstants;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.gef3.DefaultEditDomain;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.GraphicalViewer;
import org.eclipse.gef3.commands.CommandStack;
import org.eclipse.gef3.commands.CommandStackListener;
import org.eclipse.gef3.ui.actions.ActionRegistry;
import org.eclipse.gef3.ui.actions.DeleteAction;
import org.eclipse.gef3.ui.actions.PrintAction;
import org.eclipse.gef3.ui.actions.RedoAction;
import org.eclipse.gef3.ui.actions.SaveAction;
import org.eclipse.gef3.ui.actions.SelectAllAction;
import org.eclipse.gef3.ui.actions.UndoAction;
import org.eclipse.gef3.ui.actions.UpdateAction;
import org.eclipse.gef3.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef3.ui.parts.SelectionSynchronizer;
import org.eclipse.gef3.ui.properties.UndoablePropertySheetPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class GraphicalEditor
extends EditorPart
implements CommandStackListener,
ISelectionListener {
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private SelectionSynchronizer synchronizer;
    private List selectionActions = new ActionIDList();
    private List stackActions = new ActionIDList();
    private List propertyActions = new ActionIDList();

    @Override
    public void commandStackChanged(EventObject event) {
        this.updateActions(this.stackActions);
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Action action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new SelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new DeleteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SaveAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getPropertyActions().add(action.getId());
        registry.registerAction((IAction)new PrintAction((IWorkbenchPart)this));
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer(viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public void createPartControl(Composite parent) {
        this.createGraphicalViewer(parent);
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getEditDomain().setActiveTool(null);
        this.getActionRegistry().dispose();
        super.dispose();
    }

    public void doSaveAs() {
        throw new RuntimeException("doSaveAs must be overridden");
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updateActions(this.propertyActions);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new UndoablePropertySheetPage(this.getCommandStack(), this.getActionRegistry().getAction(ActionFactory.UNDO.getId()), this.getActionRegistry().getAction(ActionFactory.REDO.getId()));
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)((Object)this.getGraphicalViewer().getRootEditPart())).getFigure();
        }
        return super.getAdapter(type);
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected List getPropertyActions() {
        return this.propertyActions;
    }

    protected List getSelectionActions() {
        return this.selectionActions;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected List getStackActions() {
        return this.stackActions;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer(this.getGraphicalViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.getCommandStack().addCommandStackListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.initializeActionRegistry();
    }

    protected void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    protected abstract void initializeGraphicalViewer();

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.equals(this.getSite().getPage().getActiveEditor())) {
            this.updateActions(this.selectionActions);
        }
    }

    protected void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        this.editDomain = ed;
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        this.getEditDomain().addViewer(viewer);
        this.graphicalViewer = viewer;
    }

    protected void updateActions(List actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        Iterator iter = actionIds.iterator();
        while (iter.hasNext()) {
            IAction action = registry.getAction(iter.next());
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    private static class ActionIDList
    extends ArrayList {
        private ActionIDList() {
        }

        @Override
        public boolean add(Object o) {
            if (o instanceof IAction) {
                try {
                    IAction action = (IAction)o;
                    o = action.getId();
                    throw new IllegalArgumentException("Action IDs should be added to lists, not the action: " + action);
                }
                catch (IllegalArgumentException exc) {
                    exc.printStackTrace();
                }
            }
            return super.add(o);
        }
    }
}

