/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingNested;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeBindingElement
extends DBDAttributeBindingNested
implements DBPImageProvider {
    @NotNull
    private final DBDCollection collection;
    private final int index;

    public DBDAttributeBindingElement(@NotNull DBDAttributeBinding parent, @NotNull DBDCollection collection, int index) {
        super(parent, collection.getComponentValueHandler());
        this.collection = collection;
        this.index = index;
    }

    @Override
    public int getOrdinalPosition() {
        return 0;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public boolean isPseudoAttribute() {
        return false;
    }

    @Override
    @Nullable
    public DBDCollection getSource() {
        return this.collection;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.getName();
    }

    @Override
    @Nullable
    public String getEntityName() {
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return String.valueOf(this.index + 1);
    }

    @Override
    @Nullable
    public DBSEntityAttribute getEntityAttribute() {
        return null;
    }

    @Override
    @Nullable
    public Object extractNestedValue(@NotNull Object ownerValue) throws DBCException {
        if (this.collection.isNull()) {
            return null;
        }
        if (ownerValue instanceof DBDCollection) {
            return ((DBDCollection)ownerValue).get(this.index);
        }
        return this.collection.getItem(this.index);
    }

    @Override
    public String getTypeName() {
        return this.collection.getComponentType().getTypeName();
    }

    @Override
    public String getFullTypeName() {
        return DBUtils.getFullTypeName(this.collection.getComponentType());
    }

    @Override
    public int getTypeID() {
        return this.collection.getComponentType().getTypeID();
    }

    @Override
    public DBPDataKind getDataKind() {
        return this.collection.getComponentType().getDataKind();
    }

    @Override
    public Integer getScale() {
        return this.collection.getComponentType().getScale();
    }

    @Override
    public Integer getPrecision() {
        return this.collection.getComponentType().getPrecision();
    }

    @Override
    public long getMaxLength() {
        return this.collection.getComponentType().getMaxLength();
    }

    @Override
    public long getTypeModifiers() {
        return this.collection.getComponentType().getTypeModifiers();
    }

    @Override
    @Nullable
    public DBPImage getObjectImage() {
        return DBValueFormatting.getObjectImage(this.collection.getComponentType());
    }

    @Override
    public String toString() {
        return String.valueOf(this.collection.toString()) + "@" + this.index;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof DBDAttributeBindingElement && CommonUtils.equalObjects((Object)this.collection, (Object)((DBDAttributeBindingElement)obj).collection) && this.index == ((DBDAttributeBindingElement)obj).index;
    }

    public int hashCode() {
        return this.collection.hashCode() + this.index;
    }
}

