/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHAgentIdentity;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementation;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationDescriptor;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class SSHImplementationAbstract
implements SSHImplementation {
    private static final Log log = Log.getLog(SSHImplementationAbstract.class);
    private transient int savedLocalPort = 0;
    protected transient DBWHandlerConfiguration savedConfiguration;
    protected transient DBPConnectionConfiguration savedConnectionInfo;
    protected AgentProxy agentProxy = null;

    @Override
    public DBPConnectionConfiguration initTunnel(DBRProgressMonitor monitor, DBPPlatform platform, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        String prefix;
        String dbPortString = connectionInfo.getHostPort();
        if (CommonUtils.isEmpty((String)dbPortString) && CommonUtils.isEmpty((String)(dbPortString = configuration.getDriver().getDefaultPort()))) {
            throw new DBException("Database port not specified and no default port number for driver '" + configuration.getDriver().getName() + "'");
        }
        int connectTimeout = configuration.getIntProperty("sshConnectTimeout");
        String sshLocalHost = CommonUtils.toString((Object)configuration.getProperty("localHost"));
        int sshLocalPort = configuration.getIntProperty("localPort");
        String sshRemoteHost = CommonUtils.toString((Object)configuration.getProperty("remoteHost"));
        int sshRemotePort = configuration.getIntProperty("remotePort");
        if (sshLocalPort == 0) {
            if (this.savedLocalPort != 0) {
                sshLocalPort = this.savedLocalPort;
            } else if (platform != null) {
                sshLocalPort = SSHUtils.findFreePort(platform);
            }
        }
        if (CommonUtils.isEmpty((String)sshRemoteHost)) {
            sshRemoteHost = connectionInfo.getHostName();
        }
        if (sshRemotePort == 0 && configuration.getDriver() != null) {
            sshRemotePort = CommonUtils.toInt((Object)connectionInfo.getHostPort());
        }
        if (connectTimeout == 0) {
            configuration.setProperty("sshConnectTimeout", (Object)10000);
        }
        SSHPortForwardConfiguration portForwardConfiguration = new SSHPortForwardConfiguration(sshLocalHost, sshLocalPort, sshRemoteHost, sshRemotePort);
        ArrayList<SSHHostConfiguration> hostConfigurations = new ArrayList<SSHHostConfiguration>();
        hostConfigurations.add(SSHImplementationAbstract.loadConfiguration(configuration, ""));
        if (this.isSupportsJumpServer() && configuration.getBooleanProperty(String.valueOf(prefix = SSHImplementationAbstract.getJumpServerSettingsPrefix(0)) + "enabled")) {
            hostConfigurations.add(0, SSHImplementationAbstract.loadConfiguration(configuration, prefix));
        }
        for (SSHHostConfiguration host : hostConfigurations) {
            if (host.getAuthConfiguration().getType() != SSHConstants.AuthType.AGENT) continue;
            try {
                this.agentProxy = new AgentProxy((Connector)new PageantConnector());
                log.debug((Object)"SSH: Connected with pageant");
            }
            catch (Exception e) {
                log.debug((Object)"pageant connect exception", (Throwable)e);
            }
            if (this.agentProxy == null) {
                try {
                    this.agentProxy = new AgentProxy((Connector)new SSHAgentConnector((USocketFactory)new JNAUSocketFactory()));
                    log.debug((Object)"SSH: Connected with ssh-agent");
                }
                catch (Exception e) {
                    log.debug((Object)"ssh-agent connection exception", (Throwable)e);
                }
            }
            if (this.agentProxy != null) break;
            throw new DBException("Unable to initialize SSH agent");
        }
        this.setupTunnel(monitor, configuration, hostConfigurations.toArray(new SSHHostConfiguration[0]), portForwardConfiguration);
        this.savedLocalPort = sshLocalPort;
        this.savedConfiguration = configuration;
        this.savedConnectionInfo = connectionInfo;
        connectionInfo = new DBPConnectionConfiguration(connectionInfo);
        if (CommonUtils.isEmpty((String)sshLocalHost)) {
            connectionInfo.setHostName("127.0.0.1");
        } else {
            connectionInfo.setHostName(sshLocalHost);
        }
        connectionInfo.setHostPort(Integer.toString(sshLocalPort));
        if (configuration.getDriver() != null) {
            String newURL = configuration.getDriver().getDataSourceProvider().getConnectionURL(configuration.getDriver(), connectionInfo);
            connectionInfo.setUrl(newURL);
        }
        return connectionInfo;
    }

    @NotNull
    public byte[] agentSign(@NotNull byte[] blob, @NotNull byte[] data) {
        return this.agentProxy.sign(blob, data);
    }

    @NotNull
    protected List<SSHAgentIdentity> getAgentData() {
        return Arrays.stream(this.agentProxy.getIdentities()).map(i -> {
            SSHAgentIdentity id = new SSHAgentIdentity();
            id.setBlob(i.getBlob());
            id.setComment(i.getComment());
            return id;
        }).collect(Collectors.toList());
    }

    protected abstract void setupTunnel(@NotNull DBRProgressMonitor var1, @NotNull DBWHandlerConfiguration var2, @NotNull SSHHostConfiguration[] var3, @NotNull SSHPortForwardConfiguration var4) throws DBException, IOException;

    @NotNull
    private static SSHHostConfiguration loadConfiguration(@NotNull DBWHandlerConfiguration configuration, @NotNull String prefix) throws DBException {
        SSHAuthConfiguration authentication;
        String password;
        String username;
        SSHConstants.AuthType authType = (SSHConstants.AuthType)CommonUtils.valueOf(SSHConstants.AuthType.class, (String)configuration.getStringProperty(String.valueOf(prefix) + "authType"), (Enum)SSHConstants.AuthType.PASSWORD);
        String hostname = configuration.getStringProperty(String.valueOf(prefix) + "host");
        int port = configuration.getIntProperty(String.valueOf(prefix) + "port");
        boolean savePassword = configuration.isSavePassword();
        if (prefix.isEmpty()) {
            username = CommonUtils.notEmpty((String)configuration.getUserName());
            password = CommonUtils.notEmpty((String)configuration.getPassword());
        } else {
            username = CommonUtils.notEmpty((String)configuration.getStringProperty(String.valueOf(prefix) + "name"));
            password = CommonUtils.notEmpty((String)configuration.getSecureProperty(String.valueOf(prefix) + "password"));
        }
        if (CommonUtils.isEmpty((String)hostname)) {
            throw new DBException("SSH host not specified");
        }
        if (port == 0) {
            throw new DBException("SSH port not specified");
        }
        if (CommonUtils.isEmpty((String)username)) {
            throw new DBException("SSH user not specified");
        }
        switch (authType) {
            case PUBLIC_KEY: {
                String path = configuration.getStringProperty(String.valueOf(prefix) + "keyPath");
                if (CommonUtils.isEmpty((String)path)) {
                    throw new DBException("Private key path is empty");
                }
                File file = new File(path);
                if (!file.exists()) {
                    throw new DBException("Private key file '" + path + "' does not exist");
                }
                authentication = SSHAuthConfiguration.usingKey(file, password, savePassword);
                break;
            }
            case PASSWORD: {
                authentication = SSHAuthConfiguration.usingPassword(password, savePassword);
                break;
            }
            default: {
                authentication = SSHAuthConfiguration.usingAgent();
            }
        }
        return new SSHHostConfiguration(username, hostname, port, authentication);
    }

    @NotNull
    public static String getJumpServerSettingsPrefix(int index) {
        return "jumpServer" + index + ".";
    }

    protected boolean isSupportsJumpServer() {
        for (SSHImplementationDescriptor descriptor : SSHImplementationRegistry.getInstance().getDescriptors()) {
            if (descriptor.getImplClass().getObjectClass() != this.getClass()) continue;
            return descriptor.isSupportsJumpServer();
        }
        return false;
    }
}

