/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2dl.FigureCanvas;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.DefaultEditDomain;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.GraphicalViewer;
import org.eclipse.gef3.MouseWheelHandler;
import org.eclipse.gef3.MouseWheelZoomHandler;
import org.eclipse.gef3.Tool;
import org.eclipse.gef3.palette.PaletteDrawer;
import org.eclipse.gef3.palette.PaletteEntry;
import org.eclipse.gef3.palette.PaletteRoot;
import org.eclipse.gef3.palette.ToolEntry;
import org.eclipse.gef3.tools.SelectionTool;
import org.eclipse.gef3.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.erd.ui.directedit.ValidationMessageHandler;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorAdapter;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.internal.ERDUIActivator;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceTask;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class ERDGraphicalViewer
extends ScrollingGraphicalViewer
implements IPropertyChangeListener,
DBPEventListener {
    private static final Log log = Log.getLog(ERDGraphicalViewer.class);
    private ERDEditorPart editor;
    private ValidationMessageHandler messageHandler;
    private IThemeManager themeManager;
    private boolean loadContents = false;
    private final Map<DBPDataSourceContainer, DataSourceInfo> usedDataSources = new IdentityHashMap<DBPDataSourceContainer, DataSourceInfo>();

    public ERDGraphicalViewer(ERDEditorPart editor, ValidationMessageHandler messageHandler) {
        this.editor = editor;
        this.messageHandler = messageHandler;
        this.themeManager = editor.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), MouseWheelZoomHandler.SINGLETON);
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD2), MouseWheelHorizontalScrollHandler.SINGLETON);
    }

    public ERDEditorPart getEditor() {
        return this.editor;
    }

    public void setControl(Control control) {
        super.setControl(control);
        if (control != null) {
            ERDEditorAdapter.mapControl(control, this.editor);
            UIUtils.addFocusTracker((IServiceLocator)this.editor.getSite(), (String)"org.jkiss.dbeaver.erd.ERDEditor", (Control)control);
            this.applyThemeSettings();
        }
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.themeManager != null) {
            this.themeManager.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.getControl() != null) {
            ERDEditorAdapter.unmapControl(this.getControl());
        }
        super.handleDispose(e);
    }

    public ValidationMessageHandler getValidationHandler() {
        return this.messageHandler;
    }

    protected void handleFocusLost(FocusEvent fe) {
        super.handleFocusLost(fe);
        this.messageHandler.reset();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().equals("org.jkiss.dbeaver.erd.diagram.font")) {
            this.applyThemeSettings();
        }
    }

    private void applyThemeSettings() {
        ITheme currentTheme = this.themeManager.getCurrentTheme();
        Font erdFont = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.erd.diagram.font");
        if (erdFont != null) {
            this.getControl().setFont(erdFont);
        }
        this.editor.refreshDiagram(true, false);
    }

    public void setContents(EditPart editpart) {
        this.loadContents = true;
        try {
            super.setContents(editpart);
            if (editpart instanceof DiagramPart) {
                ArrayList<DBSEntity> tables = new ArrayList<DBSEntity>();
                for (Object child : editpart.getChildren()) {
                    if (!(child instanceof EntityPart)) continue;
                    tables.add((DBSEntity)((EntityPart)child).getEntity().getObject());
                }
                tables.sort(DBUtils.nameComparator());
                LinkedHashMap<PaletteDrawer, ArrayList<ToolEntryTable>> toolMap = new LinkedHashMap<PaletteDrawer, ArrayList<ToolEntryTable>>();
                for (DBSEntity dBSEntity : tables) {
                    DBPDataSourceContainer container = dBSEntity.getDataSource().getContainer();
                    PaletteDrawer drawer = this.getContainerPaletteDrawer(container);
                    if (drawer == null) continue;
                    ArrayList<ToolEntryTable> tools = (ArrayList<ToolEntryTable>)toolMap.get(drawer);
                    if (tools == null) {
                        tools = new ArrayList<ToolEntryTable>(tables.size());
                        toolMap.put(drawer, tools);
                    }
                    tools.add(new ToolEntryTable(dBSEntity));
                }
                for (Map.Entry entry : toolMap.entrySet()) {
                    ((PaletteDrawer)entry.getKey()).setChildren((List)entry.getValue());
                }
                ((DiagramPart)editpart).getDiagram().getModelAdapter().handleContentChange(this.editor);
            }
        }
        finally {
            this.loadContents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTableActivate(DBSEntity table) {
        PaletteDrawer drawer;
        DBPDataSourceContainer container;
        if (table.getDataSource() != null && (container = table.getDataSource().getContainer()) != null) {
            Map<DBPDataSourceContainer, DataSourceInfo> map = this.usedDataSources;
            synchronized (map) {
                DataSourceInfo dataSourceInfo = this.usedDataSources.get(container);
                if (dataSourceInfo == null) {
                    dataSourceInfo = new DataSourceInfo();
                    this.usedDataSources.put(container, dataSourceInfo);
                    this.acquireContainer(container);
                }
                ++dataSourceInfo.tableCount;
            }
        }
        if (!this.loadContents && (drawer = this.getContainerPaletteDrawer(table.getDataSource().getContainer())) != null) {
            List children = drawer.getChildren();
            int index = 0;
            int i = 0;
            int childrenSize = children.size();
            while (i < childrenSize) {
                Object child = children.get(i);
                if (child instanceof ToolEntryTable && ((ToolEntryTable)((Object)child)).table.getName().compareTo(table.getName()) > 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            drawer.add(index, (PaletteEntry)new ToolEntryTable(table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTableDeactivate(DBSEntity table) {
        DBPDataSourceContainer container;
        PaletteDrawer drawer = this.getContainerPaletteDrawer(table.getDataSource().getContainer());
        if (drawer != null) {
            for (Object entry : drawer.getChildren()) {
                if (!(entry instanceof ToolEntryTable) || ((ToolEntryTable)((Object)entry)).table != table) continue;
                drawer.remove((PaletteEntry)((ToolEntryTable)((Object)entry)));
                break;
            }
        }
        if (table.getDataSource() != null && (container = table.getDataSource().getContainer()) != null) {
            Map<DBPDataSourceContainer, DataSourceInfo> map = this.usedDataSources;
            synchronized (map) {
                DataSourceInfo dataSourceInfo = this.usedDataSources.get(container);
                if (dataSourceInfo == null) {
                    log.warn((Object)("Datasource '" + container + "' not registered in ERD viewer"));
                } else {
                    --dataSourceInfo.tableCount;
                    if (dataSourceInfo.tableCount <= 0) {
                        this.usedDataSources.remove(container);
                        this.releaseContainer(container);
                    }
                }
            }
        }
    }

    private void acquireContainer(DBPDataSourceContainer container) {
        container.acquire((DBPDataSourceTask)this.editor);
        container.getRegistry().addDataSourceListener((DBPEventListener)this);
        PaletteRoot paletteRoot = this.editor.getPaletteRoot();
        PaletteDrawer dsDrawer = new PaletteDrawer(container.getName(), DBeaverIcons.getImageDescriptor((DBPImage)container.getDriver().getIcon()));
        dsDrawer.setDescription(container.getDescription());
        dsDrawer.setId(container.getId());
        paletteRoot.add((PaletteEntry)dsDrawer);
    }

    private void releaseContainer(DBPDataSourceContainer container) {
        PaletteDrawer drawer = this.getContainerPaletteDrawer(container);
        if (drawer != null) {
            this.editor.getPaletteRoot().remove((PaletteEntry)drawer);
        }
        container.getRegistry().removeDataSourceListener((DBPEventListener)this);
        container.release((DBPDataSourceTask)this.editor);
    }

    PaletteDrawer getContainerPaletteDrawer(DBPDataSourceContainer container) {
        for (Object child : this.editor.getPaletteRoot().getChildren()) {
            if (!(child instanceof PaletteDrawer) || !container.getId().equals(((PaletteDrawer)child).getId())) continue;
            return (PaletteDrawer)child;
        }
        return null;
    }

    public void handleDataSourceEvent(DBPEvent event) {
        DBSEntity entity;
        DBSObject object = event.getObject();
        if (object == null || DBWorkbench.getPlatform().isShuttingDown()) {
            return;
        }
        if (object instanceof DBPDataSourceContainer) {
            this.handleDataSourceContainerChange(event, (DBPDataSourceContainer)object);
            return;
        }
        DBPEvent.Action action = event.getAction();
        if (action == DBPEvent.Action.OBJECT_SELECT || !this.usedDataSources.containsKey(object.getDataSource().getContainer())) {
            return;
        }
        DBSEntityAttribute entityAttribute = null;
        DBSEntityAssociation entityAssociation = null;
        if (object instanceof DBSEntityAttribute) {
            entityAttribute = (DBSEntityAttribute)object;
            entity = entityAttribute.getParentObject();
        } else if (object instanceof DBSEntity) {
            entity = (DBSEntity)object;
        } else {
            if (object instanceof DBSEntityAssociation) {
                entityAssociation = (DBSEntityAssociation)object;
                DBSEntity entity2 = entityAssociation.getParentObject();
                return;
            }
            return;
        }
        EntityDiagram diagram = this.editor.getDiagram();
        switch (action) {
            case OBJECT_ADD: {
                boolean ownsObject;
                if (entityAttribute != null) {
                    ERDEntity erdEntity = diagram.getEntity(entity);
                    if (erdEntity == null) break;
                    UIUtils.asyncExec(() -> {
                        erdEntity.reloadAttributes((ERDDiagram)diagram);
                        erdEntity.firePropertyChange("CONTENTS", null, null);
                    });
                    break;
                }
                DBSObject diagramContainer = (DBSObject)diagram.getObject();
                IEditorPart entityOwnerEditor = (IEditorPart)event.getOptions().get("activeEditor");
                ERDEditorPart erdOwnerEditor = this.getEditor();
                if (erdOwnerEditor.getSite() instanceof MultiPageEditorSite) {
                    erdOwnerEditor = ((MultiPageEditorSite)erdOwnerEditor.getSite()).getMultiPageEditor();
                }
                boolean bl = ownsObject = this.getEditor().getDiagram().isEditEnabled() && entityOwnerEditor != null && entityOwnerEditor == erdOwnerEditor;
                if (!ownsObject && diagramContainer != entity.getParentObject()) break;
                ERDEntity erdEntity = ERDUtils.makeEntityFromObject((DBRProgressMonitor)new VoidProgressMonitor(), (ERDDiagram)diagram, Collections.emptyList(), (DBSEntity)entity, null);
                UIUtils.asyncExec(() -> {
                    diagram.addEntity(erdEntity, true);
                    EntityPart entityPart = this.getEditor().getDiagramPart().getEntityPart(erdEntity);
                    if (entityPart != null) {
                        Display display = Display.getCurrent();
                        Point loc = display.getCursorLocation();
                        Point diagramLoc = this.getControl().toDisplay(0, 0);
                        loc.x -= diagramLoc.x;
                        loc.y -= diagramLoc.y;
                        Dimension size = entityPart.getFigure().getPreferredSize();
                        Rectangle curBounds = new Rectangle();
                        curBounds.width = size.width;
                        curBounds.height = size.height;
                        curBounds.x = loc.x;
                        curBounds.y = loc.y;
                        entityPart.modifyBounds(curBounds);
                    }
                });
                break;
            }
            case OBJECT_REMOVE: {
                ERDEntity erdEntity = diagram.getEntity(entity);
                if (erdEntity == null) break;
                DBSEntityAttribute removedAttribute = entityAttribute;
                UIUtils.asyncExec(() -> {
                    if (removedAttribute == null) {
                        diagram.removeEntity(erdEntity, true);
                    } else {
                        ERDEntityAttribute erdAttribute = erdEntity.getAttribute(removedAttribute);
                        if (erdAttribute != null) {
                            erdEntity.removeAttribute(erdAttribute, false);
                            erdEntity.firePropertyChange("CONTENTS", null, null);
                        }
                    }
                });
                break;
            }
            case OBJECT_UPDATE: {
                ERDEntity erdEntity = diagram.getEntity(entity);
                if (erdEntity == null) break;
                DBSEntityAttribute updatedAttribute = entityAttribute;
                UIUtils.asyncExec(() -> {
                    if (updatedAttribute == null) {
                        erdEntity.reloadAttributes((ERDDiagram)diagram);
                        erdEntity.firePropertyChange("CONTENTS", null, null);
                    } else {
                        ERDEntityAttribute erdAttribute = erdEntity.getAttribute(updatedAttribute);
                        if (erdAttribute != null) {
                            erdAttribute.firePropertyChange("NAME", null, (Object)updatedAttribute.getName());
                            erdEntity.firePropertyChange("SIZE", null, null);
                        }
                    }
                });
            }
        }
    }

    private void autoLayoutEntity(EntityPart entityPart) {
        entityPart.getFigure().getBounds();
        DBPPreferenceStore prefStore = ERDUIActivator.getDefault().getPreferences();
        prefStore.getInt("erd.grid.width");
        prefStore.getInt("erd.grid.height");
    }

    private void handleDataSourceContainerChange(DBPEvent event, DBPDataSourceContainer object) {
        DBPDataSourceContainer container = object;
        if (this.usedDataSources.containsKey(container) && event.getAction() == DBPEvent.Action.OBJECT_UPDATE && Boolean.FALSE.equals(event.getEnabled())) {
            UIUtils.asyncExec(() -> {
                IWorkbenchPartSite site = this.editor.getSite();
                if (site != null && site.getWorkbenchWindow() != null) {
                    site.getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this.editor, false);
                }
            });
        }
    }

    private static class DataSourceInfo {
        int tableCount = 0;

        private DataSourceInfo() {
        }
    }

    private static class MouseWheelHorizontalScrollHandler
    implements MouseWheelHandler {
        public static final MouseWheelHandler SINGLETON = new MouseWheelHorizontalScrollHandler();

        private MouseWheelHorizontalScrollHandler() {
        }

        public void handleMouseWheel(Event event, EditPartViewer viewer) {
            Control control;
            if (viewer instanceof ScrollingGraphicalViewer && (control = viewer.getControl()) instanceof FigureCanvas) {
                FigureCanvas canvas = (FigureCanvas)control;
                ScrollBar hBar = canvas.getHorizontalBar();
                canvas.scrollToX(hBar.getSelection() - hBar.getIncrement() * event.count);
                event.doit = false;
            }
        }
    }

    private static class ToolEntryTable
    extends ToolEntry {
        private final DBSEntity table;

        ToolEntryTable(DBSEntity table) {
            super(table.getName(), table.getDescription(), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE));
            this.setUserModificationPermission(1);
            this.setDescription(DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.UI));
            this.table = table;
        }

        public Tool createTool() {
            return new ToolSelectTable(this.table);
        }
    }

    public static class ToolSelectTable
    extends SelectionTool {
        private final DBSEntity table;

        ToolSelectTable(DBSEntity table) {
            this.table = table;
        }

        public void activate() {
            DefaultEditDomain editDomain = (DefaultEditDomain)this.getDomain();
            ERDEditorPart editorPart = (ERDEditorPart)editDomain.getEditorPart();
            GraphicalViewer viewer = editorPart.getViewer();
            for (Object child : editorPart.getDiagramPart().getChildren()) {
                if (!(child instanceof EntityPart) || ((EntityPart)child).getEntity().getObject() != this.table) continue;
                viewer.reveal((EditPart)child);
                viewer.select((EditPart)child);
                break;
            }
            super.activate();
        }
    }
}

