/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.pdf.ImageBytes;
import org.freehep.graphicsio.pdf.PDF;
import org.freehep.graphicsio.pdf.PDFByteWriter;
import org.freehep.graphicsio.pdf.PDFConstants;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFObject;
import org.freehep.graphicsio.pdf.PDFPathConstructor;
import org.freehep.graphicsio.pdf.PDFUtil;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.ASCIIHexOutputStream;
import org.freehep.util.io.CountedByteOutputStream;
import org.freehep.util.io.FinishableOutputStream;
import org.freehep.util.io.FlateOutputStream;

public class PDFStream
extends PDFDictionary
implements PDFConstants {
    private String name;
    private PDFObject object;
    private boolean dictionaryOpen;
    private OutputStream[] stream;
    private CountedByteOutputStream byteCountStream;
    private String[] encode;
    private int gStates = 0;
    private boolean textOpen = false;
    private boolean fontWasSet = false;
    private boolean compatibilityOpen = false;

    PDFStream(PDF pdf, PDFByteWriter writer, String name, PDFObject parent, String[] encode) throws IOException {
        super(pdf, writer);
        this.name = name;
        this.object = parent;
        if (this.object == null) {
            System.err.println("PDFWriter: 'PDFStream' cannot have a null parent");
        }
        this.dictionaryOpen = true;
        this.encode = encode;
    }

    private void startStream() throws IOException {
        this.startStream(this.encode);
    }

    private void startStream(String[] encode) throws IOException {
        if (this.dictionaryOpen) {
            Object[] filters = PDFStream.decodeFilters(encode);
            if (filters != null) {
                this.entry("Filter", filters);
            }
            super.close();
            this.dictionaryOpen = false;
            this.out.printPlain("stream\n");
            this.byteCountStream = new CountedByteOutputStream(this.out);
            this.stream = PDFStream.openFilters(this.byteCountStream, encode);
        }
    }

    private void write(int b) throws IOException {
        this.startStream();
        this.stream[0].write(b);
    }

    private void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    private static PDFName[] decodeFilters(String[] encode) {
        PDFName[] filters = null;
        if (encode != null && encode.length != 0) {
            filters = new PDFName[encode.length];
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = new PDFName(encode[encode.length - i - 1] + "Decode");
            }
        }
        return filters;
    }

    private static OutputStream[] openFilters(OutputStream s, String[] filters) {
        OutputStream[] os;
        if (filters != null && filters.length != 0) {
            os = new OutputStream[filters.length + 1];
            os[os.length - 1] = s;
            for (int i = os.length - 2; i >= 0; --i) {
                if (filters[i].equals("ASCIIHex")) {
                    os[i] = new ASCIIHexOutputStream(os[i + 1]);
                    continue;
                }
                if (filters[i].equals("ASCII85")) {
                    os[i] = new ASCII85OutputStream(os[i + 1]);
                    continue;
                }
                if (filters[i].equals("Flate")) {
                    os[i] = new FlateOutputStream(os[i + 1]);
                    continue;
                }
                if (filters[i].equals("DCT")) {
                    os[i] = os[i + 1];
                    continue;
                }
                System.err.println("PDFWriter: unknown stream format: " + filters[i]);
            }
        } else {
            os = new OutputStream[]{s};
        }
        return os;
    }

    private static void closeFilters(OutputStream[] s) throws IOException {
        for (int i = 0; i < s.length - 1; ++i) {
            s[i].flush();
            if (!(s[i] instanceof FinishableOutputStream)) continue;
            ((FinishableOutputStream)((Object)s[i])).finish();
        }
        s[s.length - 1].flush();
    }

    private void write(String s) throws IOException {
        byte[] b = s.getBytes("ISO-8859-1");
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    void close() throws IOException {
        PDFStream.closeFilters(this.stream);
        this.stream = null;
        this.out.printPlain("\nendstream");
        this.out.println();
        this.object.close();
        if (this.gStates > 0) {
            System.err.println("PDFStream: unbalanced saves()/restores(), too many saves: " + this.gStates);
        }
    }

    String getName() {
        return this.name;
    }

    public int getLength() {
        return this.byteCountStream.getCount();
    }

    public void print(String s) throws IOException {
        this.write(s);
    }

    public void println(String s) throws IOException {
        this.write(s);
        this.write(EOL);
    }

    public void comment(String comment) throws IOException {
        this.println("% " + comment);
    }

    public void save() throws IOException {
        this.println("q");
        ++this.gStates;
    }

    public void restore() throws IOException {
        if (this.gStates <= 0) {
            System.err.println("PDFStream: unbalanced saves()/restores(), too many restores");
        }
        --this.gStates;
        this.println("Q");
    }

    public void matrix(AffineTransform xform) throws IOException {
        this.matrix(xform.getScaleX(), xform.getShearY(), xform.getShearX(), xform.getScaleY(), xform.getTranslateX(), xform.getTranslateY());
    }

    public void matrix(double m00, double m10, double m01, double m11, double m02, double m12) throws IOException {
        this.println(PDFUtil.fixedPrecision(m00) + " " + PDFUtil.fixedPrecision(m10) + " " + PDFUtil.fixedPrecision(m01) + " " + PDFUtil.fixedPrecision(m11) + " " + PDFUtil.fixedPrecision(m02) + " " + PDFUtil.fixedPrecision(m12) + " cm");
    }

    public void width(double width) throws IOException {
        this.println(PDFUtil.fixedPrecision(width) + " w");
    }

    public void cap(int capStyle) throws IOException {
        this.println(capStyle + " J");
    }

    public void join(int joinStyle) throws IOException {
        this.println(joinStyle + " j");
    }

    public void mitterLimit(double limit) throws IOException {
        this.println(PDFUtil.fixedPrecision(limit) + " M");
    }

    public void dash(int[] dash, double phase) throws IOException {
        this.print("[");
        for (int i = 0; i < dash.length; ++i) {
            this.print(" " + PDFUtil.fixedPrecision(dash[i]));
        }
        this.println("] " + PDFUtil.fixedPrecision(phase) + " d");
    }

    public void dash(float[] dash, double phase) throws IOException {
        this.print("[");
        for (int i = 0; i < dash.length; ++i) {
            this.print(" " + PDFUtil.fixedPrecision(dash[i]));
        }
        this.println("] " + PDFUtil.fixedPrecision(phase) + " d");
    }

    public void flatness(double flatness) throws IOException {
        this.println(PDFUtil.fixedPrecision(flatness) + " i");
    }

    public void state(PDFName stateDictionary) throws IOException {
        this.println(stateDictionary + " gs");
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.println(PDFUtil.fixedPrecision(x1) + " " + PDFUtil.fixedPrecision(y1) + " " + PDFUtil.fixedPrecision(x2) + " " + PDFUtil.fixedPrecision(y2) + " " + PDFUtil.fixedPrecision(x3) + " " + PDFUtil.fixedPrecision(y3) + " c");
    }

    public void cubicV(double x2, double y2, double x3, double y3) throws IOException {
        this.println(PDFUtil.fixedPrecision(x2) + " " + PDFUtil.fixedPrecision(y2) + " " + PDFUtil.fixedPrecision(x3) + " " + PDFUtil.fixedPrecision(y3) + " v");
    }

    public void cubicY(double x1, double y1, double x3, double y3) throws IOException {
        this.println(PDFUtil.fixedPrecision(x1) + " " + PDFUtil.fixedPrecision(y1) + " " + PDFUtil.fixedPrecision(x3) + " " + PDFUtil.fixedPrecision(y3) + " y");
    }

    public void move(double x, double y) throws IOException {
        this.println(PDFUtil.fixedPrecision(x) + " " + PDFUtil.fixedPrecision(y) + " m");
    }

    public void line(double x, double y) throws IOException {
        this.println(PDFUtil.fixedPrecision(x) + " " + PDFUtil.fixedPrecision(y) + " l");
    }

    public void closePath() throws IOException {
        this.println("h");
    }

    public void rectangle(double x, double y, double width, double height) throws IOException {
        this.println(PDFUtil.fixedPrecision(x) + " " + PDFUtil.fixedPrecision(y) + " " + PDFUtil.fixedPrecision(width) + " " + PDFUtil.fixedPrecision(height) + " re");
    }

    public void stroke() throws IOException {
        this.println("S");
    }

    public void closeAndStroke() throws IOException {
        this.println("s");
    }

    public void fill() throws IOException {
        this.println("f");
    }

    public void fillEvenOdd() throws IOException {
        this.println("f*");
    }

    public void fillAndStroke() throws IOException {
        this.println("B");
    }

    public void fillEvenOddAndStroke() throws IOException {
        this.println("B*");
    }

    public void closeFillAndStroke() throws IOException {
        this.println("b");
    }

    public void closeFillEvenOddAndStroke() throws IOException {
        this.println("b*");
    }

    public void endPath() throws IOException {
        this.println("n");
    }

    public void clip() throws IOException {
        this.println("W");
    }

    public void clipEvenOdd() throws IOException {
        this.println("W*");
    }

    public void beginText() throws IOException {
        if (this.textOpen) {
            System.err.println("PDFStream: nested beginText() not allowed.");
        }
        this.println("BT");
        this.textOpen = true;
    }

    public void endText() throws IOException {
        if (!this.textOpen) {
            System.err.println("PDFStream: unbalanced use of beginText()/endText().");
        }
        this.println("ET");
        this.textOpen = false;
    }

    public void charSpace(double charSpace) throws IOException {
        this.println(PDFUtil.fixedPrecision(charSpace) + " Tc");
    }

    public void wordSpace(double wordSpace) throws IOException {
        this.println(PDFUtil.fixedPrecision(wordSpace) + " Tw");
    }

    public void scale(double scale) throws IOException {
        this.println(PDFUtil.fixedPrecision(scale) + " Tz");
    }

    public void leading(double leading) throws IOException {
        this.println(PDFUtil.fixedPrecision(leading) + " TL");
    }

    public void font(PDFName fontName, double size) throws IOException {
        this.println(fontName + " " + PDFUtil.fixedPrecision(size) + " Tf");
        this.fontWasSet = true;
    }

    public void rendering(int mode) throws IOException {
        this.println(mode + " Tr");
    }

    public void rise(double rise) throws IOException {
        this.println(PDFUtil.fixedPrecision(rise) + " Ts");
    }

    public void text(double x, double y) throws IOException {
        this.println(PDFUtil.fixedPrecision(x) + " " + PDFUtil.fixedPrecision(y) + " Td");
    }

    public void textLeading(double x, double y) throws IOException {
        this.println(PDFUtil.fixedPrecision(x) + " " + PDFUtil.fixedPrecision(y) + " TD");
    }

    public void textMatrix(double a, double b, double c, double d, double e, double f) throws IOException {
        this.println(PDFUtil.fixedPrecision(a) + " " + PDFUtil.fixedPrecision(b) + " " + PDFUtil.fixedPrecision(c) + " " + PDFUtil.fixedPrecision(d) + " " + PDFUtil.fixedPrecision(e) + " " + PDFUtil.fixedPrecision(f) + " Tm");
    }

    public void textLine() throws IOException {
        this.println("T*");
    }

    public void show(String text) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println("(" + PDFUtil.escape(text) + ") Tj");
    }

    public void showLine(String text) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println("(" + PDFUtil.escape(text) + ") '");
    }

    public void showLine(double wordSpace, double charSpace, String text) throws IOException {
        if (!this.fontWasSet) {
            System.err.println("PDFStream: cannot use Text Showing operator before font is set.");
        }
        if (!this.textOpen) {
            System.err.println("PDFStream: Text Showing operator only allowed inside Text section.");
        }
        this.println(PDFUtil.fixedPrecision(wordSpace) + " " + PDFUtil.fixedPrecision(charSpace) + " (" + PDFUtil.escape(text) + ") \"");
    }

    public void show(Object[] array) throws IOException {
        this.print("[");
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            if (object instanceof String) {
                this.print(" (" + PDFUtil.escape(object.toString()) + ")");
                continue;
            }
            if (object instanceof Integer) {
                this.print(" " + (Integer)object);
                continue;
            }
            if (object instanceof Double) {
                this.print(" " + (Double)object);
                continue;
            }
            System.err.println("PDFStream: input array of operator TJ may only contain objects of type 'String', 'Integer' or 'Double'");
        }
        this.println("] TJ");
    }

    public void glyph(double wx, double wy) throws IOException {
        this.println(PDFUtil.fixedPrecision(wx) + " " + PDFUtil.fixedPrecision(wy) + " d0");
    }

    public void glyph(double wx, double wy, double llx, double lly, double urx, double ury) throws IOException {
        this.println(PDFUtil.fixedPrecision(wx) + " " + PDFUtil.fixedPrecision(wy) + " " + PDFUtil.fixedPrecision(llx) + " " + PDFUtil.fixedPrecision(lly) + " " + PDFUtil.fixedPrecision(urx) + " " + PDFUtil.fixedPrecision(ury) + " d1");
    }

    public void colorSpace(PDFName colorSpace) throws IOException {
        this.println(colorSpace + " cs");
    }

    public void colorSpaceStroke(PDFName colorSpace) throws IOException {
        this.println(colorSpace + " CS");
    }

    public void colorSpace(double[] color) throws IOException {
        for (int i = 0; i < color.length; ++i) {
            this.print(" " + color[i]);
        }
        this.println(" scn");
    }

    public void colorSpaceStroke(double[] color) throws IOException {
        for (int i = 0; i < color.length; ++i) {
            this.print(" " + color[i]);
        }
        this.println(" SCN");
    }

    public void colorSpace(double[] color, PDFName name) throws IOException {
        if (color != null) {
            for (int i = 0; i < color.length; ++i) {
                this.print(PDFUtil.fixedPrecision(color[i]) + " ");
            }
        }
        this.println(name + " scn");
    }

    public void colorSpaceStroke(double[] color, PDFName name) throws IOException {
        if (color != null) {
            for (int i = 0; i < color.length; ++i) {
                this.print(PDFUtil.fixedPrecision(color[i]) + " ");
            }
        }
        this.println(name + " SCN");
    }

    public void colorSpace(double g) throws IOException {
        this.println(PDFUtil.fixedPrecision(g) + " g");
    }

    public void colorSpaceStroke(double g) throws IOException {
        this.println(PDFUtil.fixedPrecision(g) + " G");
    }

    public void colorSpace(double r, double g, double b) throws IOException {
        this.println(PDFUtil.fixedPrecision(r) + " " + PDFUtil.fixedPrecision(g) + " " + PDFUtil.fixedPrecision(b) + " rg");
    }

    public void colorSpaceStroke(double r, double g, double b) throws IOException {
        this.println(PDFUtil.fixedPrecision(r) + " " + PDFUtil.fixedPrecision(g) + " " + PDFUtil.fixedPrecision(b) + " RG");
    }

    public void colorSpace(double c, double m, double y, double k) throws IOException {
        this.println(PDFUtil.fixedPrecision(c) + " " + PDFUtil.fixedPrecision(m) + " " + PDFUtil.fixedPrecision(y) + " " + PDFUtil.fixedPrecision(k) + " k");
    }

    public void colorSpaceStroke(double c, double m, double y, double k) throws IOException {
        this.println(PDFUtil.fixedPrecision(c) + " " + PDFUtil.fixedPrecision(m) + " " + PDFUtil.fixedPrecision(y) + " " + PDFUtil.fixedPrecision(k) + " K");
    }

    public void shade(PDFName name) throws IOException {
        this.println(name + " sh");
    }

    private PDFName[] getFilterName(String encode) {
        if ("ZLIB".equals(encode)) {
            return PDFStream.decodeFilters(new String[]{"Flate", "ASCII85"});
        }
        if ("JPG".equals(encode)) {
            return PDFStream.decodeFilters(new String[]{"DCT", "ASCII85"});
        }
        throw new IllegalArgumentException("unknown image encoding " + encode + " for PDFStream");
    }

    public void image(RenderedImage image, Color bkg, String encode) throws IOException {
        ImageBytes bytes = new ImageBytes(image, bkg, encode, "RGB");
        this.entry("Width", image.getWidth());
        this.entry("Height", image.getHeight());
        this.entry("ColorSpace", this.pdf.name("DeviceRGB"));
        this.entry("BitsPerComponent", 8);
        this.entry("Filter", this.getFilterName(bytes.getFormat()));
        this.write(bytes.getBytes());
    }

    public void imageMask(RenderedImage image, String encode) throws IOException {
        ImageBytes bytes = new ImageBytes(image, null, encode, "A");
        this.entry("Width", image.getWidth());
        this.entry("Height", image.getHeight());
        this.entry("BitsPerComponent", 8);
        this.entry("ColorSpace", this.pdf.name("DeviceGray"));
        this.entry("Filter", this.getFilterName(bytes.getFormat()));
        this.write(bytes.getBytes());
    }

    public void inlineImage(RenderedImage image, Color bkg, String encode) throws IOException {
        ImageBytes bytes = new ImageBytes(image, bkg, "JPG", "RGB");
        this.println("BI");
        this.imageInfo("Width", image.getWidth());
        this.imageInfo("Height", image.getHeight());
        this.imageInfo("ColorSpace", this.pdf.name("DeviceRGB"));
        this.imageInfo("BitsPerComponent", 8);
        this.imageInfo("Filter", this.getFilterName(bytes.getFormat()));
        this.print("ID\n");
        this.write(bytes.getBytes());
        this.println("\nEI");
    }

    private void imageInfo(String key, int number) throws IOException {
        this.println("/" + key + " " + number);
    }

    private void imageInfo(String key, PDFName name) throws IOException {
        this.println("/" + key + " " + name);
    }

    private void imageInfo(String key, Object[] array) throws IOException {
        this.print("/" + key + " [");
        for (int i = 0; i < array.length; ++i) {
            this.print(" " + array[i]);
        }
        this.println("]");
    }

    public boolean drawPath(Shape s) throws IOException {
        PDFPathConstructor path = new PDFPathConstructor(this);
        return path.addPath(s);
    }

    public void xObject(PDFName name) throws IOException {
        this.println(name + " Do");
    }

    public void beginCompatibility() throws IOException {
        if (this.compatibilityOpen) {
            System.err.println("PDFStream: nested use of Compatibility sections not allowed.");
        }
        this.println("BX");
        this.compatibilityOpen = true;
    }

    public void endCompatibility() throws IOException {
        if (!this.compatibilityOpen) {
            System.err.println("PDFStream: unbalanced use of begin/endCompatibilty().");
        }
        this.println("EX");
        this.compatibilityOpen = false;
    }
}

