/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.Dataholder;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.CacheElementMetadataImpl;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.classes.Compiler.LG.JavaClassDefPointer;
import com.intersys.classes.Compiler.LG.JavaMtdArgDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;

abstract class CacheArgumentMetadataImpl
extends CacheElementMetadataImpl
implements CacheArgument {
    private CacheClassMetadataImpl mClass;
    private int mRefOrdinal;

    public CacheArgumentMetadataImpl(CacheClass cacheClass, JavaMtdArgDef javaMtdArgDef) throws CacheException {
        super((CacheClassMetadataImpl)cacheClass, javaMtdArgDef.getjarg(), javaMtdArgDef.getarg());
        CacheClassMetadataImpl cacheClassMetadataImpl = (CacheClassMetadataImpl)cacheClass;
        this.mName = javaMtdArgDef.getarg().getname();
        this.mJavaName = javaMtdArgDef.getjarg().getname();
        if (this.mJavaName == null) {
            this.mJavaName = this.mName;
        }
        this.mDefaultValueString = javaMtdArgDef.getdefaultVal();
        JavaClassDefPointer javaClassDefPointer = javaMtdArgDef.getjarg().getcacheType();
        JavaClassDef javaClassDef = (JavaClassDef)javaClassDefPointer.getJavaClassDef();
        if (javaClassDef != null) {
            this.mType = (CacheClassMetadataImpl)cacheClassMetadataImpl.getAClass(javaClassDef);
        } else {
            this.mClass = cacheClassMetadataImpl;
            this.mTypeName = cacheClassMetadataImpl.lookupName(javaClassDefPointer.getName());
        }
        this.mJavaTypeName = cacheClassMetadataImpl.lookupName(javaMtdArgDef.getjarg().gettype());
        Dataholder dataholder = new Dataholder(this.mDefaultValueString);
        if (this.mDefaultValueString != null) {
            try {
                this.mDefaultValue = dataholder.getObject(this.mJavaTypeName);
            }
            catch (Exception exception) {
                this.mDefaultValue = null;
            }
        }
        this.constructModifiers(javaMtdArgDef);
    }

    @Override
    protected CacheClassMetadata getTypeInternal() throws CacheException {
        return this.mClass.getAClass(this.getTypeName());
    }

    private void constructModifiers(JavaMtdArgDef javaMtdArgDef) throws CacheException {
        Integer n = javaMtdArgDef.getarg().getclientTypeId();
        boolean bl = CacheArgumentMetadataImpl.isLiteral(n);
        boolean bl2 = javaMtdArgDef.getisByRef();
        boolean bl3 = javaMtdArgDef.getisDefault();
        if (bl) {
            this.addModifier(16);
        }
        if (bl2) {
            this.addModifier(2);
        }
        if (bl3) {
            this.addModifier(4);
        }
    }

    public void setRefOrdinal(int n) {
        this.mRefOrdinal = n;
    }

    @Override
    public int getRefOrdinal() {
        return this.mRefOrdinal;
    }
}

