/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.metadata.CacheArgumentMetadataImpl;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.CacheElementMetadataImpl;
import com.intersys.cache.metadata.Dictionary;
import com.intersys.cache.metadata.MethodHelper;
import com.intersys.classes.Compiler.LG.JavaClassDefPointer;
import com.intersys.classes.Compiler.LG.JavaMethodDef;
import com.intersys.classes.Compiler.LG.JavaMtdArgDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheElementInfo;
import com.intersys.objects.reflect.CacheMethod;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

abstract class CacheMethodMetadataImpl
implements Comparable,
CacheMethod {
    private JavaMethodDef mJavaMethodDef;
    private CacheClassMetadataImpl mDeclaringClass;
    private CacheClassMetadataImpl mImplementationClass;
    private int mModifier;
    private String mName;
    private String mJavaName;
    private String mStoredProcName;
    private int mFirstDefaultArgument;
    private CacheElementMetadataImpl mReturnElement;
    private static final int IS_STORED_PROCEDURE = 1;
    private static final int HAS_SIGNATURE_CONFLICT = 2;
    private static final int IS_CLASS_METHOD = 4;
    private static final int IS_JAVA_METHOD = 8;
    private static final int IS_SPECIAL_METHOD = 16;
    private int mMethodModifier;
    private String mReturnAccessorMethod;
    private CacheArgumentMetadataImpl[] mArguments;
    private boolean mIsDefinedInClass;

    public CacheMethodMetadataImpl(CacheClassMetadata cacheClassMetadata, CacheClassMetadata cacheClassMetadata2, JavaMethodDef javaMethodDef) throws CacheException {
        this.mImplementationClass = (CacheClassMetadataImpl)cacheClassMetadata;
        this.mDeclaringClass = (CacheClassMetadataImpl)cacheClassMetadata2;
        this.mJavaMethodDef = javaMethodDef;
        this.constructModifiers();
        this.mName = this.mJavaMethodDef.getmethodName();
        this.mJavaName = this.mJavaMethodDef.getjmethodName();
        this.mStoredProcName = this.mJavaMethodDef.getsqlName();
        this.mFirstDefaultArgument = this.mJavaMethodDef.getfirstDefaultArg();
        this.mMethodModifier = 0;
        this.mIsDefinedInClass = this.mJavaMethodDef.getisDefinedInClass();
        if (this.mJavaMethodDef.getisSQLProc()) {
            this.mMethodModifier |= 1;
        }
        if (this.mJavaMethodDef.getconflictingSignature()) {
            this.mMethodModifier |= 2;
        }
        if (this.mJavaMethodDef.getisClassMtd()) {
            this.mMethodModifier |= 4;
        }
        if (this.mJavaMethodDef.getisJavaMethod()) {
            this.mMethodModifier |= 4;
        }
        if (this.mJavaMethodDef.getisSpecialMethod()) {
            this.mMethodModifier |= 0x10;
        }
        Dictionary dictionary = this.getDictionary();
        this.mReturnAccessorMethod = dictionary.lookup(this.mJavaMethodDef.getjres().getAccessorName());
        this.mReturnElement = new CacheElementMetadataImpl((CacheClassMetadataImpl)cacheClassMetadata2, this.mJavaMethodDef.getjres(), this.mJavaMethodDef.get_res());
    }

    private final Dictionary getDictionary() {
        return ((CacheClassMetadataImpl)this.getDeclaringClass()).getDictionary();
    }

    private void constructModifiers() throws CacheException {
        boolean bl = this.mJavaMethodDef.getisClassMtd();
        boolean bl2 = false;
        Integer n = this.mJavaMethodDef.get_res().getclientTypeId();
        if (n != null) {
            this.addModifier(8);
        }
        if (CacheElementMetadataImpl.isLiteral(n)) {
            this.addModifier(16);
        }
        if (bl) {
            this.addModifier(1);
        }
        if (bl2) {
            this.addModifier(32);
        }
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final String getJavaName() {
        return this.mJavaName;
    }

    @Override
    public final int getModifiers() {
        return this.mModifier;
    }

    @Override
    public final CacheClass getImplementationClass() {
        return this.mImplementationClass;
    }

    @Override
    public final CacheClass getDeclaringClass() {
        return this.mDeclaringClass;
    }

    @Override
    public final CacheClass getReturnType() throws CacheException {
        JavaClassDefPointer javaClassDefPointer = this.mJavaMethodDef.getjres().getcacheType();
        return this.mDeclaringClass.getAClass(javaClassDefPointer);
    }

    @Override
    public final String getSignature() throws CacheException {
        return MethodHelper.constructSignature(this.mName, this.getArgumentIterator(), false);
    }

    private String getSignature(boolean bl) throws CacheException {
        return MethodHelper.constructSignature(this.mName, this.getArgumentIterator(), bl);
    }

    @Override
    public String getDeclaration() throws CacheException {
        String string = this.getReturnType().getName() + " " + this.getSignature(true);
        return string;
    }

    @Override
    public Class getJavaReturnType() throws CacheException {
        return ((CacheClassMetadataImpl)this.getReturnType()).getJavaClass();
    }

    @Override
    public CacheElementInfo getJavaReturnElement() throws CacheException {
        return this.mReturnElement;
    }

    @Override
    public String getJavaReturnTypeName() throws CacheException {
        CacheClass cacheClass = this.getReturnType();
        return cacheClass.getJavaClassName();
    }

    @Override
    public CacheArgument[] getArgumentTypes() throws CacheException {
        this.checkArguments();
        CacheArgument[] cacheArgumentArray = new CacheArgument[this.mArguments.length];
        System.arraycopy(this.mArguments, 0, cacheArgumentArray, 0, this.mArguments.length);
        return cacheArgumentArray;
    }

    @Override
    public Iterator getArgumentIterator() throws CacheException {
        this.checkArguments();
        return Arrays.asList(this.mArguments).iterator();
    }

    private void addModifier(int n) {
        this.mModifier |= n;
    }

    private void checkArguments() throws CacheException {
        if (this.mArguments != null) {
            return;
        }
        List list = this.mJavaMethodDef.getjargs();
        this.mArguments = new CacheArgumentMetadataImpl[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaMtdArgDef javaMtdArgDef = (JavaMtdArgDef)iterator.next();
            this.mArguments[n] = (CacheArgumentMetadataImpl)this.mDeclaringClass.createArgument(javaMtdArgDef);
            ++n;
        }
        n = 0;
        for (int i = 0; i < this.mArguments.length; ++i) {
            if (!this.mArguments[i].isByReference()) continue;
            this.mArguments[i].setRefOrdinal(n);
            ++n;
        }
    }

    public int compareTo(Object object) {
        return CacheMethodMetadataImpl.compareMethods(this, object);
    }

    private static int compareMethods(Object object, Object object2) {
        int n;
        Object object3;
        CacheMethod cacheMethod;
        if (object instanceof CacheMethod) {
            cacheMethod = (CacheMethod)object;
            object3 = object2;
            n = 1;
        } else if (object2 instanceof CacheMethod) {
            cacheMethod = (CacheMethod)object2;
            object3 = object;
            n = -1;
        } else {
            throw new ClassCastException("Neither of objects are instances of " + CacheMethod.class.getName() + " [o1: " + object.getClass().getName() + "] [o2:" + object2.getClass().getName() + "]");
        }
        try {
            if (object3 instanceof String) {
                return n * cacheMethod.getSignature().compareTo((String)object3);
            }
            CacheMethod cacheMethod2 = (CacheMethod)object3;
            return n * cacheMethod.getSignature().compareTo(cacheMethod2.getSignature());
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                cacheException.printFullTrace(Logger.out);
            }
            throw new ClassCastException("Method definition is invalid:" + cacheException.getMessage());
        }
    }

    @Override
    public boolean isStoredProcedure() {
        return (this.mMethodModifier & 1) != 0;
    }

    @Override
    public String getStoredProcName() {
        return this.mStoredProcName;
    }

    @Override
    public int getFirstDefaultArgument() {
        return this.mFirstDefaultArgument;
    }

    @Override
    public boolean hasSignatureConflict() {
        return (this.mMethodModifier & 2) != 0;
    }

    @Override
    public boolean isClassMethod() {
        return (this.mMethodModifier & 4) != 0;
    }

    @Override
    public boolean isJavaMethod() {
        return (this.mMethodModifier & 8) != 0;
    }

    @Override
    public String getReturnAccessorMethod() {
        return this.mReturnAccessorMethod;
    }

    @Override
    public int getRefOrdinal(int n) {
        return this.mArguments[n].getRefOrdinal();
    }

    @Override
    public boolean isDefinedInClass() {
        return this.mIsDefinedInClass;
    }

    @Override
    public boolean isSpecialMethod() {
        return (this.mMethodModifier & 0x10) != 0;
    }

    public String toString() {
        try {
            return this.getImplementationClass() + ": " + this.getDeclaration();
        }
        catch (CacheException cacheException) {
            return this.mName + " <exception occured: " + cacheException.toString() + ">";
        }
    }

    public boolean equals(Object object) {
        try {
            String string = this.getSignature();
            if (object instanceof String) {
                String string2 = (String)object;
                if (string.equals(string2)) {
                    return true;
                }
                string = this.getSignature(false);
                return string.equals(string2);
            }
            if (object instanceof CacheMethod) {
                String string3 = ((CacheMethod)object).getSignature();
                return string.equals(string3);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static class C
    implements Comparator {
        public static C instance = new C();

        public int compare(Object object, Object object2) {
            return CacheMethodMetadataImpl.compareMethods(object, object2);
        }
    }
}

