/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.classes.AbstractCacheArray;
import com.intersys.classes.ArrayBuffer;
import com.intersys.classes.DataConverter;
import com.intersys.classes.StringArrayBuffer;
import com.intersys.classes.SysArrayOfDataTypes;
import com.intersys.objects.CacheCollectionException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import java.util.Map;

public class ArrayOfDataTypes
extends AbstractCacheArray {
    private String mKeyType = "";
    private String mValueType = "";

    public ArrayOfDataTypes(CacheObject cacheObject) throws CacheException {
        this.mInternal = new SysArrayOfDataTypes(cacheObject);
        if (ArrayBuffer.getDefaultBufferSize() > 1) {
            Object object = cacheObject.getUserData();
            if (object != null && object instanceof String) {
                this.setValueType((String)object);
                object = null;
            }
            if (object != null && object instanceof ArrayBuffer) {
                String string;
                this.setBuffer((ArrayBuffer)object);
                if (object instanceof StringArrayBuffer && (string = ((StringArrayBuffer)object).mValueType) != null) {
                    this.mValueType = string;
                }
            } else {
                StringArrayBuffer stringArrayBuffer = new StringArrayBuffer(this.mInternal);
                stringArrayBuffer.mValueType = this.mValueType;
                this.setBuffer(stringArrayBuffer);
                cacheObject.setUserData(stringArrayBuffer);
            }
        }
    }

    public ArrayOfDataTypes(Database database) throws CacheException {
        this.mInternal = new SysArrayOfDataTypes(database);
    }

    public String getKeyType() {
        return this.mKeyType;
    }

    public void setKeyType(String string) {
        this.mKeyType = string == null ? "" : string;
    }

    public String getValueType() {
        return this.mValueType;
    }

    public void setValueType(String string) throws CacheException {
        if (string == null) {
            this.mValueType = "";
            return;
        }
        this.mValueType = DataConverter.convertClassName(string, this.getDatabase());
    }

    public static String getCacheClassName() {
        return SysArrayOfDataTypes.getCacheClassName();
    }

    @Override
    public void putAll(Map map) {
        JBindDatabase jBindDatabase = (JBindDatabase)this.mInternal.getDatabase();
        try {
            jBindDatabase.putArrayElements(this.mInternal.getOref(), map);
            this.invalidateCache();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    protected Object keyExternal2internal(Object object) {
        if (this.mKeyType == null || this.mKeyType.equals("")) {
            return object;
        }
        try {
            return DataConverter.datatype2string(object);
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    protected Object keyInternal2external(Object object) {
        if (this.mKeyType == null || this.mKeyType.equals("")) {
            return object;
        }
        try {
            return DataConverter.string2datatype(object, this.mKeyType);
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    protected Object valueExternal2internal(Object object) {
        return object;
    }

    @Override
    protected Object valueInternal2external(Object object) {
        if (this.mValueType == null || this.mValueType.equals("")) {
            return object;
        }
        try {
            return DataConverter.string2datatype(object, this.mValueType);
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Object _find(Object object) throws CacheException {
        return DataConverter.string2object(this.getInternal()._find((String)object, ""));
    }

    @Override
    public void _setAt(Object object, Object object2) throws CacheException {
        this.invalidateCache();
        this.getInternal()._setAt(object, object2);
    }

    private SysArrayOfDataTypes getInternal() {
        return (SysArrayOfDataTypes)this.mInternal;
    }
}

