/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.codegenerator.java;

import com.intersys.classes.CPPStoredProc;
import com.intersys.classes.GlobalCharacterStream;
import com.intersys.codegenerator.java.CreateLogFileDialog;
import com.intersys.codegenerator.java.GenFlags;
import com.intersys.codegenerator.java.GeneratorDisplay;
import com.intersys.codegenerator.java.JavaRoot;
import com.intersys.codegenerator.java.LoginDialog;
import com.intersys.codegenerator.java.Messages;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheReader;
import com.intersys.objects.Database;
import com.intersys.objects.ObjectHandleHolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GeneratorGUI
extends JFrame {
    private LoginDialog mChangeNamespaceDialog;
    private CreateLogFileDialog mCreateLogFileDialog;
    String mServer;
    String mPort;
    String mUser;
    String mPassword;
    String mNamespace;
    String mFlags;
    GenFlags mGenFlags;
    private Properties mConfigProperties = new Properties();
    private boolean mLoggedOn;
    JavaRoot mJavaRoot;
    Database mDB;
    boolean mIsConnected;
    int mScan;
    String mPackageTree;
    DefaultMutableTreeNode mTop = null;
    DefaultMutableTreeNode mCurrentNode = null;
    Stack mNodeStack = new Stack();
    DefaultTreeModel mSelectTreeModel;
    Object[] mNodes = null;
    int mNodeIndex = 0;
    HashSet mSelectSet;
    DefaultListModel mGenerateListModel = null;
    DefaultListSelectionModel mGenerateSelectionListModel = null;
    HashSet mRemoveSet;
    JScrollPane jOutputScrollPane;
    JList jOutputList;
    DefaultListModel mOutputListModel;
    private boolean mLogFileFlag = false;
    private boolean mFirstTimeThruFlag = true;
    private JMenu jMenu = null;
    private JMenuItem jMenuItemChangeNamespace = null;
    JCheckBoxMenuItem jMenuItemCreateLogFile = null;
    private JPanel jContentPane = null;
    private JPanel jGeneratePanel = null;
    private JButton jGenerateButton = null;
    private JPanel jTreePanel = null;
    JTree jSelectTree = null;
    private JList jGenerateList = null;
    private JButton jRemoveButton = null;
    private JButton jAddButton = null;
    private JPanel jOptionPanel = null;
    private JCheckBox jNewCollectionsCheckBox = null;
    private JCheckBox jPrimitiveDataTypesCheckBox = null;
    private JMenuBar jJMenuBar = null;
    private JButton jSelectRootDir = null;
    private JPanel jRootDirPanel = null;
    private JTextField jRootDirTextField = null;
    private JFileChooser jRootDirChooser = null;
    private JLabel jLogFileLabel = null;
    private String mRootDirPath;
    String mLogFilePath;
    JScrollPane jSelectTreeScrollPane = null;
    private JScrollPane jGenerateListScrollPane1 = null;
    private JPanel jPanelAddRemove = null;
    private JMenuItem jMenuExit = null;
    private JMenuItem jMenuItemSelectRootDir = null;

    public static void createAndShowGUI() {
        GeneratorGUI generatorGUI = new GeneratorGUI();
        generatorGUI.setDefaultCloseOperation(3);
        generatorGUI.setVisible(true);
    }

    private JPanel getJGeneratePanel() {
        if (this.jGeneratePanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.jGeneratePanel = new JPanel();
            this.jGeneratePanel.setLayout(new GridBagLayout());
            this.jGeneratePanel.setPreferredSize(new Dimension(100, 40));
            this.jGeneratePanel.setToolTipText(Messages.getString("GeneratorGUI.0"));
            gridBagConstraints.anchor = 10;
            this.jGeneratePanel.add((Component)this.getJGenerateButton(), gridBagConstraints);
        }
        return this.jGeneratePanel;
    }

    private JButton getJGenerateButton() {
        if (this.jGenerateButton == null) {
            this.jGenerateButton = new JButton();
            this.jGenerateButton.setText(Messages.getString("GeneratorGUI.1"));
            this.jGenerateButton.setMnemonic(71);
            this.jGenerateButton.setToolTipText(Messages.getString("GeneratorGUI.2"));
            this.jGenerateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final String[] stringArray = new String[GeneratorGUI.this.mGenerateListModel.getSize()];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = GeneratorGUI.this.mGenerateListModel.getElementAt(i).toString();
                    }
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            GeneratorGUI.this.guiEnable(false);
                            try {
                                GeneratorGUI.this.mJavaRoot.run(GeneratorGUI.this.mDB, stringArray, new GeneratorDisplay(){

                                    @Override
                                    public void add(String string) {
                                        GeneratorGUI.this.mOutputListModel.addElement(string);
                                    }
                                });
                            }
                            catch (CacheException cacheException) {
                                GeneratorGUI.this.processRunException(cacheException);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                GeneratorGUI.this.processRunException(classNotFoundException);
                            }
                            catch (SQLException sQLException) {
                                GeneratorGUI.this.processRunException(sQLException);
                            }
                            catch (IOException iOException) {
                                GeneratorGUI.this.processRunException(iOException);
                            }
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    GeneratorGUI.this.guiEnable(true);
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                        }
                    };
                    thread.start();
                }
            });
        }
        return this.jGenerateButton;
    }

    private JPanel getJTreePanel() {
        if (this.jTreePanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            this.jTreePanel = new JPanel();
            this.jTreePanel.setLayout(new GridBagLayout());
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 10;
            this.jTreePanel.add((Component)this.getJSelectTreeScrollPane(), gridBagConstraints);
            this.jTreePanel.add((Component)this.getJPanelAddRemove(), gridBagConstraints3);
            this.jTreePanel.add((Component)this.getJGenerateListScrollPane(), gridBagConstraints2);
            this.jTreePanel.add((Component)this.getJGeneratePanel(), gridBagConstraints4);
        }
        return this.jTreePanel;
    }

    JTree getJSelectTree() {
        if (this.jSelectTree == null) {
            this.mSelectTreeModel = new DefaultTreeModel(this.mTop);
            this.jSelectTree = new JTree(this.mSelectTreeModel);
            DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
            this.jSelectTree.setCellRenderer(defaultTreeCellRenderer);
            this.jSelectTree.setShowsRootHandles(true);
        }
        return this.jSelectTree;
    }

    private JList getJGenerateList() {
        if (this.jGenerateList == null) {
            this.mGenerateListModel = new DefaultListModel();
            this.mGenerateSelectionListModel = new DefaultListSelectionModel();
            this.mGenerateSelectionListModel.setSelectionMode(2);
            this.jGenerateList = new JList(this.mGenerateListModel);
            this.jGenerateList.setSelectionModel(this.mGenerateSelectionListModel);
            this.jGenerateList.setToolTipText(Messages.getString("GeneratorGUI.3"));
            this.mRemoveSet = new HashSet();
            this.jGenerateList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting() || listSelectionEvent.getFirstIndex() == -1) {
                        return;
                    }
                    for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                        if (((JList)listSelectionEvent.getSource()).isSelectedIndex(i)) {
                            GeneratorGUI.this.mRemoveSet.add(new Integer(i));
                            continue;
                        }
                        GeneratorGUI.this.mRemoveSet.remove(new Integer(i));
                    }
                }
            });
        }
        return this.jGenerateList;
    }

    private JButton getJRemoveButton() {
        if (this.jRemoveButton == null) {
            this.jRemoveButton = new JButton();
            this.jRemoveButton.setText(Messages.getString("GeneratorGUI.4"));
            this.jRemoveButton.setToolTipText(Messages.getString("GeneratorGUI.5"));
            this.jRemoveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Iterator iterator = GeneratorGUI.this.mRemoveSet.iterator();
                    ArrayList arrayList = new ArrayList();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        arrayList.add(GeneratorGUI.this.mGenerateListModel.getElementAt(n));
                    }
                    for (Object e : arrayList) {
                        GeneratorGUI.this.mGenerateListModel.removeElement(e);
                    }
                    GeneratorGUI.this.mGenerateSelectionListModel.clearSelection();
                    GeneratorGUI.this.mRemoveSet.clear();
                }
            });
        }
        return this.jRemoveButton;
    }

    private JButton getJAddButton() {
        if (this.jAddButton == null) {
            this.jAddButton = new JButton();
            this.jAddButton.setText(Messages.getString("GeneratorGUI.6"));
            this.jAddButton.setToolTipText(Messages.getString("GeneratorGUI.7"));
            this.jAddButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneratorGUI.this.mSelectSet.clear();
                    TreePath[] treePathArray = GeneratorGUI.this.jSelectTree.getSelectionPaths();
                    for (int i = 0; i < treePathArray.length; ++i) {
                        Object object;
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                        if (defaultMutableTreeNode.isLeaf()) {
                            GeneratorGUI.this.mSelectSet.add(defaultMutableTreeNode.toString());
                        } else {
                            for (object = defaultMutableTreeNode.getFirstLeaf(); object != null; object = ((DefaultMutableTreeNode)object).getNextLeaf()) {
                                if (!defaultMutableTreeNode.isNodeDescendant((DefaultMutableTreeNode)object) || !((DefaultMutableTreeNode)object).isLeaf()) continue;
                                GeneratorGUI.this.mSelectSet.add(((DefaultMutableTreeNode)object).toString());
                            }
                        }
                        object = GeneratorGUI.this.mSelectSet.iterator();
                        while (object.hasNext()) {
                            Object e = object.next();
                            if (GeneratorGUI.this.mGenerateListModel.contains(e)) continue;
                            GeneratorGUI.this.mGenerateListModel.addElement(e);
                        }
                    }
                }
            });
        }
        return this.jAddButton;
    }

    private JPanel getJOptionPanel() {
        if (this.jOptionPanel == null) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.jOptionPanel = new JPanel();
            this.jOptionPanel.setLayout(gridBagLayout);
            this.jOptionPanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("GeneratorGUI.8"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.ipadx = 8;
            gridBagConstraints.anchor = 18;
            this.jOptionPanel.add((Component)this.getJNewCollectionsCheckBox(), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.ipadx = 10;
            this.jOptionPanel.add((Component)this.getJPrimitiveDataTypesCheckBox(), gridBagConstraints2);
        }
        return this.jOptionPanel;
    }

    private JCheckBox getJNewCollectionsCheckBox() {
        if (this.jNewCollectionsCheckBox == null) {
            this.jNewCollectionsCheckBox = new JCheckBox();
            this.jNewCollectionsCheckBox.setText(Messages.getString("GeneratorGUI.9"));
            this.jNewCollectionsCheckBox.setToolTipText(Messages.getString("GeneratorGUI.10"));
            this.jNewCollectionsCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        GeneratorGUI.this.mGenFlags.mNewCollections = false;
                        if (GeneratorGUI.this.mJavaRoot != null) {
                            GeneratorGUI.this.mJavaRoot.setNewCollections(false);
                        }
                    } else if (itemEvent.getStateChange() == 1) {
                        GeneratorGUI.this.mGenFlags.mNewCollections = true;
                        if (GeneratorGUI.this.mJavaRoot != null) {
                            GeneratorGUI.this.mJavaRoot.setNewCollections(true);
                        }
                    }
                }
            });
        }
        return this.jNewCollectionsCheckBox;
    }

    private JCheckBox getJPrimitiveDataTypesCheckBox() {
        if (this.jPrimitiveDataTypesCheckBox == null) {
            this.jPrimitiveDataTypesCheckBox = new JCheckBox();
            this.jPrimitiveDataTypesCheckBox.setText(Messages.getString("GeneratorGUI.11"));
            this.jPrimitiveDataTypesCheckBox.setToolTipText(Messages.getString("GeneratorGUI.12"));
            this.jPrimitiveDataTypesCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        GeneratorGUI.this.mGenFlags.mPrimitiveDataTypes = false;
                        if (GeneratorGUI.this.mJavaRoot != null) {
                            GeneratorGUI.this.mJavaRoot.setPrimitiveDataTypes(false);
                        }
                    } else if (itemEvent.getStateChange() == 1) {
                        GeneratorGUI.this.mGenFlags.mPrimitiveDataTypes = true;
                        if (GeneratorGUI.this.mJavaRoot != null) {
                            GeneratorGUI.this.mJavaRoot.setPrimitiveDataTypes(true);
                        }
                    }
                }
            });
        }
        return this.jPrimitiveDataTypesCheckBox;
    }

    private JMenu getJMenu() {
        if (this.jMenu == null) {
            this.jMenu = new JMenu();
            this.jMenu.setText(Messages.getString("GeneratorGUI.13"));
            this.jMenu.setMnemonic(70);
            this.jMenu.add(this.getJMenuItem());
            this.jMenu.add(this.getJMenuItemSelectRooDir());
            this.jMenu.add(this.getJMenuItemCreateLogFile());
            this.jMenu.add(this.getJMenuItemExit());
        }
        return this.jMenu;
    }

    private JMenuItem getJMenuItem() {
        if (this.jMenuItemChangeNamespace == null) {
            this.jMenuItemChangeNamespace = new JMenuItem();
            this.jMenuItemChangeNamespace.setMnemonic(72);
            this.jMenuItemChangeNamespace.setText(Messages.getString("GeneratorGUI.14"));
            this.jMenuItemChangeNamespace.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneratorGUI.this.mChangeNamespaceDialog.setFromParent();
                    GeneratorGUI.this.mChangeNamespaceDialog.setVisible(true);
                }
            });
        }
        return this.jMenuItemChangeNamespace;
    }

    private JCheckBoxMenuItem getJMenuItemCreateLogFile() {
        if (this.jMenuItemCreateLogFile == null) {
            this.jMenuItemCreateLogFile = new JCheckBoxMenuItem();
            this.jMenuItemCreateLogFile.setMnemonic(76);
            this.jMenuItemCreateLogFile.setText(Messages.getString("GeneratorGUI.15"));
            this.jMenuItemCreateLogFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getItem();
                    if (GeneratorGUI.this.mFirstTimeThruFlag) {
                        GeneratorGUI.this.mFirstTimeThruFlag = false;
                        return;
                    }
                    if (jCheckBoxMenuItem.isSelected()) {
                        GeneratorGUI.this.mLogFileFlag = true;
                    } else {
                        GeneratorGUI.this.mLogFileFlag = false;
                        GeneratorGUI.this.mLogFilePath = "";
                        GeneratorGUI.this.writePropertiesToConfigFile();
                        GeneratorGUI.this.connect();
                    }
                }
            });
            this.jMenuItemCreateLogFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GeneratorGUI.this.mLogFileFlag) {
                        ((GeneratorGUI)GeneratorGUI.this).mCreateLogFileDialog.mLogFile = GeneratorGUI.this.mLogFilePath == null || GeneratorGUI.this.mLogFilePath.equals("") ? Messages.getString("GeneratorGUI.18") : GeneratorGUI.this.mLogFilePath;
                        ((GeneratorGUI)GeneratorGUI.this).mCreateLogFileDialog.jLogFileTextField.setText(((GeneratorGUI)GeneratorGUI.this).mCreateLogFileDialog.mLogFile);
                        GeneratorGUI.this.mCreateLogFileDialog.setVisible(true);
                    }
                }
            });
        }
        return this.jMenuItemCreateLogFile;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getJMenu());
        }
        return this.jJMenuBar;
    }

    private JButton getJSelectRootDir() {
        if (this.jSelectRootDir == null) {
            this.jSelectRootDir = new JButton();
            this.jSelectRootDir.setText(Messages.getString("GeneratorGUI.19"));
            this.jSelectRootDir.setToolTipText(Messages.getString("GeneratorGUI.20"));
            this.jSelectRootDir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneratorGUI.this.getRootDir();
                }
            });
        }
        return this.jSelectRootDir;
    }

    private JPanel getJRootDirPanel() {
        if (this.jRootDirPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jRootDirPanel = new JPanel();
            this.jRootDirPanel.setLayout(new GridBagLayout());
            gridBagConstraints2.anchor = 23;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 7;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.weightx = 1.0;
            this.jRootDirPanel.add((Component)this.getJSelectRootDir(), gridBagConstraints2);
            this.jRootDirPanel.add((Component)this.getJRootDirTextField(), gridBagConstraints);
        }
        return this.jRootDirPanel;
    }

    private JTextField getJRootDirTextField() {
        if (this.jRootDirTextField == null) {
            this.jRootDirTextField = new JTextField();
            this.jRootDirTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    GeneratorGUI.this.mRootDirPath = GeneratorGUI.this.jRootDirTextField.getText();
                    File file = new File(GeneratorGUI.this.mRootDirPath);
                    GeneratorGUI.this.mRootDirPath = file.getAbsolutePath();
                    GeneratorGUI.this.mJavaRoot.setRootDir(GeneratorGUI.this.mRootDirPath);
                }
            });
        }
        return this.jRootDirTextField;
    }

    private JScrollPane getJSelectTreeScrollPane() {
        if (this.jSelectTreeScrollPane == null) {
            this.jSelectTreeScrollPane = new JScrollPane();
            this.jSelectTreeScrollPane.setViewportView(this.getJSelectTree());
        }
        return this.jSelectTreeScrollPane;
    }

    private JScrollPane getJGenerateListScrollPane() {
        if (this.jGenerateListScrollPane1 == null) {
            this.jGenerateListScrollPane1 = new JScrollPane();
            this.jGenerateListScrollPane1.setViewportView(this.getJGenerateList());
        }
        return this.jGenerateListScrollPane1;
    }

    private JPanel getJPanelAddRemove() {
        if (this.jPanelAddRemove == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            this.jPanelAddRemove = new JPanel();
            this.jPanelAddRemove.setLayout(new GridBagLayout());
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(5, 3, 5, 5);
            this.jPanelAddRemove.add((Component)this.getJAddButton(), gridBagConstraints2);
            this.jPanelAddRemove.add((Component)this.getJRemoveButton(), gridBagConstraints);
        }
        return this.jPanelAddRemove;
    }

    private JMenuItem getJMenuItemExit() {
        if (this.jMenuExit == null) {
            this.jMenuExit = new JMenuItem();
            this.jMenuExit.setText(Messages.getString("GeneratorGUI.21"));
            this.jMenuExit.setToolTipText(Messages.getString("GeneratorGUI.22"));
            this.jMenuExit.setMnemonic(88);
            this.jMenuExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneratorGUI.this.dispose();
                    System.exit(0);
                }
            });
        }
        return this.jMenuExit;
    }

    private JMenuItem getJMenuItemSelectRooDir() {
        if (this.jMenuItemSelectRootDir == null) {
            this.jMenuItemSelectRootDir = new JMenuItem();
            this.jMenuItemSelectRootDir.setText(Messages.getString("GeneratorGUI.23"));
            this.jMenuItemSelectRootDir.setMnemonic(68);
            this.jMenuItemSelectRootDir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GeneratorGUI.this.getRootDir();
                }
            });
        }
        return this.jMenuItemSelectRootDir;
    }

    public static void main(String[] stringArray) {
        GeneratorGUI.createAndShowGUI();
    }

    public void terminate() {
        this.writePropertiesToConfigFile();
        this.mChangeNamespaceDialog.dispose();
        this.mCreateLogFileDialog.dispose();
    }

    public GeneratorGUI() {
        this.initialize();
        this.initDialogs();
        this.mFirstTimeThruFlag = true;
        this.setFromConfigPropertiesFile();
        if (this.mGenFlags.mNewCollections) {
            this.jNewCollectionsCheckBox.setSelected(true);
        } else {
            this.jNewCollectionsCheckBox.setSelected(false);
        }
        if (this.mGenFlags.mPrimitiveDataTypes) {
            this.jPrimitiveDataTypesCheckBox.setSelected(true);
        } else {
            this.jPrimitiveDataTypesCheckBox.setSelected(false);
        }
        this.mSelectSet = new HashSet();
        this.connect();
    }

    private void initialize() {
        this.setBounds(0, 0, 475, 500);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GeneratorGUI.this.terminate();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.ipady = 20;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.ipadx = 192;
            gridBagConstraints3.ipady = 1;
            gridBagConstraints3.anchor = 23;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.weighty = 2.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 6;
            gridBagConstraints5.gridwidth = 1;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.ipady = 50;
            this.jContentPane.add((Component)this.getJJMenuBar(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getJRootDirPanel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getJTreePanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJOptionPanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getJOutputScrollPane(), gridBagConstraints5);
        }
        return this.jContentPane;
    }

    private void initDialogs() {
        if (this.mChangeNamespaceDialog == null) {
            this.mChangeNamespaceDialog = new LoginDialog((Frame)this, this);
            this.mChangeNamespaceDialog.setLocationRelativeTo(this);
        }
        if (this.mCreateLogFileDialog == null) {
            this.mCreateLogFileDialog = new CreateLogFileDialog((Frame)this, this);
            this.mCreateLogFileDialog.setLocationRelativeTo(this);
        }
        if (this.jRootDirChooser == null) {
            this.jRootDirChooser = new JFileChooser();
            this.jRootDirChooser.setFileSelectionMode(1);
        }
    }

    private void setFromConfigPropertiesFile() {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        File file = null;
        try {
            file = new File(Messages.getString("GeneratorGUI.24"));
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (bl) {
            boolean bl2 = true;
            try {
                this.mConfigProperties.load(fileInputStream);
            }
            catch (IOException iOException) {
                bl2 = false;
            }
        }
        this.mServer = this.mConfigProperties.getProperty("host", "localhost");
        this.mPort = this.mConfigProperties.getProperty("port", "1972");
        this.mNamespace = this.mConfigProperties.getProperty("namespace", Messages.getString("GeneratorGUI.30"));
        this.mUser = this.mConfigProperties.getProperty("user", "_SYSTEM");
        if (this.mPassword == null) {
            this.mPassword = "SYS";
        }
        this.mRootDirPath = this.mConfigProperties.getProperty("rootdir", new File(".").getAbsolutePath());
        this.mLogFilePath = this.mConfigProperties.getProperty("logfile", "");
        if (this.mFirstTimeThruFlag) {
            if (this.mLogFilePath == null || this.mLogFilePath.equals("")) {
                this.mFirstTimeThruFlag = false;
                this.jMenuItemCreateLogFile.setSelected(false);
                this.mLogFileFlag = false;
            } else {
                this.jMenuItemCreateLogFile.setSelected(true);
                this.mLogFileFlag = true;
            }
        }
        this.mConfigProperties.setProperty("display", "false");
        try {
            String string = this.mConfigProperties.getProperty("flags", new GenFlags("", null, null).toString());
            this.mGenFlags = new GenFlags(string, null, null);
        }
        catch (CacheException cacheException) {
            System.out.println(Messages.getString("GeneratorGUI.43") + file.getAbsolutePath());
            cacheException.printStackTrace();
            System.exit(1);
        }
        this.jRootDirTextField.setText(this.mRootDirPath);
        this.mCreateLogFileDialog.mLogFile = this.mLogFilePath;
    }

    public void writePropertiesToConfigFile() {
        this.mConfigProperties.setProperty("host", this.mServer);
        this.mConfigProperties.setProperty("port", this.mPort);
        this.mConfigProperties.setProperty("namespace", this.mNamespace);
        this.mConfigProperties.setProperty("user", this.mUser);
        this.mConfigProperties.setProperty("rootdir", this.jRootDirTextField.getText());
        this.mConfigProperties.setProperty("logfile", this.mLogFilePath);
        this.mConfigProperties.remove("password");
        this.mConfigProperties.setProperty("flags", this.mGenFlags.toString());
        try {
            this.mConfigProperties.store(new FileOutputStream("GeneratorGUI.properties"), "GeneratorGUI.properties");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connect() {
        try {
            this.mJavaRoot = new JavaRoot(this.mConfigProperties, this.mPassword);
            this.mIsConnected = true;
            this.mDB = this.mJavaRoot.getDB();
            this.processPackageTree();
            TreePath treePath = new TreePath(this.mNodes);
            this.mSelectTreeModel.setRoot(this.mTop);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.processConnectionException(classNotFoundException);
        }
        catch (SQLException sQLException) {
            this.processConnectionException(sQLException);
        }
        catch (CacheException cacheException) {
            this.processConnectionException(cacheException);
        }
    }

    public void processConnectionException(Exception exception) {
        this.mIsConnected = false;
        JOptionPane.showMessageDialog(this, Messages.getString("GeneratorGUI.60") + exception.getMessage());
        this.mChangeNamespaceDialog.setFromParent();
        this.mChangeNamespaceDialog.setVisible(true);
    }

    public void processRunException(Exception exception) {
        this.mIsConnected = false;
        JOptionPane.showMessageDialog(this, Messages.getString("GeneratorGUI.61") + exception.getMessage());
    }

    public void processPackageTree() throws CacheException {
        ObjectHandleHolder objectHandleHolder = new ObjectHandleHolder(null);
        CPPStoredProc.getPackageTree(this.mDB, "", objectHandleHolder, false);
        GlobalCharacterStream globalCharacterStream = (GlobalCharacterStream)objectHandleHolder.value;
        CacheReader cacheReader = globalCharacterStream.getReader();
        BufferedReader bufferedReader = new BufferedReader(cacheReader);
        String string = "";
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string + string2;
            }
        }
        catch (IOException iOException) {
            throw new CacheException(iOException.getMessage());
        }
        this.mPackageTree = string;
        this.parsePackageTree();
    }

    public void parsePackageTree() {
        int n = this.countNodes();
        this.mNodes = new Object[n];
        this.mNodeIndex = 0;
        this.mTop = null;
        this.mScan = 0;
        while (this.mScan < this.mPackageTree.length()) {
            char c = this.mPackageTree.charAt(this.mScan);
            if (c == '+') {
                ++this.mScan;
                this.getTree();
                continue;
            }
            if (c == '(') {
                ++this.mScan;
                continue;
            }
            if (c == ')') {
                this.popCurrentNode();
                ++this.mScan;
                continue;
            }
            if (c != '-') continue;
            ++this.mScan;
            this.getFile();
        }
    }

    public int countNodes() {
        int n = 0;
        for (int i = 0; i < this.mPackageTree.length(); ++i) {
            char c = this.mPackageTree.charAt(i);
            if (c == '+') {
                ++n;
                continue;
            }
            if (c != '-') continue;
            ++n;
        }
        return n;
    }

    public void getTree() {
        int n = this.mScan;
        while (!this.isSpecialChar()) {
            ++this.mScan;
        }
        if (this.mTop == null) {
            this.mCurrentNode = this.mTop = new DefaultMutableTreeNode(new TreeNode(this.mPackageTree.substring(n, this.mScan), false));
            this.pushCurrentNode();
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new TreeNode(this.mPackageTree.substring(n, this.mScan), false));
            this.pushCurrentNode();
            this.mCurrentNode.add(defaultMutableTreeNode);
            this.mCurrentNode = defaultMutableTreeNode;
        }
        this.mNodes[this.mNodeIndex++] = this.mCurrentNode;
    }

    public void getFile() {
        int n = this.mScan;
        while (!this.isSpecialChar()) {
            ++this.mScan;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new TreeNode(this.mPackageTree.substring(n, this.mScan), true));
        this.mCurrentNode.add(defaultMutableTreeNode);
        this.mNodes[this.mNodeIndex++] = defaultMutableTreeNode;
    }

    public void pushCurrentNode() {
        this.mNodeStack.push(this.mCurrentNode);
    }

    public void popCurrentNode() {
        this.mCurrentNode = (DefaultMutableTreeNode)this.mNodeStack.pop();
    }

    public boolean isSpecialChar() {
        char c = this.mPackageTree.charAt(this.mScan);
        if (c == '+') {
            return true;
        }
        if (c == '-') {
            return true;
        }
        if (c == ')') {
            return true;
        }
        return c == '(';
    }

    private JScrollPane getJOutputScrollPane() {
        if (this.jOutputScrollPane == null) {
            this.jOutputScrollPane = new JScrollPane();
            this.jOutputScrollPane.setViewportView(this.getJOutputList());
        }
        return this.jOutputScrollPane;
    }

    private JList getJOutputList() {
        if (this.jOutputList == null) {
            this.mOutputListModel = new DefaultListModel();
            this.jOutputList = new JList(this.mOutputListModel);
            this.jOutputList.setToolTipText(Messages.getString("GeneratorGUI.64"));
        }
        return this.jOutputList;
    }

    public void guiEnable(boolean bl) {
        this.jGenerateButton.setEnabled(bl);
        this.jAddButton.setEnabled(bl);
        this.jRemoveButton.setEnabled(bl);
        this.jGenerateList.setEnabled(bl);
        this.jOutputList.setEnabled(bl);
        this.jMenu.setEnabled(bl);
        this.jSelectRootDir.setEnabled(bl);
        this.jRootDirTextField.setEnabled(bl);
        this.jNewCollectionsCheckBox.setEnabled(bl);
        this.jPrimitiveDataTypesCheckBox.setEnabled(bl);
        this.jSelectTree.setEnabled(bl);
    }

    public void getRootDir() {
        this.mRootDirPath = this.jRootDirTextField.getText();
        this.jRootDirChooser.setCurrentDirectory(new File(this.mRootDirPath));
        int n = this.jRootDirChooser.showOpenDialog(this);
        if (n == 0) {
            this.mRootDirPath = this.jRootDirChooser.getSelectedFile().getAbsolutePath();
            this.jRootDirTextField.setText(this.jRootDirChooser.getSelectedFile().getAbsolutePath());
            this.mJavaRoot.setRootDir(this.mRootDirPath);
        }
    }

    public void setGenerationType(int n) {
        this.mFlags = this.mGenFlags.canonizeFlags(this.mGenFlags.mDocumaticHost, this.mGenFlags.mDocumaticPort, this.mGenFlags.mNewCollections, this.mGenFlags.mPrimitiveDataTypes, n);
        try {
            this.mGenFlags = new GenFlags(this.mFlags, null, null);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public class TreeNode {
        String name;
        boolean isClass;

        public TreeNode(String string, boolean bl) {
            this.name = string;
            this.isClass = bl;
        }

        public String toString() {
            return this.name;
        }
    }
}

