/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.gateway;

import com.intersys.cache.CacheClassBuilder;
import com.intersys.objects.CacheException;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class XMLClassGenerator
extends CacheClassBuilder {
    private StringWriter writer;
    private boolean closedElement = true;

    public void saveMethod(Object object) throws Exception {
        this.endElement("Method");
    }

    @Override
    public Object createEmptyClass(String string) throws Exception {
        this.writer = new StringWriter();
        this.closedElement = true;
        this.startDocument();
        this.startElement("Export");
        this.addAttribute("generator", "Cache");
        this.addAttribute("version", "23");
        this.startElement("Class");
        this.addAttribute("name", string);
        return this.writer;
    }

    @Override
    public void addSuper(Object object, String string) throws Exception {
        this.startElement("Super");
        this.writeElement(string);
        this.endElement("Super");
    }

    public void addDdlAllowed(Object object) throws Exception {
        this.startElement("DdlAllowed");
        this.writeElement("1");
        this.endElement("DdlAllowed");
    }

    @Override
    public void useProcedureBlock(Object object, boolean bl) throws Exception {
        this.startElement("ProcedureBlock");
        if (bl) {
            this.writeElement('1');
        } else {
            this.writeElement('0');
        }
        this.endElement("ProcedureBlock");
    }

    @Override
    public void defineReturnType(Object object, String string) throws Exception {
        this.startElement("ReturnType");
        this.writeElement(string);
        this.endElement("ReturnType");
    }

    @Override
    public void defineIsFinal(Object object, boolean bl) throws Exception {
        this.startElement("Final");
        if (bl) {
            this.writeElement('1');
        } else {
            this.writeElement('0');
        }
        this.endElement("Final");
    }

    @Override
    public void defineIsStatic(Object object, boolean bl) throws Exception {
        this.startElement("ClassMethod");
        if (bl) {
            this.writeElement('1');
        } else {
            this.writeElement('0');
        }
        this.endElement("ClassMethod");
    }

    @Override
    public void defineBody(Object object, String string) throws Exception {
        this.startElement("Implementation");
        this.startCDATA();
        this.writeElement(string);
        this.endCDATA();
        this.endElement("Implementation");
        this.endElement("Method");
    }

    @Override
    public void defineArguments(Object object, String[] stringArray, String[] stringArray2, boolean[] blArray, String[] stringArray3) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (blArray[i]) {
                stringBuffer.append("&");
            }
            stringBuffer.append(stringArray2[i]);
            stringBuffer.append(":");
            stringBuffer.append(stringArray[i]);
            if (stringArray3 != null && stringArray3[i] != null) {
                stringBuffer.append("=" + stringArray3[i]);
            }
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        this.startElement("FormalSpec");
        this.startCDATA();
        this.writeElement(stringBuffer.toString());
        this.endCDATA();
        this.endElement("FormalSpec");
    }

    @Override
    public Object createMethod(Object object, String string) throws Exception {
        this.startElement("Method");
        this.addAttribute("name", string);
        return object;
    }

    @Override
    public Object loadExistingClass(String string) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsPersistent(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsSerial(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsDatatype(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsAbstract(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public Object createProperty(Object object, String string) throws Exception {
        throw new Exception("Not supported");
    }

    public Object createProperty(Object object, String string, String string2) throws Exception {
        this.startElement("Property");
        this.addAttribute("name", string);
        if (string2.startsWith("list ")) {
            string2 = string2.substring(5);
            this.startElement("Collection");
            this.writeElement("list");
            this.endElement("Collection");
        }
        if (string2.startsWith("array ")) {
            string2 = string2.substring(6);
            this.startElement("Collection");
            this.writeElement("array");
            this.endElement("Collection");
            this.startElement("Parameter");
            this.addAttribute("name", "STORAGEDEFAULT");
            this.addAttribute("value", "list");
            this.endElement("Parameter");
        }
        this.startElement("Type");
        this.writeElement(string2);
        this.endElement("Type");
        this.endElement("Property");
        return object;
    }

    @Override
    public void defineType(Object object, String string) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsList(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsArray(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsTransient(Object object, boolean bl) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineIsRequired(Object object, boolean bl) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineRelationship(Object object, String string, String string2) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public Object createParameter(Object object, String string, String string2) throws Exception {
        this.startElement("Parameter");
        this.addAttribute("name", string);
        this.startElement("Type");
        this.writeElement("STRING");
        this.endElement("Type");
        this.startElement("Default");
        this.startCDATA();
        this.writeElement(string2);
        this.endCDATA();
        this.endElement("Default");
        this.endElement("Parameter");
        return object;
    }

    @Override
    public Object createParameter(Object object, String string, int n) throws Exception {
        String string2 = String.valueOf(n);
        this.startElement("Parameter");
        this.addAttribute("name", string);
        this.startElement("Type");
        this.writeElement("INTEGER");
        this.endElement("Type");
        this.startElement("Default");
        this.startCDATA();
        this.writeElement(string2);
        this.endCDATA();
        this.endElement("Default");
        this.endElement("Parameter");
        return object;
    }

    @Override
    public Object createParameter(Object object, String string, boolean bl) throws Exception {
        String string2 = "true";
        if (!bl) {
            string2 = "false";
        }
        this.startElement("Parameter");
        this.addAttribute("name", string);
        this.startElement("Type");
        this.writeElement("BOOLEAN");
        this.endElement("Type");
        this.startElement("Default");
        this.startCDATA();
        this.writeElement(string2);
        this.endCDATA();
        this.endElement("Default");
        this.endElement("Parameter");
        return object;
    }

    @Override
    public Object createClassParameter(Object object, String string, Object object2, String string2) throws Exception {
        if (string2.equals("BOOLEAN") && object2 instanceof Boolean) {
            return this.createParameter(object, string, (Boolean)object2);
        }
        if (string2.equals("INTEGER") && object2 instanceof Integer) {
            return this.createParameter(object, string, (Integer)object2);
        }
        if (string2.equals("STRING") && object2 instanceof String) {
            return this.createParameter(object, string, (String)object2);
        }
        throw new Exception("Unsupported parameter type");
    }

    @Override
    public Object createIndex(Object object, String string, String string2, String string3, boolean bl, boolean bl2, String string4) throws Exception {
        throw new Exception("Not supported");
    }

    public Object createIndex(Object object, String string, String string2, String string3) throws Exception {
        this.startElement("Index");
        this.addAttribute("name", string);
        this.startElement("Properties");
        this.writeElement(string2);
        this.endElement("Properties");
        this.startElement("Type");
        this.writeElement(string3);
        this.endElement("Type");
        this.endElement("Index");
        return object;
    }

    public Object createIndex(Object object, String string, String string2) throws Exception {
        this.startElement("Index");
        this.addAttribute("name", string);
        this.startElement("Properties");
        this.writeElement(string2);
        this.endElement("Properties");
        this.endElement("Index");
        return object;
    }

    public Object createStorage(Object object, String string, String[] stringArray, String string2, String string3, String string4, String string5, String string6) throws Exception {
        this.startElement("Storage");
        this.addAttribute("name", "Default");
        this.startElement("Type");
        this.writeElement("%Library.CacheStorage");
        this.endElement("Type");
        this.startElement("DataLocation");
        this.writeElement(string2);
        this.endElement("DataLocation");
        this.startElement("DefaultData");
        this.writeElement(string + "DefaultData");
        this.endElement("DefaultData");
        this.startElement("IdLocation");
        this.writeElement(string3);
        this.endElement("IdLocation");
        this.startElement("IndexLocation");
        this.writeElement(string4);
        this.endElement("IndexLocation");
        this.startElement("StreamLocation");
        this.writeElement(string5);
        this.endElement("StreamLocation");
        this.startElement("Data");
        this.addAttribute("name", string6);
        for (int i = 0; i < stringArray.length; ++i) {
            this.startElement("Value");
            this.addAttribute("name", Integer.toString(i + 1));
            this.startElement("Value");
            this.writeElement(stringArray[i]);
            this.endElement("Value");
            this.endElement("Value");
        }
        this.endElement("Data");
        this.endElement("Storage");
        return object;
    }

    public Object createStorage(Object object, String string, String[] stringArray, String string2) throws Exception {
        this.startElement("Storage");
        this.addAttribute("name", "Default");
        this.startElement("Type");
        this.writeElement("%Library.CacheStorage");
        this.endElement("Type");
        this.startElement("Data");
        this.addAttribute("name", string2);
        for (int i = 0; i < stringArray.length; ++i) {
            this.startElement("Value");
            this.addAttribute("name", Integer.toString(i + 1));
            this.startElement("Value");
            this.writeElement(stringArray[i]);
            this.endElement("Value");
            this.endElement("Value");
        }
        this.endElement("Data");
        this.endElement("Storage");
        return object;
    }

    @Override
    public Object createForeignKey(Object object, String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public Writer createXData(Object object, String string) throws Exception {
        throw new Exception("Not supported");
    }

    public Object getJavaBlock(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public Object getClientProjectionSettings(Object object) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public Object createIDKey(Object object, String string, String string2, String string3) throws Exception {
        throw new Exception("Not supported");
    }

    public Object setSqlTableName(Object object, String string) throws Exception {
        this.startElement("SqlTableName");
        this.writeElement(string);
        this.endElement("SqlTableName");
        return object;
    }

    public Object setClassType(Object object, String string) {
        this.startElement("ClassType");
        this.writeElement(string);
        this.endElement("ClassType");
        return object;
    }

    @Override
    public void addPropertyParameter(Object object, String string, Object object2) throws Exception {
        throw new Exception("Not supported");
    }

    @Override
    public void defineSystem(Object object, int n) throws Exception {
        this.startElement("System");
        if (n == 4) {
            this.writeElement('4');
        } else if (n == 3) {
            this.writeElement('3');
        }
        this.endElement("System");
    }

    @Override
    public void setSchemaName(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method setSchemaName() is not implemented in class com.intersys.gateway.XMLClassGenerator");
    }

    @Override
    public void createNamedQuery(String string, String string2, String string3) throws CacheException {
        throw new UnsupportedOperationException("Method createNamedQuery() is not implemented in class com.intersys.gateway.XMLClassGenerator");
    }

    @Override
    public Object saveClass(Object object) throws Exception {
        this.endElement("Class");
        this.endElement("Export");
        this.writer.flush();
        return new StringReader(this.writer.toString());
    }

    public File saveAsFile(Object object, String string) throws Exception {
        this.endElement("Class");
        this.endElement("Export");
        this.writer.flush();
        String string2 = Long.toString(System.currentTimeMillis());
        File file = File.createTempFile(string + string2, ".xml");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.writer.toString());
        fileWriter.close();
        return file;
    }

    @Override
    public void defineArguments(Object object, String[] stringArray, String[] stringArray2) throws Exception {
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        String[] stringArray3 = new String[stringArray.length];
        this.defineArguments(object, stringArray, stringArray2, blArray, stringArray3);
    }

    private void addAttribute(String string, String string2) {
        this.writer.write(" " + string + "=\"" + string2 + "\"");
    }

    private void startElement(String string) {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write("\r\n<" + string);
        this.closedElement = false;
    }

    private void endElement(String string) {
        if (this.closedElement) {
            this.writer.write("</" + string + ">");
        } else {
            this.writer.write("></" + string + ">");
            this.closedElement = true;
        }
    }

    private void writeElement(String string) {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write(string);
    }

    private void writeElement(char c) {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write(c);
    }

    private void startCDATA() {
        if (!this.closedElement) {
            this.writer.write(">");
            this.closedElement = true;
        }
        this.writer.write("<![CDATA[");
    }

    private void endCDATA() {
        this.writer.write("]]>");
    }

    private void startDocument() {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }
}

