/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionPoolDataSource;
import com.intersys.jdbc.CacheDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class CacheDataSource
implements DataSource {
    static CacheDriver driver;
    private String password = "";
    private String user = "";
    private String database = null;
    private String server = null;
    private String IPv6address = null;
    private String url = null;
    private int port = 1972;
    private PrintWriter logStream = null;
    private String dataSource = null;
    private String description = null;
    private String eventClass = "";
    private int loginTimeout = 0;
    private boolean nodelay = true;
    private int securityLevel = 0;
    private String principalName = null;
    private String sSLConfigName = null;
    private String keyRecoveryPassword = null;
    private int isolationLevel = 1;

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        this.getURL();
        if (this instanceof CacheConnectionPoolDataSource) {
            return CacheDriver.CPManager.lookup((CacheConnectionPoolDataSource)this, string, string2).getConnection();
        }
        return new CacheConnection(this, string, string2, null);
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        return this.logStream;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logStream = printWriter;
    }

    @Override
    public synchronized void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.loginTimeout;
    }

    public synchronized void setDatabaseName(String string) {
        this.database = string;
    }

    public synchronized String getDatabaseName() {
        return this.database;
    }

    public synchronized void setDataSourceName(String string) {
        this.dataSource = string;
    }

    public synchronized String getDataSourceName() {
        return this.dataSource;
    }

    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPortNumber(int n) {
        this.port = n;
    }

    public synchronized int getPortNumber() {
        return this.port;
    }

    public synchronized void setServerName(String string) {
        this.server = string;
    }

    public synchronized String getServerName() {
        return this.server;
    }

    public synchronized void setIPv6ServerAddress(String string) {
        this.IPv6address = string;
    }

    public synchronized String getIPv6ServerAddress() {
        return this.IPv6address;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public synchronized String getUser() {
        return this.user;
    }

    public synchronized void setEventClass(String string) {
        this.eventClass = string;
        if (this.eventClass == null) {
            this.eventClass = "";
        }
    }

    public synchronized String getEventClass() {
        return this.eventClass;
    }

    public synchronized void setURL(String string) throws SQLException {
        int n;
        if (!string.startsWith("jdbc:Cache://")) {
            throw new SQLException("Invalid URL: " + string, "S1000");
        }
        this.url = string;
        String string2 = this.url.substring(13);
        if ((string2 = this.parseCredentials(string2)).startsWith("[")) {
            n = string2.indexOf("]");
            if (n == -1) {
                throw new SQLException("Invalid URL: " + string, "S1000");
            }
            this.server = this.IPv6address = string2.substring(1, n);
            if (!(string2 = string2.substring(n + 1)).startsWith(":")) {
                throw new SQLException("Invalid URL: " + string, "S1000");
            }
            n = (string2 = string2.substring(1)).indexOf("/");
            if (n == -1) {
                throw new SQLException("Invalid URL: " + string, "S1000");
            }
        } else {
            n = string2.indexOf(":");
            if (n == -1) {
                throw new SQLException("Invalid URL: " + string, "S1000");
            }
            this.server = string2.substring(0, n);
            if ((n = (string2 = string2.substring(n + 1)).indexOf("/")) == -1) {
                return;
            }
        }
        this.port = Integer.parseInt(string2.substring(0, n));
        if ((n = (string2 = string2.substring(n + 1)).indexOf("/")) == -1) {
            this.database = string2;
            this.logStream = null;
            return;
        }
        this.database = string2.substring(0, n);
        if ((n = (string2 = string2.substring(n + 1)).indexOf(":")) == -1) {
            this.setLogStream(string2);
            return;
        }
        this.setLogStream(string2.substring(0, n));
        string2 = string2.substring(n + 1);
        this.parseExtension(string2);
    }

    public synchronized String getURL() {
        if (this.url == null) {
            this.url = this.server != null ? "jdbc:Cache://" + this.server + ":" + this.port + "/" + this.database : "jdbc:Cache://[" + this.IPv6address + "]:" + this.port + "/" + this.database;
        }
        return this.url;
    }

    public synchronized void setNodelay(boolean bl) {
        this.nodelay = bl;
    }

    public synchronized boolean getNodelay() {
        return this.nodelay;
    }

    public synchronized void setServicePrincipalName(String string) {
        this.principalName = string;
    }

    public synchronized String getServicePrincipalName() {
        return this.principalName;
    }

    public synchronized void setConnectionSecurityLevel(int n) {
        this.securityLevel = n;
    }

    public synchronized int getConnectionSecurityLevel() {
        return this.securityLevel;
    }

    public synchronized void setSSLConfigurationName(String string) {
        this.sSLConfigName = string;
    }

    public synchronized String getSSLConfigurationName() {
        return this.sSLConfigName;
    }

    public synchronized void setKeyRecoveryPassword(String string) {
        this.keyRecoveryPassword = string;
    }

    public synchronized String getKeyRecoveryPassword() {
        return this.keyRecoveryPassword;
    }

    public synchronized void setLogFile(String string) throws SQLException {
        this.setLogStream(string);
    }

    private synchronized void setLogStream(String string) throws SQLException {
        if (string == null || string.equals("")) {
            this.logStream = null;
        } else {
            try {
                File file = new File(string);
                file.delete();
                this.logStream = new PrintWriter(new FileOutputStream(file, true), true);
            }
            catch (Exception exception) {
                throw new SQLException("Invalid log file name: " + string, "S1000");
            }
        }
    }

    public synchronized int getDefaultTransactionIsolation() {
        return this.isolationLevel;
    }

    public synchronized void setDefaultTransactionIsolation(int n) {
        this.isolationLevel = n;
    }

    private void parseExtension(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            this.eventClass = string;
        } else {
            this.eventClass = string.substring(0, n);
            if ((string = string.substring(n + 1)).equalsIgnoreCase("false")) {
                this.nodelay = false;
            }
        }
    }

    private String parseCredentials(String string) {
        int n = string.indexOf("?");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.indexOf("username=");
        if (n2 != -1) {
            if ((n2 = (string2 = string2.substring(n2 + 9)).indexOf("&password=")) != -1) {
                this.user = string2.substring(0, n2);
                this.password = string2.substring(n2 + 10);
            } else {
                this.user = string2;
            }
        }
        return string.substring(0, n);
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public Object unwrap(Class clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return this;
        }
        throw new SQLException("Receiver not a wrapper");
    }

    static {
        if (driver == null) {
            try {
                driver = (CacheDriver)Class.forName("com.intersys.jdbc.CacheDriver").newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

