/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.mds.jni;

import com.intersys.mds.MDSException;
import com.intersys.mds.MDSNodeReference;
import com.intersys.mds.MDSSessionException;
import com.intersys.mds.internal.MDSClassInternal;
import com.intersys.mds.internal.MDSNodeReferenceInternal;
import com.intersys.mds.internal.MDSObjectInputStream;
import com.intersys.mds.internal.MDSObjectOutputStream;
import com.intersys.mds.internal.MDSSessionInternal;
import com.intersys.mds.jni.MDSClassJNI;
import com.intersys.mds.jni.MDSNodeReferenceJNI;
import java.sql.Connection;
import java.sql.DriverManager;

public class MDSSessionJNI
implements MDSSessionInternal {
    private boolean __started = false;
    private Connection __JDBCConnection = null;
    private String __user = null;
    private String __password = null;
    private String __namespace = "User";
    protected long __impl = this.initImpl();
    protected static final int SESSION_TYPE_UNKNOWN = 0;
    protected static final int SESSION_TYPE_NON_THREAD_SPECIFIC = 1;
    protected static final int SESSION_TYPE_THREAD_SPECIFIC = 2;
    protected static int sessionType = 0;

    @Override
    public void start(String string, String string2, String string3) throws MDSSessionException {
        this.checkSessionType();
        this.startImpl(this.__impl, string, string2, string3);
        this.__user = string;
        this.__password = string2;
        this.__started = true;
    }

    @Override
    public void start(String string, String string2) throws MDSSessionException {
        this.checkSessionType();
        this.startImpl(this.__impl, string, string2);
        this.__user = string;
        this.__password = string2;
        this.__started = true;
    }

    @Override
    public void connect(String string, String string2, String string3) throws MDSSessionException {
        this.checkSessionType();
        this.connectImpl(this.__impl, string, string2, string3);
        this.__namespace = string;
        this.__user = string2;
        this.__password = string3;
        this.__started = true;
    }

    @Override
    public void end() throws MDSSessionException {
        if (this.__JDBCConnection != null) {
            try {
                this.__JDBCConnection.close();
            }
            catch (Exception exception) {
                throw new MDSSessionException("Error closing JDBC connection: " + exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
        if (this.__started) {
            this.endImpl(this.__impl);
            this.__started = false;
        }
    }

    @Override
    public Connection getJDBCConnection() throws MDSSessionException {
        if (this.__JDBCConnection == null) {
            try {
                String string = "jdbc:Cache://SPCHOST:1972/" + this.__namespace;
                Class.forName("com.intersys.jdbc.CacheDriver");
                this.__JDBCConnection = DriverManager.getConnection(string, this.__user, this.__password);
            }
            catch (Exception exception) {
                throw new MDSSessionException("Error creating JDBC connection: " + exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
        return this.__JDBCConnection;
    }

    @Override
    public void setNamespace(String string) throws MDSSessionException {
        this.setNamespaceImpl(this.__impl, string);
        this.__namespace = string;
    }

    @Override
    public void releaseAllLocks() throws MDSException {
        this.releaseAllLocksImpl(this.__impl);
    }

    @Override
    public void startTransaction() throws MDSSessionException {
        this.startTransactionImpl(this.__impl);
    }

    @Override
    public void commit() throws MDSSessionException {
        this.commitImpl(this.__impl);
    }

    @Override
    public void rollback() throws MDSSessionException {
        this.rollbackImpl(this.__impl);
    }

    @Override
    public void rollback(int n) throws MDSSessionException {
        this.rollbackImpl(this.__impl, n);
    }

    @Override
    public int transactionLevel() throws MDSSessionException {
        return this.transactionLevelImpl(this.__impl);
    }

    @Override
    public MDSNodeReference createNodeReference() {
        return new MDSNodeReferenceJNI();
    }

    @Override
    public MDSNodeReference createNodeReference(String string) {
        return new MDSNodeReferenceJNI(string);
    }

    @Override
    public MDSNodeReferenceInternal createNodeReferenceInternal() {
        return new MDSNodeReferenceJNI();
    }

    @Override
    public MDSNodeReferenceInternal createNodeReferenceInternal(String string) {
        return new MDSNodeReferenceJNI(string);
    }

    @Override
    public MDSClassInternal createClassInternal(String string) {
        return new MDSClassJNI(this, string, this.__namespace);
    }

    public MDSClassInternal createClassInternal(String string, int n) {
        return new MDSClassJNI(this, string, this.__namespace, n);
    }

    public MDSClassInternal createClassInternal(String string, int n, int n2) {
        return new MDSClassJNI(this, string, this.__namespace, n, n2);
    }

    @Override
    public void setObjectStreams(MDSObjectInputStream mDSObjectInputStream, MDSObjectOutputStream mDSObjectOutputStream) throws MDSSessionException {
        this.setObjectStreamsImpl(this.__impl, mDSObjectInputStream, mDSObjectOutputStream);
    }

    public static native int getCurrentMs();

    public void callProcedure(String string, String string2, String[] stringArray) throws MDSSessionException {
        this.callProcedureImpl(this.__impl, string, string2, stringArray);
    }

    public String callFunction(String string, String string2, String[] stringArray) throws MDSSessionException {
        return this.callFunctionImpl(this.__impl, string, string2, stringArray);
    }

    long impl() {
        return this.__impl;
    }

    private native long initImpl();

    private native void startImpl(long var1, String var3, String var4, String var5);

    private native void startImpl(long var1, String var3, String var4);

    private native void connectImpl(long var1, String var3, String var4, String var5);

    private native void endImpl(long var1);

    private native void setNamespaceImpl(long var1, String var3);

    private native void releaseAllLocksImpl(long var1) throws MDSException;

    private native void startTransactionImpl(long var1) throws MDSSessionException;

    private native void commitImpl(long var1) throws MDSSessionException;

    private native void rollbackImpl(long var1) throws MDSSessionException;

    private native void rollbackImpl(long var1, int var3) throws MDSSessionException;

    private native int transactionLevelImpl(long var1) throws MDSSessionException;

    private native void callProcedureImpl(long var1, String var3, String var4, String[] var5);

    private native String callFunctionImpl(long var1, String var3, String var4, String[] var5);

    private native void setObjectStreamsImpl(long var1, Object var3, Object var4);

    protected void checkSessionType() throws MDSSessionException {
    }

    public static int getSessionType() {
        return sessionType;
    }
}

