/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.Database;
import java.io.Serializable;
import java.sql.SQLException;

public class StatusCode
implements Serializable {
    public static final StatusCode OK = new StatusCode(0);
    private byte[] m_statuscode;
    private String m_errortext = "";
    private int m_errorcode = 0;

    public StatusCode(int n) {
        this.m_errorcode = n;
        if (n == 0) {
            this.m_statuscode = new byte[1];
            this.m_statuscode[0] = 49;
        } else {
            try {
                ConnectionInfo connectionInfo = new ConnectionInfo();
                Object object = SysListProxy.createSysList(connectionInfo);
                SysListProxy.setInteger(object, n);
                Object object2 = SysListProxy.createSysList(connectionInfo);
                SysListProxy.setSysList(object2, object);
                byte[] byArray = SysListProxy.getBinaryData(object2);
                this.m_statuscode = new byte[byArray.length + 2];
                this.m_statuscode[0] = 48;
                this.m_statuscode[1] = 32;
                System.arraycopy(byArray, 0, this.m_statuscode, 2, byArray.length);
            }
            catch (SQLException sQLException) {
                this.m_statuscode = new byte[1];
                this.m_statuscode[0] = 48;
            }
        }
    }

    public StatusCode(byte[] byArray) {
        this.m_statuscode = byArray;
        this.parse();
    }

    public StatusCode(byte[] byArray, Database database) {
        this.m_statuscode = byArray;
    }

    public byte[] getBytes() {
        return this.m_statuscode;
    }

    public boolean isError() {
        return this.m_statuscode[0] == 48;
    }

    public String getText() {
        if (this.m_errortext != null) {
            return this.m_errortext;
        }
        this.parse();
        return this.m_errortext;
    }

    public int getCode() {
        if (this.m_errorcode != 0) {
            return this.m_errorcode;
        }
        this.parse();
        return this.m_errorcode;
    }

    public String toString() {
        String string = "Code: " + this.m_errorcode;
        if (this.m_statuscode == null) {
            string = string + "; Text: " + this.m_errortext;
        }
        ConnectionInfo connectionInfo = new ConnectionInfo();
        if (this.m_statuscode != null) {
            if (this.m_statuscode.length > 0) {
                char c = (char)this.m_statuscode[0];
                string = c == this.m_errorcode ? string + "; status: " + this.m_errorcode : string + "; status: " + c;
            }
            if (this.m_statuscode.length > 2) {
                Object object = SysListProxy.createSysList(this.m_statuscode, this.m_statuscode.length - 2, 2, connectionInfo);
                string = string + "," + object.toString();
            } else if (this.m_statuscode.length > 1 && this.m_statuscode[1] != 32) {
                Object object = SysListProxy.createSysList(this.m_statuscode, this.m_statuscode.length - 1, 1, connectionInfo);
                string = string + "," + object.toString();
            }
        }
        return string;
    }

    private void parse() {
        if (this.m_statuscode == null) {
            return;
        }
        ConnectionInfo connectionInfo = new ConnectionInfo();
        try {
            Object object;
            if (this.m_statuscode.length > 2) {
                object = SysListProxy.createSysList(this.m_statuscode, this.m_statuscode.length - 2, 2, connectionInfo);
            } else if (this.m_statuscode.length > 1 && this.m_statuscode[1] != 32) {
                object = SysListProxy.createSysList(this.m_statuscode, this.m_statuscode.length - 1, 1, connectionInfo);
            } else {
                return;
            }
            object = SysListProxy.getSysList(object);
            this.m_errorcode = SysListProxy.getInteger(object);
            this.m_errortext = SysListProxy.getString(object);
        }
        catch (SQLException sQLException) {
            throw new IllegalArgumentException("Parse error: " + sQLException.getMessage());
        }
    }
}

