/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep;

import com.intersys.mds.internal.MDSNodeReferenceInternal;
import com.intersys.mds.internal.MDSQuery;
import com.intersys.xep.EventQueryIterator;
import com.intersys.xep.XEPException;
import java.util.ArrayList;

public class EventQuery<E> {
    private boolean closed = false;
    private String sqlText;
    private ArrayList<Object> parameters;
    private MDSNodeReferenceInternal node;
    private MDSQuery mdsQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventQuery(MDSNodeReferenceInternal mDSNodeReferenceInternal, String string) throws XEPException {
        this.sqlText = string;
        this.node = mDSNodeReferenceInternal;
        this.parameters = new ArrayList();
        try {
            MDSNodeReferenceInternal mDSNodeReferenceInternal2 = this.node;
            synchronized (mDSNodeReferenceInternal2) {
                this.mdsQuery = this.node.createQuery();
            }
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void setParameter(int n, Object object) throws XEPException {
        if (this.closed) {
            throw new XEPException("Query is closed");
        }
        if (n <= 0) {
            throw new XEPException("Invalid index value");
        }
        if (n <= this.parameters.size()) {
            this.parameters.set(n - 1, object);
            return;
        }
        if (n == this.parameters.size() + 1) {
            this.parameters.add(object);
            return;
        }
        for (int i = this.parameters.size(); i < n - 1; ++i) {
            this.parameters.add(null);
        }
        this.parameters.add(object);
    }

    public synchronized void execute() throws XEPException {
        if (this.closed) {
            throw new XEPException("Query is closed");
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!this.sqlText.contains("?")) {
                throw new XEPException("Too many parameters specified");
            }
            Object object = this.parameters.get(i);
            if (object == null) {
                throw new XEPException("Parameter " + (i + 1) + " not bound");
            }
            this.sqlText = this.sqlText.replaceFirst("\\?", object.toString());
        }
        try {
            this.mdsQuery.prepare(this.sqlText);
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public String getIndexNameUsed() throws XEPException {
        String string = null;
        if (this.mdsQuery != null) {
            try {
                string = this.mdsQuery.getIndexNameUsed();
            }
            catch (Exception exception) {
                throw new XEPException(exception);
            }
        } else {
            throw new XEPException("Must call execute() before calling getIndexNameUsed()");
        }
        return string;
    }

    public EventQueryIterator<E> getIterator() {
        return new EventQueryIterator(this.mdsQuery);
    }

    public synchronized E getNext(E e) throws XEPException {
        if (this.closed) {
            throw new XEPException("Query is closed");
        }
        try {
            return (E)this.mdsQuery.next(e);
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void updateCurrent(E e) throws XEPException {
        if (this.closed) {
            throw new XEPException("Query is closed");
        }
        try {
            this.mdsQuery.updateCurrent(e);
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void deleteCurrent() throws XEPException {
        if (this.closed) {
            throw new XEPException("Query is closed");
        }
        try {
            this.mdsQuery.deleteCurrent();
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
    }

    public synchronized void close() throws XEPException {
        if (this.closed) {
            return;
        }
        try {
            this.mdsQuery.cleanup();
        }
        catch (Exception exception) {
            throw new XEPException(exception);
        }
        this.closed = true;
    }
}

