/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.xep.internal;

import com.intersys.gateway.XMLClassGenerator;
import com.intersys.mds.jni.MDSSessionJNI;
import com.intersys.xep.annotations.Index;
import com.intersys.xep.annotations.IndexType;
import com.intersys.xep.annotations.Indices;
import com.intersys.xep.annotations.Transient;
import com.intersys.xep.internal.FieldComparator;
import com.intersys.xep.internal.ObjectEventGenerator;
import com.intersys.xep.internal.TypeMap;
import com.intersys.xep.internal.filter.OrdinalPosition;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;

public class Generator {
    public static boolean eventUpToDate(MDSSessionJNI mDSSessionJNI, Class clazz, String string) throws Exception {
        String string2 = Generator.getClassLastCompiled(clazz);
        String[] stringArray = new String[]{TypeMap.normalizeName(string), string2};
        return new Boolean(mDSSessionJNI.callFunction("CompareTimestamp", "%apiXEP", stringArray));
    }

    static ArrayList<Field> getAllFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            arrayList.add(field);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && !clazz2.getName().equals("java.lang.Object")) {
            ArrayList<Field> arrayList2 = Generator.getAllFields(clazz2);
            for (Field field : arrayList2) {
                boolean bl = false;
                for (Field field2 : arrayList) {
                    if (!field.getName().equals(field2.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(field);
            }
        }
        ArrayList<Field> arrayList3 = new ArrayList<Field>();
        for (Field field : arrayList) {
            if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(Transient.class) || field.isSynthetic()) continue;
            arrayList3.add(field);
        }
        return arrayList3;
    }

    static Class getTopLevelClass(Class clazz) {
        if (clazz.isMemberClass()) {
            return Generator.getTopLevelClass(clazz.getDeclaringClass());
        }
        return clazz;
    }

    static String getClassLastCompiled(Class clazz) {
        try {
            if (clazz.isMemberClass()) {
                clazz = Generator.getTopLevelClass(clazz);
            }
            String string = clazz.getSimpleName();
            return new Timestamp(clazz.getResource(string + ".class").openConnection().getLastModified()).toString();
        }
        catch (Exception exception) {
            return new Timestamp(0L).toString();
        }
    }

    static ArrayList<Field> getAllAlphabeticallyOrderedFields(Class clazz) {
        ArrayList<Field> arrayList = Generator.getAllFields(clazz);
        Collections.sort(arrayList, new FieldComparator());
        return arrayList;
    }

    static String[] loadClasses(MDSSessionJNI mDSSessionJNI, ArrayList<File> arrayList, ArrayList<String> arrayList2) throws Exception {
        String[] stringArray = new String[]{""};
        for (int i = 0; i < arrayList2.size(); ++i) {
            String[] stringArray2 = new String[]{arrayList.get(i).getAbsolutePath()};
            String string = mDSSessionJNI.callFunction("Load", "%apiXEP", stringArray2);
            if (!string.equals("")) {
                throw new Exception(string);
            }
            arrayList.get(i).delete();
            stringArray[0] = stringArray[0].equals("") ? arrayList2.get(i) : stringArray[0] + "," + arrayList2.get(i);
        }
        return stringArray;
    }

    static void compile(MDSSessionJNI mDSSessionJNI, String[] stringArray) throws Exception {
        String string = mDSSessionJNI.callFunction("Compile", "%apiXEP", stringArray);
        if (!string.equals("")) {
            throw new Exception(string);
        }
    }

    static void generateStorage(Object object, XMLClassGenerator xMLClassGenerator, String string, String[] stringArray) throws Exception {
        xMLClassGenerator.createStorage(object, string, stringArray, "xep");
    }

    public static OrdinalPosition canonize(String string, String string2, String string3) throws Exception {
        return ObjectEventGenerator.getOrdinalPosition(string, string3);
    }

    public static Index[] getIndexAnnotations(Class clazz) {
        Indices indices = clazz.getAnnotation(Indices.class);
        if (indices != null) {
            return indices.value();
        }
        Index index = clazz.getAnnotation(Index.class);
        if (index == null) {
            return null;
        }
        Index[] indexArray = new Index[]{index};
        return indexArray;
    }

    static Object createClass(XMLClassGenerator xMLClassGenerator, String string, String string2, boolean bl) throws Exception {
        Object object;
        String string3 = string;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string3 = string.substring(n + 1);
        }
        if (bl) {
            object = xMLClassGenerator.createEmptyClass(string + "Serial");
            xMLClassGenerator.addSuper(object, "%Library.SerialObject");
        } else {
            object = xMLClassGenerator.createEmptyClass(string);
            xMLClassGenerator.setSqlTableName(object, string3);
            xMLClassGenerator.addSuper(object, "%Library.Persistent");
            xMLClassGenerator.setClassType(object, "persistent");
            xMLClassGenerator.addDdlAllowed(object);
        }
        xMLClassGenerator.defineIsFinal(object, true);
        xMLClassGenerator.createParameter(object, "IMPORTTIMESTAMP", string2);
        return object;
    }

    static void generateIndices(XMLClassGenerator xMLClassGenerator, Object object, Class clazz, ArrayList<Field> arrayList) throws Exception {
        Index[] indexArray = Generator.getIndexAnnotations(clazz);
        if (indexArray == null || indexArray.length == 0) {
            return;
        }
        for (int i = 0; i < indexArray.length; ++i) {
            IndexType indexType;
            String[] stringArray = indexArray[i].fields();
            String string = indexArray[i].name();
            if (arrayList.isEmpty() || string.equals("")) continue;
            String string2 = "";
            boolean bl = false;
            block1: for (int j = 0; j < stringArray.length; ++j) {
                for (int k = 0; k < arrayList.size(); ++k) {
                    if (!arrayList.get(k).getName().equals(stringArray[j])) continue;
                    if (!string2.equals("")) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + stringArray[j];
                    bl = true;
                    continue block1;
                }
            }
            if (!bl) {
                throw new Exception("Invalid index annotation (name = " + string + ")");
            }
            if (string2.equals("") || (indexType = indexArray[i].type()) == IndexType.none) continue;
            if (indexType == IndexType.simple) {
                xMLClassGenerator.createIndex(object, string, string2);
                continue;
            }
            xMLClassGenerator.createIndex(object, string, string2, indexArray[i].type().toString());
        }
    }
}

