/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.jalapeno.Adaptor;
import com.jalapeno.Settings;
import java.util.HashSet;
import java.util.Set;

public class ApplicationSettings
extends Settings {
    private int mFetchPolicy = 0;
    private int mClientCacheType = 0;
    private int mAccessPolicy;
    private int mMaxBatchSize = -100;
    private int mConcurrency = -100;
    private boolean mDefaultLockingMode = true;
    private ClassLoader mClassLoader = null;
    protected Set mAdaptors;

    @Override
    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    @Override
    public int getClientCacheType() {
        return this.mClientCacheType;
    }

    @Override
    public int setClientCacheType(int n) {
        ApplicationSettings.checkClientCacheType(n);
        int n2 = this.mClientCacheType;
        this.mClientCacheType = n;
        return n2;
    }

    @Override
    public int getFetchPolicy() {
        return this.mFetchPolicy;
    }

    @Override
    public int setFetchPolicy(int n) {
        ApplicationSettings.checkFetchPolicy(n);
        int n2 = this.mFetchPolicy;
        this.mFetchPolicy = n;
        return n2;
    }

    @Override
    public int getAccessMethod() {
        return this.mAccessPolicy;
    }

    @Override
    public int setAccessPolicy(int n) {
        ApplicationSettings.checkAccessPolicy(n);
        int n2 = this.mAccessPolicy;
        this.mAccessPolicy = n;
        return n2;
    }

    @Override
    public void setAdaptor(Adaptor adaptor) {
        if (this.mAdaptors == null) {
            this.mAdaptors = new HashSet();
        }
        this.mAdaptors.add(adaptor);
    }

    @Override
    public boolean removeAdaptor(Adaptor adaptor) {
        if (this.mAdaptors == null) {
            return false;
        }
        return this.mAdaptors.remove(adaptor);
    }

    @Override
    public void removeAllAdaptors() {
        if (this.mAdaptors == null) {
            return;
        }
        this.mAdaptors.clear();
    }

    @Override
    public int getMaxBatchSize() {
        return this.mMaxBatchSize;
    }

    @Override
    public void setMaxBatchSize(int n) {
        this.mMaxBatchSize = n;
    }

    @Override
    public int getConcurrency() {
        return this.mConcurrency;
    }

    @Override
    public void setConcurrency(int n) {
        this.mConcurrency = n;
    }

    @Override
    public boolean getDefaultLockMode() {
        return this.mDefaultLockingMode;
    }

    @Override
    public void setDefaultLockMode(boolean bl) {
        this.mDefaultLockingMode = bl;
    }
}

