/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.LazyList;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.Persistent;
import com.intersys.classes.RelationshipObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.ObjectCopierUtil;
import com.jalapeno.runtime.ObjectFactory;
import com.jalapeno.runtime.PojoOperations;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectCopierToPojo
extends ObjectCopierUtil {
    private static final Object NOT_FOUND = new Object();
    private boolean mAllowProxy;

    public ObjectCopierToPojo(DetachedObjectsManager detachedObjectsManager, boolean bl, ClassLoader classLoader, Map map) {
        super(detachedObjectsManager, classLoader, map);
        this.mAllowProxy = bl;
    }

    public Object detach(CacheRootObject cacheRootObject) throws Exception {
        int n;
        Class<?> clazz;
        Object object = cacheRootObject.getProxy().getPojo();
        if (object != null) {
            return object;
        }
        object = ObjectCopierToPojo.getCacheClass(cacheRootObject);
        String string = object.getJavaPojoName();
        if (string == null) {
            throw new CacheException("POJO projection is not defned for class: " + object.getName());
        }
        try {
            clazz = Class.forName(string, true, this.mLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (!this.mLoader.equals(classLoader)) {
                clazz = Class.forName(string, true, classLoader);
            }
            throw classNotFoundException;
        }
        Object object2 = this.factory().newPOJO(clazz, (CacheClass)object, cacheRootObject, this.mAllowProxy);
        this.mTraversedObjects.put(cacheRootObject, object2);
        int n2 = n = this.mAllowProxy ? 0 : 100;
        if (!ObjectFactory.isProxy(object2)) {
            this.copyTo(cacheRootObject, object2, true, (CacheClass)object, n);
        }
        return object2;
    }

    public void copyTo(CacheRootObject cacheRootObject, Object object) throws Exception {
        if (ObjectFactory.isUnswizzledShadow(object)) {
            return;
        }
        int n = this.mAllowProxy ? 0 : 100;
        this.copyTo(cacheRootObject, object, n);
    }

    public void copyTo(CacheRootObject cacheRootObject, Object object, int n) throws Exception {
        this.mTraversedObjects.put(cacheRootObject, object);
        CacheClass cacheClass = ObjectCopierToPojo.getCacheClass(cacheRootObject);
        this.copyTo(cacheRootObject, object, false, cacheClass, n);
    }

    private void copyTo(CacheRootObject cacheRootObject, Object object, boolean bl, CacheClass cacheClass, int n) throws Exception {
        if (n != 1 && !this.pojoUpdateRequired(cacheRootObject, object)) {
            return;
        }
        boolean bl2 = n == -1;
        CacheField[] cacheFieldArray = cacheClass.getFields();
        JalapenoHelperInterface jalapenoHelperInterface = this.getHelper(cacheRootObject);
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            Object object2;
            Object object3;
            CacheField cacheField = cacheFieldArray[i];
            if (ObjectCopierToPojo.isFieldTransient(cacheField, true)) continue;
            Object object4 = cacheField.get(cacheRootObject);
            String string = cacheField.getJavaName();
            if (cacheField.isLiteral()) {
                if (object4 == null && cacheField.isVersionField()) continue;
                jalapenoHelperInterface.set(object, cacheField.getII(), object4);
                continue;
            }
            if (cacheField.isList()) {
                this.processListProperty(object, jalapenoHelperInterface, cacheField, string, object4, n);
                continue;
            }
            if (!bl2 && cacheField.isRelationship()) {
                this.processRelationship(object, jalapenoHelperInterface, cacheField, object4, n);
                continue;
            }
            if (cacheField.isArray() && (!bl2 || cacheField.isArrayOfDatatypes())) {
                object3 = (Map)jalapenoHelperInterface.get(object, cacheField.getII());
                if (object3 == null) {
                    object2 = cacheField.getJavaTypeName();
                    if (object2 == null || ((String)object2).startsWith("com.intersys")) {
                        object2 = Map.class.getName();
                    }
                    Class clazz = PojoOperations.classForName((String)object2, this.mLoader);
                    object3 = this.factory().newMap(clazz);
                    jalapenoHelperInterface.set(object, cacheField.getII(), object3);
                }
                object2 = (Map)object4;
                this.copyMap((Map)object2, (Map)object3, cacheField.isArrayOfDatatypes());
                continue;
            }
            if (!bl2 && cacheField.isStream()) {
                jalapenoHelperInterface.set(object, cacheField.getII(), object4);
                continue;
            }
            if (n < 0 || !(object4 instanceof CacheRootObject)) continue;
            object3 = (CacheRootObject)object4;
            object2 = this.findPojo((CacheRootObject)object3, bl, false);
            if (n == 1 && ObjectFactory.isProxy(object2)) {
                this.copyTo((CacheRootObject)object3, object2);
            }
            if (object2 == NOT_FOUND) {
                this.mergeInto(cacheRootObject, object, cacheField.getII(), (CacheRootObject)object3);
                continue;
            }
            jalapenoHelperInterface.set(object, cacheField.getII(), object2);
        }
        if (cacheRootObject instanceof Persistent) {
            this.setPojoId(cacheRootObject, object);
        }
        cacheRootObject.getProxy().clearReadState();
    }

    private static boolean allowLazyList(CacheField cacheField, List list, int n) throws CacheException {
        if (n > 0) {
            return false;
        }
        int n2 = cacheField.getFetchPolicy();
        if (n2 == 1) {
            return false;
        }
        if (list instanceof LazyList && !((LazyList)list).isLoaded()) {
            return true;
        }
        if (n2 == 2) {
            return true;
        }
        return list.size() > 100;
    }

    private void processRelationship(Object object, JalapenoHelperInterface jalapenoHelperInterface, CacheField cacheField, Object object2, int n) throws Exception {
        Object object3;
        Serializable serializable;
        List<Object> list;
        List list2;
        Object object4;
        if (object2 != null) {
            object4 = (RelationshipObject)object2;
            list2 = ((RelationshipObject)object4).asList();
        } else {
            list2 = Collections.EMPTY_LIST;
        }
        object4 = jalapenoHelperInterface.get(object, cacheField.getII());
        if (object4 == null) {
            list = null;
        } else if (object4 instanceof Collection) {
            list = (List<Object>)object4;
        } else if (object4.getClass().isArray()) {
            list = null;
        } else {
            throw new ClassCastException(object4.getClass().getName());
        }
        boolean bl = true;
        if (list == null) {
            bl = false;
            serializable = jalapenoHelperInterface.getJavaType(cacheField.getII());
            if (((Class)serializable).isArray()) {
                object3 = Array.newInstance(((Class)serializable).getComponentType(), list2.size());
                jalapenoHelperInterface.set(object, cacheField.getII(), object3);
                list = Arrays.asList((Object[])object3);
            } else {
                list = this.factory().newList((Class)serializable, ObjectCopierToPojo.allowLazyList(cacheField, list2, n));
                jalapenoHelperInterface.set(object, cacheField.getII(), list);
            }
        } else if (list.isEmpty()) {
            bl = false;
        }
        if (list instanceof LazyList && n < 1) {
            if (bl) {
                list.clear();
            }
            serializable = (LazyList)list;
            ((LazyList)serializable).setInitializer(list2);
            object3 = new PojoTransformer();
            ((LazyList)serializable).setTransformer((LazyList.Transformer)object3);
            if (list2 instanceof LazyList) {
                this.factory().injectDatasource((LazyList)list2);
            }
        } else {
            this.copyList(list2, list, cacheField.isListOfDatatypes());
        }
    }

    private void processListProperty(Object object, JalapenoHelperInterface jalapenoHelperInterface, CacheField cacheField, String string, Object object2, int n) throws Exception {
        Object object3;
        Object object4;
        List<Object> list;
        boolean bl;
        boolean bl2 = bl = n == -1;
        if (bl) {
            if (!cacheField.isListOfDatatypes()) {
                return;
            }
            n = 1;
        }
        List list2 = (List)object2;
        Object object5 = jalapenoHelperInterface.get(object, cacheField.getII());
        boolean bl3 = ObjectCopierToPojo.allowLazyList(cacheField, list2, n);
        if (object5 instanceof Collection) {
            list = (List<Object>)object5;
            if (!list.isEmpty()) {
                bl3 = false;
            }
        } else if (object5 == null) {
            object4 = cacheField.getJavaTypeName();
            if (object4 == null || ((String)object4).startsWith("com.intersys")) {
                object4 = List.class.getName();
            }
            if (((Class)(object3 = PojoOperations.classForName((String)object4, this.mLoader))).isArray()) {
                Class<?> clazz = ((Class)object3).getComponentType();
                if (clazz.isPrimitive()) {
                    ObjectCopierToPojo.setPrimitiveArray(jalapenoHelperInterface, object, cacheField.getII(), list2, clazz);
                    return;
                }
                Object[] objectArray = (Object[])Array.newInstance(clazz, list2.size());
                jalapenoHelperInterface.set(object, cacheField.getII(), objectArray);
                list = Arrays.asList(objectArray);
            } else if (List.class.isAssignableFrom((Class<?>)object3)) {
                list = this.factory().newList((Class)object3, bl3);
                jalapenoHelperInterface.set(object, cacheField.getII(), list);
            } else {
                list = (Collection)((Class)object3).newInstance();
                jalapenoHelperInterface.set(object, cacheField.getII(), list);
            }
        } else if (object5.getClass().isArray()) {
            list = PojoOperations.arrayToList(object5);
        } else {
            throw new IllegalArgumentException("Unsupported type for List property " + object.getClass().getName() + "." + string + ": " + object5.getClass().getName());
        }
        if (list instanceof LazyList && bl3) {
            object4 = (LazyList)list;
            ((LazyList)object4).setInitializer(list2);
            if (cacheField.isElementPersistent()) {
                object3 = new PojoTransformer();
                ((LazyList)object4).setTransformer((LazyList.Transformer)object3);
            }
            if (list2 instanceof LazyList) {
                this.factory().injectDatasource((LazyList)list2);
            }
        } else {
            this.copyList(list2, list, cacheField.isListOfDatatypes());
        }
    }

    private static void setPrimitiveArray(JalapenoHelperInterface jalapenoHelperInterface, Object object, int n, List list, Class clazz) throws Exception {
        int n2 = list.size();
        Object object2 = Array.newInstance(clazz, n2);
        for (int i = 0; i < n2; ++i) {
            Object object3 = list.get(i);
            if (!clazz.isInstance(object3)) {
                object3 = PojoOperations.tryConvertValue(clazz, object3, null);
            }
            Array.set(object2, i, object3);
        }
        jalapenoHelperInterface.set(object, n, object2);
    }

    private void copyList(List list, Collection collection, boolean bl) throws Exception {
        int n;
        if (list.size() != collection.size() || !(collection instanceof List)) {
            collection.clear();
            if (bl) {
                collection.addAll(list);
                return;
            }
            if (collection instanceof List) {
                for (n = 0; n < list.size(); ++n) {
                    collection.add(null);
                }
            }
        }
        n = 0;
        PojoTransformer pojoTransformer = new PojoTransformer();
        for (Object object : list) {
            object = pojoTransformer.transform(object);
            if (collection instanceof List) {
                ((List)collection).set(n, object);
            } else {
                collection.add(object);
            }
            ++n;
        }
    }

    private void copyMap(Map map, Map map2, boolean bl) throws Exception {
        map2.clear();
        if (bl) {
            map2.putAll(map);
        } else {
            for (Map.Entry entry : map.entrySet()) {
                Cloneable cloneable;
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v instanceof CacheRootObject) {
                    cloneable = this.findPojo((CacheRootObject)v, true, true);
                    map2.put(k, cloneable);
                    continue;
                }
                if (v instanceof List) {
                    cloneable = new ArrayList();
                    this.copyList((List)v, (Collection)((Object)cloneable), false);
                    map2.put(k, cloneable);
                    continue;
                }
                if (v instanceof Map) {
                    cloneable = new HashMap();
                    this.copyMap((Map)v, (Map)((Object)cloneable), false);
                    map2.put(k, cloneable);
                    continue;
                }
                map2.put(k, v);
            }
        }
    }

    public Object findPojo(CacheRootObject cacheRootObject, boolean bl, boolean bl2) throws Exception {
        if (cacheRootObject == null) {
            return null;
        }
        if (cacheRootObject.getProxy().isClosed()) {
            throw new Exception();
        }
        Object object = this.mTraversedObjects.get(cacheRootObject);
        if (object != null) {
            return object;
        }
        object = this.mManager.findPOJO(cacheRootObject, this.mAllowProxy);
        if (object != null) {
            if (bl2 && !this.mAllowProxy || !ObjectFactory.isProxy(object)) {
                this.copyTo(cacheRootObject, object);
            }
            return object;
        }
        if (bl) {
            object = this.detach(cacheRootObject);
            if (cacheRootObject instanceof Persistent) {
                this.mManager.register((Persistent)cacheRootObject, object);
            }
            return object;
        }
        return NOT_FOUND;
    }

    private void mergeInto(CacheRootObject cacheRootObject, Object object, int n, CacheRootObject cacheRootObject2) throws Exception {
        JalapenoHelperInterface jalapenoHelperInterface = this.getHelper(cacheRootObject);
        Object object2 = jalapenoHelperInterface.get(object, n);
        if (object2 == null || !this.same(cacheRootObject, object, cacheRootObject2)) {
            Object object3 = this.detach(cacheRootObject2);
            if (cacheRootObject2 instanceof Persistent) {
                this.mManager.register((Persistent)cacheRootObject2, object3);
            }
            jalapenoHelperInterface.set(object, n, object3);
        } else {
            this.copyTo(cacheRootObject2, object2);
        }
    }

    private boolean same(CacheRootObject cacheRootObject, Object object, CacheRootObject cacheRootObject2) throws Exception {
        if (object == null) {
            return cacheRootObject2 == null;
        }
        if (cacheRootObject2 == null) {
            return false;
        }
        if (!(cacheRootObject2 instanceof Persistent)) {
            return false;
        }
        Id id = ((Persistent)cacheRootObject2).getId();
        if (id == null) {
            return false;
        }
        JalapenoHelperInterface jalapenoHelperInterface = null;
        try {
            ClassLoader classLoader = ((SysDatabase)cacheRootObject.getDatabase()).getClassLoader();
            jalapenoHelperInterface = this.factory().getHelper(this.cacheClassFor(object), classLoader);
        }
        catch (Exception exception) {
            throw new CacheException(exception, "Failed to get Id of a POJO");
        }
        return id.equals(jalapenoHelperInterface);
    }

    private void setPojoId(CacheRootObject cacheRootObject, Object object) throws Exception {
        Persistent persistent = (Persistent)cacheRootObject;
        Id id = persistent.getId();
        String string = id == null ? null : id.toString();
        JalapenoHelperInterface jalapenoHelperInterface = this.getHelper(cacheRootObject);
        jalapenoHelperInterface.setPojoId(object, (Serializable)((Object)string));
    }

    private boolean pojoUpdateRequired(CacheRootObject cacheRootObject, Object object) {
        int n = cacheRootObject.getProxy().getState();
        if ((n & 0xF) != 0) {
            return true;
        }
        try {
            if (this.mManager.findPOJO(cacheRootObject, this.mAllowProxy) == object) {
                return false;
            }
        }
        catch (Exception exception) {
            return true;
        }
        return true;
    }

    private class PojoTransformer
    implements LazyList.Transformer {
        private Map mMasterTraversedObjects;

        public PojoTransformer() {
            this.mMasterTraversedObjects = new HashMap(ObjectCopierToPojo.this.mTraversedObjects);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object transform(Object object) throws Exception {
            HashMap hashMap = ObjectCopierToPojo.this.mTraversedObjects;
            synchronized (hashMap) {
                if (this.mMasterTraversedObjects != null) {
                    ObjectCopierToPojo.this.mTraversedObjects.putAll(this.mMasterTraversedObjects);
                    this.mMasterTraversedObjects = null;
                }
            }
            if (object instanceof CacheRootObject) {
                hashMap = ObjectCopierToPojo.this.findPojo((CacheRootObject)object, true, true);
                return hashMap;
            }
            if (object instanceof List) {
                hashMap = ObjectCopierToPojo.this.factory().newList(List.class, false);
                ObjectCopierToPojo.this.copyList((List)object, hashMap, false);
                return hashMap;
            }
            if (object instanceof Map) {
                hashMap = new HashMap();
                ObjectCopierToPojo.this.copyMap((Map)object, hashMap, false);
                return hashMap;
            }
            return object;
        }
    }
}

