/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.cache.CacheClassBuilder;
import com.intersys.cache.ClassGenerationConstants;
import com.intersys.classes.Compiler.LG.JavaBlock;
import com.intersys.classes.Compiler.LG.JavaBlockNameSet;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheRunTimeException;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.intersys.objects.reflect.TypeModifiers;
import com.jalapeno.tools.objects.DefaultMappingProvider;
import com.jalapeno.tools.objects.JavaCacheClassMapper;
import com.jalapeno.tools.objects.NamedQuery;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CacheClassGenerator
extends JavaCacheClassMapper
implements TypeModifiers,
ClassGenerationConstants {
    private Set mPrimaryKeyProperties;
    private CacheClassBuilder.InternalAPI mBuilder;
    private int mMaxStringLength = 4096;
    private int mMaxStringLengthInKey = 128;
    protected boolean mDeleteOldClasses = true;

    public CacheClassGenerator(CacheClassBuilder cacheClassBuilder) {
        this.mBuilder = (CacheClassBuilder.InternalAPI)cacheClassBuilder;
        this.mPrimaryKeyProperties = new HashSet();
    }

    public int getMaxStringLength() {
        return this.mMaxStringLength;
    }

    public void setMaxStringLength(int n) {
        this.mMaxStringLength = n;
    }

    public int getMaxStringLengthInKey() {
        return this.mMaxStringLengthInKey;
    }

    public void setMaxStringLengthInKey(int n) {
        this.mMaxStringLengthInKey = n;
    }

    @Override
    protected void enableVersionChecking(PropertyDescriptor propertyDescriptor, Set set, Set set2) throws Exception {
        ObjectServerInfo objectServerInfo = this.mBuilder.getServerVersion();
        if (objectServerInfo.getMajorObjectVersion() < 6 && objectServerInfo.getMinorObjectVersion() < 2) {
            this.enableVersionChecking51J(propertyDescriptor.getName());
            return;
        }
        this.mapField(propertyDescriptor, set, set2);
        String string = this.mMappingTool.cacheFieldNameFor(propertyDescriptor, set);
        this.mBuilder.createParameter(null, "VERSIONPROPERTY", string);
    }

    private void enableVersionChecking51J(String string) throws Exception {
        if (!string.equals("_Version")) {
            throw new CacheException("This implementation only supports _Version for version checking.");
        }
        this.mBuilder.createParameter(null, "VERSIONCHECKING", 1);
    }

    @Override
    protected void handleIdField(Class clazz, String string, int n) throws Exception {
        switch (n) {
            case 0: {
                this.setupIdPlaceHolder(string);
                break;
            }
            case 1: {
                this.createIDKey(string + "Key", string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ID type: " + n + " for class " + clazz.getName());
            }
        }
    }

    private void setupIdPlaceHolder(String string) throws Exception {
        JavaBlock javaBlock = (JavaBlock)this.mBuilder.getClientProjectionSettings(null);
        javaBlock.setIdPlaceholder(string);
    }

    @Override
    protected void generateField(Object object, Set set, Set set2, Class clazz, String string, String string2) throws Exception {
        String string3 = DefaultMappingProvider.javaFieldNameFor(object);
        int n = this.mMappingTool.getPropertyKind(object);
        String string4 = this.mMappingTool.cacheFieldNameFor(object, set);
        String string5 = this.mMappingTool.sqlColumnNameFor(object);
        CacheClassGenerator.processExceptions(object, set2);
        Map map = this.mMappingTool.getPropertyParameters(object);
        if (this.mMappingTool.isFetchTypeEager(object)) {
            map.put("ACCESSPOLICY", "eager");
        }
        boolean bl = this.mMappingTool.isPropertyRequired(object);
        this.generateField(string4, string3, string5, n, object, string, string2, clazz, map, bl);
    }

    private void generateField(String string, String string2, String string3, int n, Object object, String string4, String string5, Class clazz, Map map, boolean bl) throws Exception {
        boolean bl2 = clazz != null && !clazz.isArray();
        boolean bl3 = true;
        switch (n) {
            case 0: {
                Object object2 = this.mMappingTool.relationshipFor(object);
                if (object2 == null) {
                    this.writeSimpleAttribute(string, string4, string5, map);
                    break;
                }
                this.writeRelationship(string, string5, (CacheRelationshipInfo)object2);
                break;
            }
            case 8: 
            case 264: 
            case 520: {
                this.writeListAttribute(string, string4, bl2, clazz);
                break;
            }
            case 1: 
            case 257: 
            case 513: {
                bl2 = false;
                this.writeArrayAttribute(string, string4, bl2, clazz);
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                Object object2 = this.mMappingTool.relationshipFor(object);
                if (object2 == null) {
                    this.writeSimpleAttribute(string, string4, string5, map);
                    break;
                }
                this.writeRelationship(string, string5, (CacheRelationshipInfo)object2);
                break;
            }
            case 96: {
                n = this.isText(string5, clazz) ? 64 : 32;
            }
            case 32: 
            case 64: {
                this.writeStreamAttribute(string, n, string5, string2);
                bl3 = false;
                break;
            }
            default: {
                throw new CacheException("Property " + string2 + " has unknown kind: " + n);
            }
        }
        if (bl3 && string2 != null && !string.equals(string2)) {
            this.define(2130, string2);
        }
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof String && ((String)v).length() == 0) {
                v = null;
            }
            this.createPropertyParameter((String)entry.getKey(), v);
        }
        if (string3 != null) {
            this.define(2135, string3);
        }
        if (bl) {
            this.define(2230);
        }
        this.define(2900);
    }

    private boolean isText(String string, Class clazz) {
        if (String.class.getName().equals(string)) {
            return true;
        }
        if (StringBuffer.class.getName().equals(string)) {
            return true;
        }
        if (CharSequence.class.getName().equals(string)) {
            return true;
        }
        return clazz != null && CharSequence.class.isAssignableFrom(clazz);
    }

    private static void processExceptions(Object object, Set set) {
        if (object instanceof Method) {
            CacheClassGenerator.getExceptionToThrow((Method)object, set);
        } else if (set.isEmpty()) {
            set.add(CacheException.class);
        }
    }

    private void writeSimpleAttribute(String string, String string2, String string3, Map map) throws Exception {
        this.define(2010, string);
        this.define(2120, string2);
        boolean bl = map.containsKey("MAXLEN");
        String string4 = String.valueOf(this.mMaxStringLength);
        if (this.mPrimaryKeyProperties.contains(string)) {
            string4 = String.valueOf(this.mMaxStringLengthInKey);
        }
        if (!bl && string2.endsWith("String") && !string2.endsWith("CacheString")) {
            this.define(2220, string4);
        }
        if (string3 != null) {
            this.define(2140, string3);
        }
    }

    private void writeStreamAttribute(String string, int n, String string2, String string3) throws Exception {
        String string4;
        this.define(2010, string);
        switch (n) {
            case 32: {
                string4 = "%Library.GlobalBinaryStream";
                break;
            }
            case 64: {
                string4 = "%Library.GlobalCharacterStream";
                break;
            }
            default: {
                throw new CacheException("Unknown stream type: " + n);
            }
        }
        this.define(2120, string4);
        if (string2 != null && !string2.startsWith("java.io.")) {
            this.define(2140, string2);
            this.define(2130, string3);
        }
    }

    private void writeRelationship(String string, String string2, CacheRelationshipInfo cacheRelationshipInfo) throws Exception {
        this.define(2050, string);
        this.define(2120, this.mMappingTool.cacheClassName(cacheRelationshipInfo));
        if (string2 != null) {
            this.define(2140, string2);
        }
        boolean bl = false;
        String string3 = null;
        String string4 = cacheRelationshipInfo.parentChild ? (cacheRelationshipInfo.pointsToManyOrChildren ? "children" : "parent") : (cacheRelationshipInfo.pointsToManyOrChildren ? "many" : "one");
        this.mBuilder.defineRelationship(null, string4, cacheRelationshipInfo.inverseField);
        if (bl) {
            this.mBuilder.createForeignKey(null, string + "FKey", string, this.mMappingTool.cacheClassName(cacheRelationshipInfo), string3);
        }
    }

    private void writeArrayAttribute(String string, String string2, boolean bl, Class clazz) throws Exception {
        this.define(2020, string);
        this.define(2120, string2);
        this.define(3100, bl);
        if (clazz != null && !Map.class.equals((Object)clazz)) {
            this.define(2140, clazz.getName());
        }
    }

    private void writeListAttribute(String string, String string2, boolean bl, Class clazz) throws Exception {
        this.define(2030, string);
        this.define(2120, string2);
        this.define(3100, bl);
        if (clazz != null && !List.class.equals((Object)clazz)) {
            this.define(2140, clazz.getName());
        }
    }

    @Override
    protected void mapClass(Set set, Class clazz) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        boolean bl;
        String string;
        if (this.mMappingTool.isClassTransient(clazz)) {
            return;
        }
        String string2 = this.mapClassName(clazz);
        String string3 = DefaultMappingProvider.javaPackageName(clazz);
        String string4 = this.mMappingTool.cacheMappedClassNameFor(string2);
        this.createEmptyClass(string4);
        if (!string4.equals(string2)) {
            this.define(11, string2);
        }
        if (this.generateEnum(clazz, string = this.mMappingTool.getExtendedClass(clazz))) {
            return;
        }
        boolean bl2 = this.mMappingTool.isSerial(clazz);
        boolean bl3 = bl = !bl2;
        if (string == null) {
            object6 = clazz.getSuperclass();
            if (object6 != null && !object6.equals(Object.class)) {
                string = this.mMappingTool.cacheClassNameFor((Class)object6);
                this.mMappingTool.registerDependency((Class)object6);
            } else {
                string = bl ? "%Library.Persistent" : (bl2 ? "%Library.SerialObject" : "%Library.RegisteredObject");
            }
        }
        if (bl) {
            this.define(21);
            if (Modifier.isAbstract(clazz.getModifiers())) {
                this.define(31);
            }
            object6 = this.mMappingTool.sqlTableNameFor(clazz);
            this.define(15, (String)object6);
        } else if (bl2) {
            this.define(22);
        }
        object6 = this.mMappingTool.getImplementedClasses(clazz);
        boolean bl4 = true;
        boolean bl5 = true;
        for (int i = 0; i < ((String[])object6).length; ++i) {
            if ("%Library.Populate".equals(object6[i])) {
                bl4 = false;
            } else if ("%XML.Adaptor".equals(object6[i])) {
                bl5 = false;
            }
            string = string + "," + object6[i];
        }
        if (bl4 && this.mMappingTool.isPopulatable(clazz)) {
            string = string + ",%Library.Populate";
        }
        if (bl5 && this.mMappingTool.isXMLSerializable(clazz)) {
            string = string + ",%XML.Adaptor";
        }
        this.define(51, string);
        Map map = this.mMappingTool.getClassParameters(clazz);
        for (Map.Entry cacheIndexInfoArray2 : map.entrySet()) {
            object5 = (String)cacheIndexInfoArray2.getKey();
            if (!(cacheIndexInfoArray2.getValue() instanceof String)) continue;
            String i = (String)cacheIndexInfoArray2.getValue();
            if (i.length() == 0) {
                i = null;
            }
            this.mBuilder.createClassParameter(null, (String)object5, i, "STRING");
        }
        if (string3 != null) {
            this.define(101, string3);
        }
        HashSet hashSet = new HashSet();
        CacheIndexInfo[] cacheIndexInfoArray = this.mMappingTool.allIndicesFor(this.mInitialClass);
        object5 = null;
        this.mPrimaryKeyProperties.clear();
        if (cacheIndexInfoArray != null) {
            for (int i = 0; i < cacheIndexInfoArray.length; ++i) {
                object4 = cacheIndexInfoArray[i];
                if (!object4.isPrimaryKey() && !object4.isUnique() && !object4.isIdKey()) continue;
                String i2 = object4.getProperties();
                if (i2 == null) {
                    if (object5 == null) {
                        object5 = this.mapColumnsToProperties(set);
                    }
                    object3 = object4.getColumnArray();
                    for (int j = 0; j < ((Object)object3).length; ++j) {
                        object2 = object3[j];
                        object = (String)object5.get(object2);
                        if (object == null) continue;
                        this.mPrimaryKeyProperties.add(object);
                    }
                    continue;
                }
                object3 = new StringTokenizer(i2, " \t\n\r\f,");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    this.mPrimaryKeyProperties.add(((StringTokenizer)object3).nextToken());
                }
            }
        }
        boolean bl6 = this.mapAllFields(set, hashSet, clazz);
        this.mapUnmappedFields(clazz);
        if (bl6 && !hashSet.contains(CacheException.class)) {
            this.define(120, hashSet);
        }
        if (cacheIndexInfoArray != null) {
            object4 = new HashMap(cacheIndexInfoArray.length);
            for (int object7 = 0; object7 < cacheIndexInfoArray.length; ++object7) {
                object3 = cacheIndexInfoArray[object7];
                String clazz2 = object3.getProperties();
                object2 = object3.getName();
                if (object4.containsKey(object2)) {
                    object = (CacheIndexInfo)object4.get(object2);
                    String string5 = "Duplicate index defintion for index: " + (String)object2 + ".";
                    if (object != null) {
                        string5 = string5 + " One is defined for properties: " + object.getProperties() + "; another is for properties: " + clazz2;
                    }
                    throw new CacheException(string5);
                }
                object4.put(object2, object3);
                if (clazz2 == null || clazz2.length() == 0) {
                    object = object3.getColumnArray();
                    if (object == null) continue;
                    if (object5 == null) {
                        object5 = this.mapColumnsToProperties(set);
                    }
                    clazz2 = CacheClassGenerator.composeProps(object, (Map)object5);
                } else {
                    clazz2 = this.mapEmbeddedPropsInKey(clazz2, set);
                }
                if (object3.isIdKey()) {
                    this.createIDKey(object3.getObjectName(), clazz2);
                    continue;
                }
                if (object3.isPrimaryKey()) {
                    this.createPKIndex((CacheIndexInfo)object3, clazz2);
                    continue;
                }
                this.mBuilder.createIndex(null, object3.getObjectName(), object3.getSQLName(), clazz2, object3.isPrimaryKey(), object3.isUnique(), object3.getType());
            }
        }
        this.define(999);
        object4 = this.mMappingTool.getNamedQueries(clazz);
        Object object7 = object4.iterator();
        while (object7.hasNext()) {
            object3 = (NamedQuery)object7.next();
            Class n = ((NamedQuery)object3).getResultClass();
            object2 = n != null ? this.mMappingTool.cacheClassNameFor(n) : null;
            this.mBuilder.createNamedQuery(((NamedQuery)object3).getName(), (String)object2, ((NamedQuery)object3).getQueryText());
        }
        if (bl && (object7 = this.mMappingTool.sqlSchemaNameFor(clazz)) != null) {
            int n = string4.lastIndexOf(46);
            object3 = n > 0 ? string4.substring(0, n) : "User";
            this.mBuilder.setSchemaName((String)object3, (String)object7);
        }
    }

    private boolean generateEnum(Class clazz, String string) throws Exception {
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("com.jalapeno.tools.objects.EnumUtilities", true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        Method method = clazz2.getMethod("generateEnum", Class.class, CacheClassBuilder.InternalAPI.class, String.class);
        Object object = method.invoke(null, clazz, this.mBuilder, string);
        return (Boolean)object;
    }

    private static String composeProps(String[] stringArray, Map map) throws CacheException {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = (String)map.get(string2);
            if (string3 == null) {
                throw new CacheException("Invalid column name: " + stringArray[i] + " in unique constraint.");
            }
            string = i == 0 ? string3 : string + "," + string3;
        }
        return string;
    }

    private Map mapColumnsToProperties(Set set) {
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        for (Object e : set) {
            String string = this.mMappingTool.cacheFieldNameFor(e, null);
            String string2 = this.mMappingTool.sqlColumnNameFor(e);
            if (string2 == null) {
                string2 = string;
            }
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    private String mapEmbeddedPropsInKey(String string, Set set) {
        Object object;
        CharSequence charSequence;
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        for (PropertyDescriptor propertyDescriptor : set) {
            charSequence = this.mMappingTool.cacheFieldNameFor(propertyDescriptor, null);
            object = propertyDescriptor.getPropertyType();
            hashMap.put((String)charSequence, (Class)object);
        }
        Object object2 = new StringTokenizer(string, " \t\n\r\f,");
        boolean bl = false;
        while (((StringTokenizer)object2).hasMoreTokens()) {
            charSequence = ((StringTokenizer)object2).nextToken();
            object = (Class)hashMap.get(charSequence);
            if (object == null || !this.mMappingTool.isSerial((Class)object)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        charSequence = new StringBuffer();
        object2 = new StringTokenizer(string, " \t\n\r\f,");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            Class clazz = (Class)hashMap.get(object);
            if (clazz == null || !this.mMappingTool.isSerial(clazz)) {
                ((StringBuffer)charSequence).append((String)object);
                if (!((StringTokenizer)object2).hasMoreTokens()) continue;
                ((StringBuffer)charSequence).append(',');
                continue;
            }
            Set set2 = this.mMappingTool.getFields(clazz, null);
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)iterator.next();
                String string2 = this.mMappingTool.cacheFieldNameFor(propertyDescriptor, null);
                ((StringBuffer)charSequence).append((String)object).append('.').append(string2);
                if (!iterator.hasNext() && !((StringTokenizer)object2).hasMoreTokens()) continue;
                ((StringBuffer)charSequence).append(',');
            }
        }
        return ((StringBuffer)charSequence).toString();
    }

    @Override
    protected void mapUnmappedFields(Class clazz) throws Exception {
        Set set = this.mMappingTool.listUnmappedFields(clazz);
        for (Object e : set) {
            String string = this.mMappingTool.cacheFieldNameFor(e);
            String string2 = this.mMappingTool.sqlColumnNameFor(e);
            int n = this.mMappingTool.getPropertyKind(e);
            String string3 = this.mMappingTool.cacheFieldTypeFor(e);
            Map map = this.mMappingTool.getPropertyParameters(e);
            boolean bl = this.mMappingTool.isPropertyRequired(e);
            this.generateField(string, null, string2, n, e, string3, null, null, map, bl);
        }
    }

    protected void createEmptyClass(String string) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        if (this.mDeleteOldClasses) {
            this.mBuilder.createEmptyClass(string);
        } else {
            this.mBuilder.loadExistingClass(string);
        }
    }

    protected void define(int n, Set set) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.define(n, set);
    }

    protected void define(int n, String string) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.define(n, string);
    }

    protected void define(int n, boolean bl) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        if (bl) {
            this.mBuilder.define(n);
        }
    }

    protected void define(int n) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.define(n);
    }

    protected void createPropertyParameter(String string, Object object) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.addPropertyParameter(null, string, object);
    }

    private static void getExceptionToThrow(Method method, Set set) {
        Class clazz;
        Class<CacheRunTimeException> clazz2 = CacheRunTimeException.class;
        HashSet<Class<CacheRunTimeException>> hashSet = new HashSet<Class<CacheRunTimeException>>();
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            clazz = classArray[i];
            if (clazz.isAssignableFrom(CacheException.class)) {
                hashSet.add(CacheException.class);
                hashSet.add(clazz);
                continue;
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int j = 0; j < constructorArray.length; ++j) {
                Class<?>[] object = constructorArray[j].getParameterTypes();
                if (object.length != 1 || !object[0].isAssignableFrom(CacheException.class)) continue;
                hashSet.add(clazz);
            }
        }
        if (hashSet.isEmpty()) {
            hashSet.add(clazz2);
        }
        if (set.isEmpty()) {
            set.addAll(hashSet);
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            clazz = (Class)iterator.next();
            if (clazz.equals(clazz2)) continue;
            boolean bl = false;
            for (Class clazz3 : hashSet) {
                if (!clazz3.isAssignableFrom(clazz)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            iterator.remove();
        }
        if (set.isEmpty()) {
            set.add(clazz2);
        }
    }

    public void deleteOldClasses(boolean bl) {
        this.mDeleteOldClasses = bl;
    }

    public void createPKIndex(CacheIndexInfo cacheIndexInfo, String string) throws Exception {
        if (string == null) {
            string = cacheIndexInfo.getProperties();
        }
        if (string != null && string.indexOf(44) < 0 && this.mInferredId != null) {
            return;
        }
        this.mBuilder.createIndex(null, cacheIndexInfo.getObjectName(), cacheIndexInfo.getSQLName(), string, true, true, cacheIndexInfo.getType());
    }

    public void createIDKey(String string, String string2) throws Exception {
        this.mBuilder.createIDKey(null, string, string, string2);
    }

    protected void setupJavaBlock(String string, Class clazz) throws Exception {
        String string2;
        JavaBlock javaBlock = (JavaBlock)this.mBuilder.getClientProjectionSettings(null);
        javaBlock.setExtends(string);
        String string3 = clazz.getName();
        int n = string3.lastIndexOf(46);
        String string4 = n > 0 ? string3.substring(0, n) : "";
        String string5 = n > 0 ? string3.substring(n + 1) : string3;
        JavaBlockNameSet javaBlockNameSet = javaBlock.getPackage();
        JavaBlockNameSet javaBlockNameSet2 = javaBlock.getJavaShortName();
        if (clazz.isInterface()) {
            javaBlock.setImplements(string3);
            javaBlockNameSet.setInterface(string4);
            javaBlockNameSet2.setInterface(string5);
        } else {
            javaBlockNameSet.setPojo(string4);
            javaBlockNameSet2.setPojo(string5);
        }
        String string6 = this.mMappingTool.getJavaProjectionPackage(clazz);
        if (string6 != null) {
            javaBlockNameSet.setImplementation(string6);
        }
        if ((string2 = this.mMappingTool.getJavaProjectionClassName(clazz)) != null) {
            javaBlockNameSet2.setImplementation(string2);
        }
        javaBlock.setResolveNameCollisions(false);
        int n2 = this.mMappingTool.getAccessType(clazz);
        if (n2 == 12001) {
            javaBlock.setEagerFetchRequired(true);
        }
    }

    public void save() throws Exception {
        this.mBuilder.saveClass(null);
    }

    @Override
    public void close() {
        this.mBuilder.close();
        super.close();
    }
}

