/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.jalapeno.tools.objects.ClassMetadata;
import com.jalapeno.tools.objects.HibernateHandler;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.NamedQuery;
import com.jalapeno.tools.objects.PropertyMetadata;
import com.jalapeno.tools.objects.ProviderTest;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HibernateProvider
implements Java2DBMapping {
    private HashMap<Class, ClassMetadata> classMetadata;
    private Java2DBMapping nameHelper;

    public HibernateProvider(String string) throws Throwable {
        HibernateHandler hibernateHandler = new HibernateHandler();
        this.classMetadata = hibernateHandler.parse(string);
    }

    public HibernateProvider() throws Exception {
    }

    @Override
    public String cacheClassNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getClassName();
    }

    @Override
    public String sqlTableNameFor(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getSQLTableName();
    }

    @Override
    public String primaryKeyNameFor(Class clazz) {
        return null;
    }

    @Override
    public CacheIndexInfo[] allIndicesFor(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getIndices();
    }

    @Override
    public int getAccessLevel(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessLevel();
    }

    @Override
    public int getAccessType(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getAccessType();
    }

    @Override
    public String getJavaProjectionPackage(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionPackageName();
    }

    @Override
    public String getJavaProjectionClassName(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getJavaProjectionClassName();
    }

    @Override
    public String cacheFieldNameFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getName();
    }

    @Override
    public String cacheFieldTypeFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getType();
    }

    @Override
    public int getPropertyKind(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return -1;
        }
        return propertyMetadata.getKind();
    }

    @Override
    public boolean isFetchTypeEager(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isFetchTypeEager();
    }

    @Override
    public CacheRelationshipInfo relationshipFor(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getRelationshipMetadata();
    }

    @Override
    public boolean isSerial(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.getIsSerial();
    }

    @Override
    public String getVersionID(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getVersionID();
    }

    @Override
    public boolean isClassTransient(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isTransient();
    }

    @Override
    public boolean isPropertyRequired(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isRequired();
    }

    @Override
    public boolean isMemberTransient(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return false;
        }
        return propertyMetadata.isTransient();
    }

    @Override
    public Map getPropertyParameters(Object object) {
        PropertyMetadata propertyMetadata = this.getPropertyMetadata(object);
        if (propertyMetadata == null) {
            return null;
        }
        return propertyMetadata.getPropertyParameters();
    }

    @Override
    public String getDatabaseID(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getDatabaseID();
    }

    @Override
    public int getDatabaseIDType(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return -1;
        }
        return classMetadata.getDatabaseIDType();
    }

    @Override
    public void close() {
        if (this.classMetadata != null) {
            this.classMetadata.clear();
        }
    }

    @Override
    public void setHelperMapping(Java2DBMapping java2DBMapping) {
        this.nameHelper = java2DBMapping;
    }

    @Override
    public boolean isPopulatable(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return false;
        }
        return classMetadata.isPopulatable();
    }

    @Override
    public boolean isXMLSerializable(Class clazz) {
        return false;
    }

    @Override
    public Map getClassParameters(Class clazz) {
        return null;
    }

    @Override
    public String getExtendedClass(Class clazz) {
        return null;
    }

    @Override
    public String[] getImplementedClasses(Class clazz) {
        return null;
    }

    private boolean isAccessor(Method method) {
        String string = method.getName();
        if (!string.startsWith("set") && !string.startsWith("get")) {
            return false;
        }
        return !(string.startsWith("get") ? method.getParameterTypes().length != 0 || method.getReturnType() == null : method.getParameterTypes().length != 1 || method.getReturnType() != null);
    }

    private PropertyMetadata getPropertyMetadata(Object object) {
        Member member = (Member)object;
        ((AccessibleObject)((Object)member)).setAccessible(true);
        ClassMetadata classMetadata = this.classMetadata.get(member.getDeclaringClass());
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getPropertyMetadata(member);
    }

    public boolean isPropertyAnnotated(Member member) {
        return this.getPropertyMetadata(member) != null;
    }

    public Class[] getPersistedClasses() {
        Set<Class> set = this.classMetadata.keySet();
        return set.toArray(new Class[set.size()]);
    }

    public static void main(String[] stringArray) throws Throwable {
        HibernateProvider hibernateProvider = new HibernateProvider(stringArray[0]);
        Class[] classArray = hibernateProvider.getPersistedClasses();
        for (int i = 0; i < classArray.length; ++i) {
            ProviderTest.test(hibernateProvider, classArray[i]);
        }
    }

    private ClassMetadata getClassMetadata(Class clazz) {
        HashMap<Class, ClassMetadata> hashMap;
        ClassMetadata classMetadata = null;
        if (this.classMetadata != null && this.classMetadata.containsKey(clazz)) {
            classMetadata = this.classMetadata.get(clazz);
            return classMetadata;
        }
        HibernateHandler hibernateHandler = new HibernateHandler(clazz, this.nameHelper);
        InputStream inputStream = this.lookupFile(clazz);
        if (inputStream == null) {
            if (this.classMetadata == null) {
                this.classMetadata = new HashMap();
            }
            this.classMetadata.put(clazz, null);
            return null;
        }
        try {
            hashMap = hibernateHandler.parse(inputStream);
            inputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IllegalArgumentException("Failed to parse metadata for class: " + clazz.getName() + ". Cause: " + throwable.getMessage(), throwable);
        }
        classMetadata = hashMap.get(clazz);
        if (classMetadata == null) {
            throw new IllegalArgumentException("No metadata for class " + clazz.getName() + " was not found in corresponding file.");
        }
        if (this.classMetadata == null) {
            this.classMetadata = hashMap;
        } else {
            this.classMetadata.putAll(hashMap);
        }
        return classMetadata;
    }

    private InputStream lookupFile(Class clazz) {
        Class clazz2;
        String string;
        InputStream inputStream;
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        if ((inputStream = clazz.getResourceAsStream(string = string2 + ".hbm.xml")) == null && (clazz2 = clazz.getSuperclass()) != null) {
            inputStream = this.lookupFile(clazz2);
        }
        return inputStream;
    }

    @Override
    public String sqlColumnNameFor(Object object) {
        return null;
    }

    @Override
    public String packageNameFor(Class clazz) {
        return null;
    }

    @Override
    public String sqlSchemaNameFor(Class clazz) {
        return null;
    }

    @Override
    public List<NamedQuery> getNamedQueries(Class clazz) {
        ClassMetadata classMetadata = this.getClassMetadata(clazz);
        if (classMetadata == null) {
            return null;
        }
        return classMetadata.getNamedQueries();
    }
}

