/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects;

import com.intersys.cache.ClassAnalizer;
import com.jalapeno.runtime.PojoOperations;
import com.jalapeno.tools.objects.ClassMetadata;
import com.jalapeno.tools.objects.GenericsProcessor;
import com.jalapeno.tools.objects.Java2DBMapping;
import com.jalapeno.tools.objects.PropertyMetadata;
import com.jalapeno.tools.objects.RelationshipMetadata;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

public class JPAAnnotationProcessor {
    static void processEntityAndTableAnnotations(Class<?> clazz, ClassMetadata classMetadata) {
        Table table;
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity != null) {
            classMetadata.setClassName(entity.name());
        }
        if ((table = clazz.getAnnotation(Table.class)) != null) {
            classMetadata.setSQLTableName(table.name());
            classMetadata.setSQLSchemaName(table.schema());
            UniqueConstraint[] uniqueConstraintArray = table.uniqueConstraints();
            if (uniqueConstraintArray != null) {
                for (int i = 0; i < uniqueConstraintArray.length; ++i) {
                    String[] stringArray = uniqueConstraintArray[i].columnNames();
                    classMetadata.addUniqueConstraint(stringArray);
                }
            }
        }
    }

    static boolean processLobAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Lob lob = null;
        if (member instanceof Field) {
            lob = ((Field)member).getAnnotation(Lob.class);
        } else if (member instanceof Method) {
            lob = ((Method)member).getAnnotation(Lob.class);
        }
        if (lob == null) {
            return false;
        }
        propertyMetadata.setKind(96);
        return true;
    }

    static boolean processBasicAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Basic basic = null;
        if (member instanceof Field) {
            basic = ((Field)member).getAnnotation(Basic.class);
        } else if (member instanceof Method) {
            basic = ((Method)member).getAnnotation(Basic.class);
        }
        if (basic == null) {
            return false;
        }
        if (basic.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        if (!basic.optional()) {
            propertyMetadata.setIsRequired();
        }
        return true;
    }

    static boolean processTemporalAnnotation(Member member, PropertyMetadata propertyMetadata) {
        Temporal temporal = null;
        if (member instanceof Field) {
            Class<?> clazz = ((Field)member).getType();
            if (clazz != Date.class && clazz != Calendar.class) {
                return false;
            }
            temporal = ((Field)member).getAnnotation(Temporal.class);
        } else if (member instanceof Method) {
            Class<?> clazz = ((Method)member).getReturnType();
            if (clazz != Date.class && clazz != Calendar.class) {
                return false;
            }
            temporal = ((Method)member).getAnnotation(Temporal.class);
        }
        if (temporal == null) {
            return false;
        }
        if (temporal.value() == TemporalType.DATE) {
            propertyMetadata.setType("%Date");
        } else if (temporal.value() == TemporalType.TIME) {
            propertyMetadata.setType("%Time");
        } else if (temporal.value() == TemporalType.TIMESTAMP) {
            propertyMetadata.setType("%TimeStamp");
        }
        return true;
    }

    static boolean processColumnAnnotation(Member member, ClassMetadata classMetadata, PropertyMetadata propertyMetadata) {
        Column column = null;
        if (member instanceof Field) {
            column = ((Field)member).getAnnotation(Column.class);
        } else if (member instanceof Method) {
            column = ((Method)member).getAnnotation(Column.class);
        }
        if (column == null) {
            return false;
        }
        String string = column.name();
        if (string == null) {
            string = ClassAnalizer.methodName2PropertyName(member.getName());
        }
        propertyMetadata.setSQLColumnName(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (column.scale() != 0) {
            hashMap.put("SCALE", String.valueOf(column.scale()));
        }
        if (column.length() != 255) {
            hashMap.put("MAXLEN", String.valueOf(column.length()));
        }
        propertyMetadata.setPropertyParameters(hashMap);
        if (!column.nullable()) {
            propertyMetadata.setIsRequired();
        }
        if (column.unique()) {
            String[] stringArray = new String[]{string};
            classMetadata.addUniqueConstraint(stringArray);
        }
        return true;
    }

    static String processIdAnnotation(Member member, ClassMetadata classMetadata) {
        Id id = null;
        String string = member.getName();
        if (member instanceof Field) {
            id = ((Field)member).getAnnotation(Id.class);
        } else if (member instanceof Method) {
            id = ((Method)member).getAnnotation(Id.class);
            string = ClassAnalizer.methodName2PropertyName(member.getName());
        }
        if (id == null) {
            return null;
        }
        if (member instanceof Field && ((Field)member).getAnnotation(GeneratedValue.class) != null || member instanceof Method && ((Method)member).getAnnotation(GeneratedValue.class) != null) {
            return null;
        }
        return string;
    }

    static String processEmbeddedIdAnnotation(Member member, ClassMetadata classMetadata) {
        EmbeddedId embeddedId = null;
        String string = member.getName();
        if (member instanceof Field) {
            embeddedId = ((Field)member).getAnnotation(EmbeddedId.class);
        } else if (member instanceof Method) {
            embeddedId = ((Method)member).getAnnotation(EmbeddedId.class);
            string = ClassAnalizer.methodName2PropertyName(member.getName());
        }
        if (embeddedId != null) {
            return string;
        }
        return null;
    }

    static boolean processGeneratedValueAnnotation(Member member, ClassMetadata classMetadata) {
        GeneratedValue generatedValue = null;
        if (member instanceof Field) {
            generatedValue = ((Field)member).getAnnotation(GeneratedValue.class);
        } else if (member instanceof Method) {
            generatedValue = ((Method)member).getAnnotation(GeneratedValue.class);
        }
        if (generatedValue == null) {
            return false;
        }
        if (generatedValue.strategy() == GenerationType.IDENTITY) {
            classMetadata.setDatabaseIDType(1);
        } else {
            classMetadata.setDatabaseIDType(0);
        }
        String string = member.getName();
        if (member instanceof Method) {
            string = ClassAnalizer.methodName2PropertyName(string);
        }
        classMetadata.setDatabaseID(string);
        return true;
    }

    static void processVersionAnnotation(Member member, ClassMetadata classMetadata) {
        String string;
        Version version = null;
        if (member instanceof Field) {
            version = ((Field)member).getAnnotation(Version.class);
            if (version != null) {
                classMetadata.setVersionID(member.getName());
            }
        } else if (member instanceof Method && (version = ((Method)member).getAnnotation(Version.class)) != null && (string = ClassAnalizer.methodName2PropertyName(member.getName())) != null) {
            classMetadata.setVersionID(string);
        }
    }

    static boolean processTransientAnnotation(Object object, Object object2) {
        if (object instanceof Field) {
            if (((Field)object).getAnnotation(Transient.class) != null) {
                ((PropertyMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        if (object instanceof Method) {
            if (((Method)object).getAnnotation(Transient.class) != null) {
                ((PropertyMetadata)object2).setIsTransient();
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean processAttributeOverrideAnnotation(Member member, ClassMetadata classMetadata, PropertyMetadata propertyMetadata) {
        AttributeOverride attributeOverride = null;
        if (member instanceof Field) {
            attributeOverride = ((Field)member).getAnnotation(AttributeOverride.class);
        } else if (member instanceof Method) {
            attributeOverride = ((Method)member).getAnnotation(AttributeOverride.class);
        }
        if (attributeOverride == null) {
            return false;
        }
        String string = attributeOverride.name();
        Column column = attributeOverride.column();
        return JPAAnnotationProcessor.processColumnAnnotation(member, classMetadata, propertyMetadata);
    }

    static void processEmbeddableAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        Embeddable embeddable = clazz.getAnnotation(Embeddable.class);
        if (embeddable != null) {
            classMetadata.setIsSerial();
        }
    }

    static void processIdClassAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
    }

    static boolean processManyToOneAnnotation(Member member, PropertyMetadata propertyMetadata) {
        ManyToOne manyToOne = null;
        if (member instanceof Field) {
            manyToOne = ((Field)member).getAnnotation(ManyToOne.class);
        } else if (member instanceof Method) {
            manyToOne = ((Method)member).getAnnotation(ManyToOne.class);
        }
        if (manyToOne == null) {
            return false;
        }
        Class clazz = manyToOne.targetEntity();
        boolean bl = false;
        CascadeType[] cascadeTypeArray = manyToOne.cascade();
        for (int i = 0; i < cascadeTypeArray.length; ++i) {
            if (cascadeTypeArray[i] != CascadeType.REMOVE) continue;
            bl = true;
        }
        RelationshipMetadata relationshipMetadata = new RelationshipMetadata(false, bl, clazz, "", "");
        propertyMetadata.setRelationship(relationshipMetadata);
        if (manyToOne.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    static boolean processOneToManyAnnotation(Member member, PropertyMetadata propertyMetadata, Java2DBMapping java2DBMapping) {
        Class clazz;
        OneToMany oneToMany = null;
        if (member instanceof Field) {
            oneToMany = ((Field)member).getAnnotation(OneToMany.class);
        } else if (member instanceof Method) {
            oneToMany = ((Method)member).getAnnotation(OneToMany.class);
        }
        if (oneToMany == null) {
            return false;
        }
        Class clazz2 = oneToMany.targetEntity();
        boolean bl = false;
        CascadeType[] cascadeTypeArray = oneToMany.cascade();
        for (int i = 0; i < cascadeTypeArray.length; ++i) {
            if (cascadeTypeArray[i] != CascadeType.REMOVE) continue;
            bl = true;
        }
        String string = oneToMany.mappedBy();
        if (string != null && string.length() > 0) {
            AccessibleObject accessibleObject;
            clazz = clazz2;
            if (Void.TYPE.equals(clazz2)) {
                if (member instanceof Field) {
                    accessibleObject = (Field)member;
                    clazz = ((Field)accessibleObject).getType();
                    if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
                        clazz = GenericsProcessor.getCollectionElementType((Field)accessibleObject);
                    }
                } else if (member instanceof Method && (Collection.class.isAssignableFrom(clazz = ((Method)(accessibleObject = (Method)member)).getReturnType()) || Map.class.isAssignableFrom(clazz))) {
                    clazz = GenericsProcessor.getCollectionElementType((Method)accessibleObject);
                }
            }
            try {
                accessibleObject = PojoOperations.getPrivateField(clazz, string);
                string = java2DBMapping.cacheFieldNameFor(accessibleObject);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String string2 = ClassAnalizer.propertyName2GetterName(string, false);
                try {
                    Method method = clazz.getMethod(string2, new Class[0]);
                    string = java2DBMapping.cacheFieldNameFor(method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        clazz = new RelationshipMetadata(true, bl, clazz2, string, "");
        propertyMetadata.setRelationship((RelationshipMetadata)((Object)clazz));
        if (oneToMany.fetch() == FetchType.EAGER) {
            propertyMetadata.setFetchTypeEager();
        }
        return true;
    }

    static void processNamedNativeQueriesAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        NamedNativeQueries namedNativeQueries = clazz.getAnnotation(NamedNativeQueries.class);
        if (namedNativeQueries == null) {
            return;
        }
        NamedNativeQuery[] namedNativeQueryArray = namedNativeQueries.value();
        for (int i = 0; i < namedNativeQueryArray.length; ++i) {
            NamedNativeQuery namedNativeQuery = namedNativeQueryArray[i];
            classMetadata.setNamedQuery(namedNativeQuery.name(), namedNativeQuery.query(), namedNativeQuery.resultClass());
        }
    }

    static void processNamedNativeQueryAnnotation(Class<?> clazz, ClassMetadata classMetadata) {
        NamedNativeQuery namedNativeQuery = clazz.getAnnotation(NamedNativeQuery.class);
        if (namedNativeQuery == null) {
            return;
        }
        classMetadata.setNamedQuery(namedNativeQuery.name(), namedNativeQuery.query(), namedNativeQuery.resultClass());
    }
}

