/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.ant;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class AntScriptWriter {
    public static final String URI = "antlib:com.jalapeno.tools";
    public static final String TASK_connection = "connection";
    public static final String TASK_schemabuilder = "schemabuilder";
    public static final String TASK_classes = "classes";
    public static final String TASK_killextent = "killextent";
    public static final String TASK_populate = "populate";
    public static final String TASK_delete = "delete";
    public static final String TASK_rename = "rename";
    public static final String TASK_pushdown = "pushdown";
    public static final String TASK_pullup = "pullup";
    public static final String TASK_extractsuper = "extractsuper";
    private PrintStream mOut;
    private String mProjectName;
    private String mNamespace = "jalapeno";

    public AntScriptWriter(String string) throws FileNotFoundException {
        this.mOut = new PrintStream(new FileOutputStream(string));
    }

    public AntScriptWriter(String string, String string2) throws FileNotFoundException {
        this(string);
        this.mNamespace = string2;
        if (this.mNamespace != null && this.mNamespace.length() == 0) {
            this.mNamespace = null;
        }
    }

    public void dumpContent(String string, String string2) {
        this.mOut.println(string);
        this.mProjectName = string2;
    }

    public void writeProjectFileHeader(String string) {
        this.mOut.println("<?xml version=\"1.0\"?>");
        this.mOut.print("<project name = \"" + string + "\"");
        if (this.mNamespace != null) {
            this.mOut.print(" xmlns:" + this.mNamespace + "=" + "\"" + URI + "\"");
        }
        this.mOut.println(">");
        this.mProjectName = string;
        this.mOut.println("");
    }

    public void writeCacheDBPath(String string) {
        this.mOut.println("    <path id = \"cachedbjar\">");
        this.mOut.println("        <pathelement path=\"" + string + "\"/>");
        this.mOut.println("    </path>");
        this.mOut.println("");
    }

    public void writeCacheDBPath(String[] stringArray) {
        this.mOut.println("    <path id = \"cachedbjar\">");
        for (int i = 0; i < stringArray.length; ++i) {
            this.mOut.println("        <pathelement path=\"" + stringArray[i] + "\"/>");
        }
        this.mOut.println("    </path>");
        this.mOut.println("");
    }

    public void writeProjectOutPath(String string) {
        this.mOut.println("    <path id = \"" + this.getProjectOutPathId() + "\">");
        this.mOut.println("        <pathelement path=\"" + string + "\"/>");
        this.mOut.println("    </path>");
        this.mOut.println("");
    }

    public void writeProjectOutPath(URL[] uRLArray) {
        this.mOut.println("    <path id = \"" + this.getProjectOutPathId() + "\">");
        for (int i = 0; i < uRLArray.length; ++i) {
            this.mOut.println("        <pathelement path=\"" + uRLArray[i] + "\"/>");
        }
        this.mOut.println("    </path>");
        this.mOut.println("");
    }

    public void writeSetupTarget() {
        this.mOut.println("    <target name=\"setup\">");
        this.mOut.print("        <typedef resource=\"com/jalapeno/tools/ant.properties\"");
        if (this.mNamespace != null) {
            this.mOut.print(" uri=\"antlib:com.jalapeno.tools\"");
        }
        this.mOut.println(">");
        this.mOut.println("            <classpath refid=\"cachedbjar\"/>");
        this.mOut.println("        </typedef>");
        this.mOut.println("    </target>");
        this.mOut.println("");
    }

    public void writeConnectionTarget(String string, String string2, String string3, String string4, String string5, String string6) {
        this.mOut.println("    <target name=\"setconnection\" >");
        this.mOut.print("        " + this.startTask(TASK_connection) + " id=\"" + this.getConnectionId() + "\"");
        this.mOut.println(" host=\"" + string + "\" namespace=\"" + string3 + "\" port=\"" + string2 + "\"");
        this.mOut.print("              ");
        this.mOut.print("user=\"" + string4 + "\" password=\"" + string5 + "\"");
        if (string6 != null) {
            this.mOut.print(" logfile=\"" + string6 + "\"");
        }
        this.mOut.println("/>");
        this.mOut.println("    </target>");
        this.mOut.println("");
    }

    public void writeClasses(List list) {
        this.mOut.println("    <target name=\"setclasses\" >");
        this.mOut.println("        " + this.startTask(TASK_classes) + " id=\"" + this.getClassesId() + "\" classpathref=\"" + this.getProjectOutPathId() + "\">");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.mOut.println("            <class name=\"" + iterator.next() + "\"/>");
        }
        this.closeTask(TASK_classes);
        this.mOut.println("    </target>");
        this.mOut.println("");
    }

    public void writeBuildSchemaTarget(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3) {
        this.writeBuildSchemaTarget(bl, bl2, bl3, string, string2, string3, true, null, null, 0, 0);
    }

    public void writeBuildSchemaTarget(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, boolean bl4, String string4, String string5, int n, int n2) {
        this.mOut.println("    <target name=\"buildschema\"  description = \"Build Database Schema\"");
        this.mOut.println("            depends=\"setup,setclasses,setconnection\">");
        this.mOut.print("        " + this.startTask(TASK_schemabuilder) + " merge=\"" + bl + "\" rebuildIndices=\"" + bl4 + "\"");
        boolean bl5 = false;
        if (string4 != null) {
            this.mOut.println();
            this.mOut.print("                underscoreReplacement=\"" + string4 + "\"");
            bl5 = true;
        }
        if (string5 != null) {
            if (!bl5) {
                this.mOut.println("                ");
            }
            this.mOut.print(" dollarReplacement=\"" + string5 + "\"");
            bl5 = true;
        }
        if (n > 0) {
            if (!bl5) {
                this.mOut.println("                ");
            }
            this.mOut.print(" defaultStringLength=\"" + n + "\"");
            bl5 = true;
        }
        if (n2 > 0) {
            if (!bl5) {
                this.mOut.println("                ");
            }
            this.mOut.print(" defaultKeyLength=\"" + n2 + "\"");
            bl5 = true;
        }
        this.mOut.println(">");
        this.mOut.println("            <connection refid=\"" + this.getConnectionId() + "\"/>");
        this.mOut.print("            <introspectionoptions");
        if (bl3) {
            this.mOut.print(" metadata=\"annotations\"");
        } else if (bl2) {
            this.mOut.print(" metadata=\"hibernate\"");
        }
        if (string != null) {
            this.mOut.print(" exclude=\"" + string + "\"");
        }
        if (string2 != null) {
            this.mOut.print(" defaultAccessType=\"" + string2 + "\"");
        }
        if (string3 != null) {
            this.mOut.print(" defaultAccessLevel=\"" + string3 + "\"");
        }
        this.mOut.println("/>");
        this.mOut.println("            <classes refid=\"" + this.getClassesId() + "\"/>");
        this.closeTask(TASK_schemabuilder);
        this.mOut.println("    </target>");
        this.mOut.println("");
    }

    public void writeKillExtentTarget() {
        this.mOut.println("    <target name=\"killExtent\"  description = \"Kill Database Extent\"");
        this.mOut.println("            depends=\"setup,setclasses,setconnection\">");
        this.mOut.println("        " + this.startTask(TASK_killextent) + ">");
        this.mOut.println("            <connection refid=\"" + this.getConnectionId() + "\"/>");
        this.mOut.println("            <classes refid=\"" + this.getClassesId() + "\"/>");
        this.closeTask(TASK_killextent);
        this.mOut.println("    </target>");
        this.mOut.println("");
    }

    public void writeDeleteSchemaTarget() {
        this.mOut.println("    <target name=\"deleteSchema\"  description = \"Delete Database Schema\"");
        this.mOut.println("            depends=\"setup,setclasses,setconnection\">");
        this.mOut.println("        " + this.startTask(TASK_delete) + ">");
        this.mOut.println("            <connection refid=\"" + this.getConnectionId() + "\"/>");
        this.mOut.println("            <classes refid=\"" + this.getClassesId() + "\"/>");
        this.closeTask(TASK_delete);
        this.mOut.println("    </target>");
        this.mOut.println("");
    }

    public void writePopulateTarget() {
        this.writePopulateTarget(-1, -1);
    }

    public void writePopulateTarget(int n, int n2) {
        this.mOut.println("    <target name=\"populate\"  description = \"Populate Database Schema\"");
        this.mOut.println("            depends=\"setup,setclasses,setconnection\">");
        if (n > 0 && n2 > 0) {
            this.mOut.println("        " + this.startTask(TASK_populate) + " numRootInstances = \"" + n + "\" correlationFactor = \"" + n2 + "\">");
        } else {
            this.mOut.println("        " + this.startTask(TASK_populate) + ">");
        }
        this.mOut.println("            <connection refid=\"" + this.getConnectionId() + "\"/>");
        this.mOut.println("            <classes refid=\"" + this.getClassesId() + "\"/>");
        this.closeTask(TASK_populate);
        this.mOut.println("    </target>");
        this.mOut.println("");
    }

    public void writeRefactorTarget(List list, String string) {
        if (string == null) {
            string = "refactor";
        }
        this.mOut.println("    <target name=\"" + string + "\"  description = \"Refactor Database Schema\"");
        this.mOut.println("            depends=\"setup,setconnection\">");
        for (String string2 : list) {
            String string3;
            if (string2.startsWith("<rename")) {
                string3 = TASK_rename;
            } else if (string2.startsWith("<pushdown")) {
                string3 = TASK_pushdown;
            } else if (string2.startsWith("<pullup")) {
                string3 = TASK_pullup;
            } else if (string2.startsWith("<extractsuper")) {
                string3 = TASK_extractsuper;
            } else {
                throw new IllegalArgumentException("Unknown task: " + string2);
            }
            if (this.mNamespace != null) {
                string2 = string2.replaceFirst(string3, "jalapeno:" + string3);
            }
            this.mOut.println("        " + string2);
            this.mOut.println("            <connection refid=\"" + this.getConnectionId() + "\"/>");
            this.closeTask(string3);
        }
        this.mOut.println("    </target>");
    }

    public void closeProject() {
        this.mOut.println("</project>");
        this.mOut.close();
    }

    public static String createRenamePropertyTag(String string, String string2, String string3) {
        String string4 = "<rename classname = \"" + string + "\" property = \"" + string2 + "\" newname = \"" + string3 + "\">";
        return string4;
    }

    public static String createPushDownTag(String string, String string2, String string3) {
        String string4 = "<pushdown classname = \"" + string + "\" properties = \"" + string2 + "\" subclasses = \"" + string3 + "\">";
        return string4;
    }

    public static String createPullUpTag(String string, String string2, String string3, boolean bl) {
        String string4 = "<pullup classname = \"" + string + "\" properties = \"" + string2 + "\" superclass = \"" + string3 + "\" pullindices = \"" + bl + "\">";
        return string4;
    }

    public static String createExtractSuperTag(String string, String string2, boolean bl) {
        String string3 = "<extractsuper classname = \"" + string + "\" pullinterfaces = \"" + bl + "\" superclass = \"" + string2 + "\">";
        return string3;
    }

    private String getProjectOutPathId() {
        return this.mProjectName + "_classpath";
    }

    private String getConnectionId() {
        return this.mProjectName + "_connection";
    }

    private String getClassesId() {
        return this.mProjectName + "_classes";
    }

    private String startTask(String string) {
        if (this.mNamespace == null) {
            return "<" + string;
        }
        return "<" + this.mNamespace + ":" + string;
    }

    private String endtTask(String string) {
        if (this.mNamespace == null) {
            return "</" + string + ">";
        }
        return "</" + this.mNamespace + ":" + string + ">";
    }

    private void closeTask(String string) {
        this.mOut.println("        " + this.endtTask(string));
    }
}

