/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.refactoring;

import com.intersys.classes.Dictionary.ClassDefinition;
import com.intersys.classes.Dictionary.CompiledClass;
import com.intersys.classes.Dictionary.CompiledProperty;
import com.intersys.classes.Dictionary.IndexDefinition;
import com.intersys.classes.Dictionary.PropertyDefinition;
import com.intersys.classes.Dictionary.StorageDataDefinition;
import com.intersys.classes.Dictionary.StorageDataValueDefinition;
import com.intersys.classes.Dictionary.StorageDefinition;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.RelationshipObject;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.tools.objects.refactoring.ClassRefactoring;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Property {
    private Database mDB;
    private ClassDefinition mCDef;
    private Object mpKey;
    private RelationshipObject mProperties;
    private PropertyDefinition mOldProp;
    private PropertyDefinition mNewProp;
    private PropertyDefinition[] mNewProps;

    private Property(Database database, String string, String string2, int n) throws CacheException {
        this.mDB = database;
        this.init(string, string2, n);
    }

    private Property(ClassDefinition classDefinition, String string) throws CacheException {
        this.mCDef = classDefinition;
        this.mDB = this.mCDef.getDatabase();
        this.init(string, 1);
    }

    public static String rename(Database database, String string, String string2, String string3) throws CacheException {
        return new Property(database, string, string2, 1).doRename(string3);
    }

    public static String pushDown(Database database, String string, String string2, String string3) throws CacheException {
        return new Property(database, string, string3, 1).doPush(new String[]{string2}, null);
    }

    public static String pushDown(Database database, String string, String[] stringArray, String[] stringArray2) throws CacheException {
        String string2 = null;
        for (int i = 0; i < stringArray2.length; ++i) {
            string2 = new Property(database, string, stringArray2[i], stringArray.length).doPush(stringArray, string2);
        }
        return string2;
    }

    public static String pullUp(Database database, String string, String string2, String string3) throws CacheException {
        return new Property(database, string, string3, 1).doPull(string2, null, false, null, false);
    }

    public static String pullUp(Database database, String string, String string2, String string3, boolean bl) throws CacheException {
        return new Property(database, string, string3, 1).doPull(string2, null, false, null, bl);
    }

    protected static String pullVersionProperty(ClassDefinition classDefinition, String string, String string2) throws CacheException {
        return new Property(classDefinition, string2).doPull(string, null, true, null, false);
    }

    public static String pullUp(Database database, String string, String string2, String[] stringArray) throws CacheException {
        return Property.pullUp(database, string, string2, stringArray, false);
    }

    public static String pullUp(Database database, String string, String string2, String[] stringArray, boolean bl) throws CacheException {
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = new Property(database, string, stringArray[i], 1).doPull(string2, string3, false, stringArray, bl);
        }
        return string3;
    }

    private String doRename(String string) throws CacheException {
        Object object;
        ObjectHandle objectHandle;
        String string2 = this.mCDef.getName();
        String string3 = this.mOldProp.getName();
        this.mNewProp.setName(string);
        if (Property.hasStorageSlot(this.mOldProp)) {
            objectHandle = ClassRefactoring.findStorage(this.mCDef);
            object = this.getPropertySlot((StorageDefinition)objectHandle, string3);
            ((StorageDataValueDefinition)object).setValue(string);
        }
        objectHandle = this.mCDef.getIndices();
        object = ((RelationshipObject)objectHandle).iterator();
        while (object.hasNext()) {
            IndexDefinition indexDefinition = (IndexDefinition)object.next();
            String string4 = indexDefinition.getProperties();
            String string5 = string4.replaceAll(string3, string);
            indexDefinition.setProperties(string5);
        }
        if (Property.isRelationship(this.mOldProp)) {
            object = Property.renameInverse(this.mOldProp, string);
            string2 = string2 + "," + (String)object;
        }
        this.mProperties._removeAt(this.mpKey);
        this.mNewProp.setparent(this.mCDef);
        this.mCDef.save();
        return string2;
    }

    private String doPush(String[] stringArray, String string) throws CacheException {
        int n;
        int n2;
        if (this.isVersionProperty()) {
            throw new UnsupportedOperationException("Can not push version property to a subclass: " + this.mOldProp.getName());
        }
        if (string == null) {
            string = this.mCDef.getName();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                string = string + "," + stringArray[n2];
            }
        }
        n2 = stringArray.length;
        ClassDefinition[] classDefinitionArray = new ClassDefinition[n2];
        for (n = 0; n < n2; ++n) {
            classDefinitionArray[n] = (ClassDefinition)ClassDefinition.open(this.mDB, new Id(stringArray[n]));
        }
        this.pushDownIndices(classDefinitionArray);
        if (Property.isRelationship(this.mOldProp)) {
            if (n2 > 1) {
                throw new IllegalArgumentException("Can not push relationship to multiple sunclasses.");
            }
            String string2 = Property.renameRelType(this.mOldProp, stringArray[0]);
            string = string + "," + string2;
        }
        this.mProperties._removeAt(this.mpKey);
        for (n = 0; n < n2; ++n) {
            this.mNewProps[n].setparent(classDefinitionArray[n]);
            this.mNewProps[n].save();
        }
        this.mCDef.save();
        return string;
    }

    private void pushDownIndices(ClassDefinition[] classDefinitionArray) throws CacheException {
        String string = this.mOldProp.getName();
        int n = classDefinitionArray.length;
        RelationshipObject relationshipObject = this.mCDef.getIndices();
        Iterator iterator = relationshipObject.iterator();
        while (iterator.hasNext()) {
            IndexDefinition indexDefinition = (IndexDefinition)iterator.next();
            String string2 = indexDefinition.getProperties();
            if (string2.indexOf(string) < 0) continue;
            for (int i = 0; i < n; ++i) {
                IndexDefinition indexDefinition2 = (IndexDefinition)indexDefinition.constructClone();
                indexDefinition2.setparent(classDefinitionArray[i]);
                if (n > 1) {
                    String string3 = indexDefinition2.getName();
                    String string4 = classDefinitionArray[i].getName();
                    int n2 = string4.lastIndexOf(46);
                    if (n2 >= 0) {
                        string4 = string4.substring(n2 + 1);
                    }
                    string3 = string3 + string4;
                    indexDefinition2.setName(string3);
                }
                classDefinitionArray[i].save();
            }
            iterator.remove();
        }
    }

    private void pullUpIndices(String[] stringArray, ClassDefinition classDefinition) throws CacheException {
        String string = this.mOldProp.getName();
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray == null) {
            hashSet.add(string);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        RelationshipObject relationshipObject = this.mCDef.getIndices();
        Iterator iterator = relationshipObject.iterator();
        while (iterator.hasNext()) {
            IndexDefinition indexDefinition = (IndexDefinition)iterator.next();
            String string2 = indexDefinition.getProperties();
            if (!Property.canPullIndex(hashSet, string2)) continue;
            IndexDefinition indexDefinition2 = (IndexDefinition)indexDefinition.constructClone();
            indexDefinition2.setparent(classDefinition);
            classDefinition.save();
            iterator.remove();
        }
    }

    private String doPull(String string, String string2, boolean bl, String[] stringArray, boolean bl2) throws CacheException {
        Object object;
        StorageDataValueDefinition storageDataValueDefinition;
        if (!bl && this.isVersionProperty()) {
            return string2;
        }
        if (string2 == null) {
            string2 = this.mCDef.getName() + "," + string;
        }
        ClassDefinition classDefinition = (ClassDefinition)ClassDefinition.open(this.mDB, new Id(string));
        String string3 = this.mOldProp.getName();
        if (bl2) {
            this.pullUpIndices(stringArray, classDefinition);
        }
        if (Property.hasStorageSlot(this.mOldProp) && (storageDataValueDefinition = Property.findPropertySlot((StorageDefinition)(object = ClassRefactoring.findStorage(classDefinition)), string3, false)) == null) {
            this.moveStorageSlot(string3, (StorageDefinition)object);
        }
        if (Property.isRelationship(this.mOldProp)) {
            object = Property.renameRelType(this.mOldProp, string);
            string2 = string2 + "," + (String)object;
        }
        this.mProperties._removeAt(this.mpKey);
        this.mNewProp.setparent(classDefinition);
        this.mNewProp.save();
        this.mCDef.save();
        return string2;
    }

    public static boolean canPullIndex(Collection collection, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(46);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            if (collection.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private boolean isVersionProperty() throws CacheException {
        CacheClass cacheClass = this.mDB.getCacheClass(this.mCDef.getName());
        return this.mOldProp.getName().equals(cacheClass.getVersionPropertyName());
    }

    private void init(String string, String string2, int n) throws CacheException {
        this.mCDef = (ClassDefinition)ClassDefinition.open(this.mDB, new Id(string));
        this.init(string2, n);
    }

    private void init(String string, int n) throws CacheException {
        PropertyDefinition propertyDefinition = null;
        this.mpKey = null;
        this.mProperties = this.mCDef.getProperties();
        for (Map.Entry entry : this.mProperties.entrySet()) {
            propertyDefinition = (PropertyDefinition)entry.getValue();
            if (!string.equals(propertyDefinition.getName())) continue;
            this.mpKey = entry.getKey();
            break;
        }
        if (this.mpKey == null) {
            throw new IllegalArgumentException("No property " + string + " in class " + this.mCDef.getName());
        }
        this.mOldProp = propertyDefinition;
        this.mNewProps = new PropertyDefinition[n];
        for (int i = 0; i < n; ++i) {
            this.mNewProps[i] = (PropertyDefinition)propertyDefinition.constructClone();
        }
        this.mNewProp = this.mNewProps[0];
    }

    private static boolean isRelationship(PropertyDefinition propertyDefinition) throws CacheException {
        Boolean bl = propertyDefinition.getRelationship();
        if (bl == null) {
            return true;
        }
        return bl;
    }

    protected static boolean hasStorageSlot(PropertyDefinition propertyDefinition) throws CacheException {
        return !Property.isRelationship(propertyDefinition) || !"many".equals(propertyDefinition.getCardinality());
    }

    protected static String renameInverse(PropertyDefinition propertyDefinition, String string) throws CacheException {
        PropertyDefinition propertyDefinition2 = Property.findInverse(propertyDefinition);
        propertyDefinition2.setInverse(string);
        propertyDefinition2.save();
        return propertyDefinition2.getparent().getName();
    }

    protected static String renameRelType(PropertyDefinition propertyDefinition, String string) throws CacheException {
        PropertyDefinition propertyDefinition2 = Property.findInverse(propertyDefinition);
        propertyDefinition2.setType(string);
        propertyDefinition2.save();
        return propertyDefinition2.getparent().getName();
    }

    private static PropertyDefinition findInverse(PropertyDefinition propertyDefinition) throws CacheException {
        Database database = propertyDefinition.getDatabase();
        CompiledProperty compiledProperty = (CompiledProperty)CompiledProperty._open(database, propertyDefinition.getId());
        String string = compiledProperty.getInverse();
        String string2 = compiledProperty.getType();
        Id id = new Id(string2 + "||" + string);
        PropertyDefinition propertyDefinition2 = (PropertyDefinition)PropertyDefinition.open(database, id);
        if (!propertyDefinition2.getInverse().equals(propertyDefinition.getName())) {
            throw new IllegalStateException("Relationship between " + propertyDefinition.getId() + " and " + id + " is inconsistent: " + id + " inverse -> " + propertyDefinition2.getInverse());
        }
        return propertyDefinition2;
    }

    protected StorageDataValueDefinition getPropertySlot(StorageDefinition storageDefinition, String string) throws CacheException {
        StorageDataValueDefinition storageDataValueDefinition = Property.findPropertySlot(storageDefinition, string, false);
        if (storageDataValueDefinition != null) {
            return storageDataValueDefinition;
        }
        storageDataValueDefinition = this.findPropertySlotInParent(this.mCDef, string);
        if (storageDataValueDefinition == null) {
            throw new IllegalStateException("Slot for property " + string + " is not found in storage " + storageDefinition.getName() + " in class " + storageDefinition.getparent().getName());
        }
        StorageDataDefinition storageDataDefinition = storageDataValueDefinition.getparent();
        StorageDataDefinition storageDataDefinition2 = (StorageDataDefinition)storageDataDefinition.constructClone();
        storageDataDefinition2.setparent(storageDefinition);
        RelationshipObject relationshipObject = storageDataDefinition2.getValues();
        Iterator iterator = relationshipObject.iterator();
        while (iterator.hasNext()) {
            StorageDataValueDefinition storageDataValueDefinition2 = (StorageDataValueDefinition)iterator.next();
            if (!string.equals(storageDataValueDefinition2.getValue())) continue;
            return storageDataValueDefinition2;
        }
        throw new IllegalStateException("CLone does not have slot.");
    }

    protected static StorageDataValueDefinition findPropertySlot(StorageDefinition storageDefinition, String string, boolean bl) throws CacheException {
        RelationshipObject relationshipObject = storageDefinition.getData();
        Iterator iterator = relationshipObject.iterator();
        while (iterator.hasNext()) {
            StorageDataDefinition storageDataDefinition = (StorageDataDefinition)iterator.next();
            RelationshipObject relationshipObject2 = storageDataDefinition.getValues();
            Iterator iterator2 = relationshipObject2.iterator();
            while (iterator2.hasNext()) {
                StorageDataValueDefinition storageDataValueDefinition = (StorageDataValueDefinition)iterator2.next();
                if (!string.equals(storageDataValueDefinition.getValue())) continue;
                if (bl) {
                    iterator.remove();
                }
                return storageDataValueDefinition;
            }
        }
        return null;
    }

    private StorageDataValueDefinition findPropertySlotInParent(ClassDefinition classDefinition, String string) throws CacheException {
        CompiledClass compiledClass = (CompiledClass)CompiledClass._open(this.mDB, classDefinition.getId());
        CompiledClass compiledClass2 = ClassRefactoring.getPrimarySuper(compiledClass);
        if (compiledClass2 == null) {
            return null;
        }
        ClassDefinition classDefinition2 = (ClassDefinition)ClassDefinition.open(this.mDB, compiledClass2.getId());
        StorageDefinition storageDefinition = ClassRefactoring.findStorage(classDefinition2);
        StorageDataValueDefinition storageDataValueDefinition = Property.findPropertySlot(storageDefinition, string, false);
        if (storageDataValueDefinition == null) {
            return this.findPropertySlotInParent(classDefinition2, string);
        }
        return storageDataValueDefinition;
    }

    private void moveStorageSlot(String string, StorageDefinition storageDefinition) throws CacheException {
        StorageDefinition storageDefinition2 = ClassRefactoring.findStorage(this.mCDef);
        StorageDataValueDefinition storageDataValueDefinition = Property.findPropertySlot(storageDefinition2, string, true);
        if (storageDataValueDefinition == null) {
            return;
        }
        this.mDB.utilities().unregisterGlobalForClass(this.mCDef.getName());
        StorageDataDefinition storageDataDefinition = storageDataValueDefinition.getparent();
        StorageDataDefinition storageDataDefinition2 = (StorageDataDefinition)storageDataDefinition.constructClone();
        storageDataDefinition2.setparent(storageDefinition);
        storageDataDefinition2.save();
    }

    public static void main(String[] stringArray) throws Exception {
        Property.test(stringArray, "jdbc:Cache://localhost:1972/USER", "SYSTEM", "SYS");
    }

    public static void test(String[] stringArray, String string) throws Exception {
        Property.test(stringArray, string, "_SYSTEM", "SYS");
    }

    public static void test(String[] stringArray, String string, String string2, String string3) throws Exception {
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        String string6 = stringArray[2];
        String string7 = stringArray[3];
        Database database = CacheDatabase.getDatabase(string, string2, string3);
        database.transactionStart();
        try {
            String string8;
            if ("rename".equals(string4)) {
                string8 = Property.rename(database, string5, string6, string7);
            } else if ("pull".equals(string4)) {
                string8 = Property.pullUp(database, string5, string7, string6);
            } else if ("pulli".equals(string4)) {
                string8 = Property.pullUp(database, string5, string7, string6, true);
            } else if ("push".equals(string4)) {
                string8 = Property.pushDown(database, string5, string7, string6);
            } else if ("pushm".equals(string4)) {
                int n = 0;
                int n2 = 0;
                for (int i = 2; i < stringArray.length; ++i) {
                    if (n > 0) {
                        ++n;
                        continue;
                    }
                    if (stringArray[i].equals("-p")) {
                        ++n;
                        ++i;
                        continue;
                    }
                    ++n2;
                }
                String[] stringArray2 = new String[n2];
                String[] stringArray3 = new String[n];
                for (int i = 0; i < stringArray.length - 2; ++i) {
                    if (i < n2) {
                        stringArray2[i] = stringArray[i + 2];
                        continue;
                    }
                    if (i <= n2) continue;
                    stringArray3[i - 1 - n2] = stringArray[i + 2];
                }
                string8 = Property.pushDown(database, string5, stringArray2, stringArray3);
            } else {
                throw new Exception("Unknown Action: " + string4);
            }
            database.utilities().compileCacheClass(string8, "+db");
            database.utilities().rebuildIndices(string8);
            database.transactionCommit();
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace();
            database.transactionRollback();
            throw cacheException;
        }
        finally {
            database.close();
        }
    }
}

