/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBTimestampField
extends FBField {
    FBTimestampField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeTimestamp(this.getFieldData()));
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return this.field.decodeDate(this.getDate(), cal);
    }

    @Override
    public Date getDate() throws SQLException {
        if (this.getFieldData() == null) {
            return DATE_NULL_VALUE;
        }
        return new Date(this.getTimestamp().getTime());
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return this.field.decodeTime(this.getTime(), cal, this.isInvertTimeZone());
    }

    @Override
    public Time getTime() throws SQLException {
        if (this.getFieldData() == null) {
            return TIME_NULL_VALUE;
        }
        return new Time(this.getTimestamp().getTime());
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return this.field.decodeTimestamp(this.getTimestamp(), cal, this.isInvertTimeZone());
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        if (this.getFieldData() == null) {
            return TIMESTAMP_NULL_VALUE;
        }
        return this.field.decodeTimestamp(this.getFieldData());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(Timestamp.valueOf(value));
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setDate(this.field.encodeDate(value, cal));
    }

    @Override
    public void setDate(Date value) throws SQLException {
        if (value == DATE_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(new Timestamp(value.getTime()));
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTime(this.field.encodeTime(value, cal, this.isInvertTimeZone()));
    }

    @Override
    public void setTime(Time value) throws SQLException {
        if (value == TIME_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(new Timestamp(value.getTime()));
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setTimestamp(this.field.encodeTimestamp(value, cal, this.isInvertTimeZone()));
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == TIMESTAMP_NULL_VALUE) {
            this.setNull();
            return;
        }
        this.setFieldData(this.field.encodeTimestamp(value));
    }
}

