/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.AbstractConnectionPool;
import org.firebirdsql.pool.BasicAbstractConnectionPool;
import org.firebirdsql.pool.FBPooledDataSourceFactory;
import org.firebirdsql.pool.PingablePooledConnection;
import org.firebirdsql.pool.PooledConnectionEventListener;
import org.firebirdsql.pool.PooledConnectionManager;
import org.firebirdsql.pool.PooledConnectionQueue;
import org.firebirdsql.pool.PooledObject;
import org.firebirdsql.pool.PooledObjectEvent;

public abstract class AbstractDriverConnectionPoolDataSource
extends BasicAbstractConnectionPool
implements ConnectionPoolDataSource,
PooledConnectionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDriverConnectionPoolDataSource.class, false);
    public static final AbstractConnectionPool.UserPasswordPair EMPTY_USER_PASSWORD = new AbstractConnectionPool.UserPasswordPair();
    private PrintWriter logWriter;
    private String jdbcUrl;
    private String driverClassName;
    private int transactionIsolation = 2;
    private Properties props = new Properties();
    private DriverPooledConnectionManager connectionManager = new DriverPooledConnectionManager();
    protected static final String PROPERTIES = "properties";
    protected static final String DRIVER_CLASS_NAME = "driverClassName";
    protected static final String JDBC_URL = "jdbcUrl";

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("Specified properties are null.");
        }
        this.props.putAll((Map<?, ?>)properties);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    @Override
    public int getLoginTimeout() {
        return this.getBlockingTimeout() / 1000;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.setBlockingTimeout(seconds * 1000);
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolationLevel(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public String getIsolation() {
        switch (this.getTransactionIsolationLevel()) {
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        throw new IllegalStateException("Unknown transaction isolation level");
    }

    public void setIsolation(String isolation) throws SQLException {
        if ("TRANSACTION_READ_COMMITTED".equalsIgnoreCase(isolation)) {
            this.setTransactionIsolationLevel(2);
        } else if ("TRANSACTION_REPEATABLE_READ".equalsIgnoreCase(isolation)) {
            this.setTransactionIsolationLevel(4);
        } else if ("TRANSACTION_SERIALIZABLE".equalsIgnoreCase(isolation)) {
            this.setTransactionIsolationLevel(8);
        } else {
            throw new FBSQLException("Unknown transaction isolation.", "HY009");
        }
    }

    @Override
    protected PooledConnectionManager getConnectionManager() throws SQLException {
        return this.connectionManager;
    }

    @Override
    protected String getPoolName() {
        return this.getJdbcUrl();
    }

    @Override
    protected synchronized PooledObject getPooledConnection(PooledConnectionQueue queue) throws SQLException {
        PingablePooledConnection connection = (PingablePooledConnection)super.getPooledConnection(queue);
        connection.addConnectionEventListener(this);
        return connection;
    }

    @Override
    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(EMPTY_USER_PASSWORD)));
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return (PooledConnection)((Object)this.getPooledConnection(this.getQueue(new AbstractConnectionPool.UserPasswordPair(user, password))));
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource());
        this.pooledObjectReleased(event);
    }

    @Override
    public void physicalConnectionClosed(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.pooledObjectReleased(event);
    }

    @Override
    public void physicalConnectionDeallocated(ConnectionEvent connectionEvent) {
        PooledObjectEvent event = new PooledObjectEvent(connectionEvent.getSource(), true);
        this.physicalConnectionDeallocated(event);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.getLogger() != null) {
            this.getLogger().error("Error occured in connection.", event.getSQLException());
        }
    }

    @Override
    public int getFreeSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).size();
    }

    @Override
    public int getTotalSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).totalSize();
    }

    @Override
    public int getWorkingSize() throws SQLException {
        return this.getQueue(EMPTY_USER_PASSWORD).workingSize();
    }

    @Override
    protected BasicAbstractConnectionPool createObjectInstance() {
        return FBPooledDataSourceFactory.createDriverConnectionPoolDataSource();
    }

    @Override
    public Reference getDefaultReference() {
        Reference ref = super.getDefaultReference();
        if (this.getDriverClassName() != null) {
            ref.add(new StringRefAddr(DRIVER_CLASS_NAME, this.getDriverClassName()));
        }
        if (this.getJdbcUrl() != null) {
            ref.add(new StringRefAddr(JDBC_URL, this.getJdbcUrl()));
        }
        byte[] data = AbstractDriverConnectionPoolDataSource.serialize(this.getProperties());
        ref.add(new BinaryRefAddr(PROPERTIES, data));
        return ref;
    }

    protected Object processObjectInstance(AbstractDriverConnectionPoolDataSource ds, Object obj) throws Exception {
        byte[] data;
        Properties props;
        RefAddr binAddr;
        if (ds == null) {
            return null;
        }
        Reference ref = (Reference)obj;
        String addr = this.getRefAddr(ref, DRIVER_CLASS_NAME);
        if (addr != null) {
            ds.setDriverClassName(addr);
        }
        if ((addr = this.getRefAddr(ref, JDBC_URL)) != null) {
            ds.setJdbcUrl(addr);
        }
        if ((binAddr = ref.get(PROPERTIES)) != null && (props = (Properties)AbstractDriverConnectionPoolDataSource.deserialize(data = (byte[])binAddr.getContent())) != null) {
            ds.setProperties(props);
        }
        return ds;
    }

    private class DriverPooledConnectionManager
    implements PooledConnectionManager {
        private static final String USER_NAME_PROPERTY = "user";
        private static final String PASSWORD_PROPERTY = "password";
        private boolean driverInitialized;

        private DriverPooledConnectionManager() {
        }

        @Override
        public PooledObject allocateConnection(Object key) throws SQLException {
            if (!this.driverInitialized) {
                try {
                    Class.forName(AbstractDriverConnectionPoolDataSource.this.getDriverClassName());
                    this.driverInitialized = true;
                }
                catch (ClassNotFoundException ex) {
                    throw new FBSQLException("Class " + AbstractDriverConnectionPoolDataSource.this.getDriverClassName() + " not found.");
                }
            }
            if (!(key instanceof AbstractConnectionPool.UserPasswordPair)) {
                throw new FBSQLException("Incorrect key.");
            }
            AbstractConnectionPool.UserPasswordPair pair = (AbstractConnectionPool.UserPasswordPair)key;
            String userName = pair.getUserName();
            String password = pair.getPassword();
            Properties props = new Properties();
            props.putAll((Map<?, ?>)AbstractDriverConnectionPoolDataSource.this.getProperties());
            if (userName != null) {
                props.setProperty(USER_NAME_PROPERTY, userName);
            }
            if (password != null) {
                props.setProperty(PASSWORD_PROPERTY, password);
            }
            Connection connection = DriverManager.getConnection(AbstractDriverConnectionPoolDataSource.this.getJdbcUrl(), props);
            PingablePooledConnection pooledConnection = null;
            pooledConnection = AbstractDriverConnectionPoolDataSource.this.isPingable() ? new PingablePooledConnection(connection, AbstractDriverConnectionPoolDataSource.this.getPingStatement(), AbstractDriverConnectionPoolDataSource.this.getPingInterval(), AbstractDriverConnectionPoolDataSource.this.isStatementPooling(), AbstractDriverConnectionPoolDataSource.this.getMaxStatements(), AbstractDriverConnectionPoolDataSource.this.isKeepStatements()) : new PingablePooledConnection(connection, AbstractDriverConnectionPoolDataSource.this.isStatementPooling(), AbstractDriverConnectionPoolDataSource.this.getMaxStatements(), AbstractDriverConnectionPoolDataSource.this.isKeepStatements());
            pooledConnection.setDefaultTransactionIsolation(AbstractDriverConnectionPoolDataSource.this.getTransactionIsolationLevel());
            return pooledConnection;
        }
    }
}

