/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxStatement;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IfxDate
extends IfxObject {
    private Date h;
    public static final int IFX_DATE_NULL = Integer.MIN_VALUE;

    IfxDate() throws SQLException {
        this.h = null;
        this.setIfxType(7);
    }

    IfxDate(Date date) throws SQLException {
        block3: {
            block2: {
                this.h = null;
                this.setIfxType(7);
                this.h = date;
                if (this.h != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
        }
    }

    public Date value() {
        return this.h;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.h;
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxDate(this.h);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[4];
            memoryUtil.byfill(byArray, (byte)0);
            byArray[0] = -128;
            return byArray;
        }
        return JavaToIfxType.JavaToIfxDate(this.h);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        block3: {
            block2: {
                this.h = IfxToJavaType.IfxToJavaDate(byArray, n);
                if (this.h != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String string = null;
        if (this.isNull()) {
            return null;
        }
        try {
            string = dateUtil.convertDateStr(this.h, this.conn);
        }
        catch (SQLException sQLException) {
            string = null;
            return null;
        }
        return string;
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
            return;
        }
        try {
            this.h = dateUtil.convertDateObj(string.trim(), this.conn);
            this.unnullify();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.nullify();
            throw IfxErrMsg.getSQLException(-79716, illegalArgumentException.toString(), this.conn);
        }
    }

    @Override
    public Timestamp toTimestamp() {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.h.getTime());
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) {
        block3: {
            block2: {
                if (timestamp != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = new Date(timestamp.getTime());
            this.unnullify();
        }
    }

    @Override
    public Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return this.h;
    }

    @Override
    public void fromDate(Date date) {
        block3: {
            block2: {
                if (date != null) break block2;
                this.nullify();
                if (IfxStatement.t == 0) break block3;
            }
            this.h = date;
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxDate)) {
            return false;
        }
        IfxDate ifxDate = (IfxDate)object;
        if (ifxDate.isNull()) {
            return false;
        }
        return this.h.equals(ifxDate.h);
    }

    @Override
    public String toUnloadString() {
        return this.toString();
    }
}

