/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorage;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLobDb
extends Value
implements Value.ValueClob,
Value.ValueBlob {
    private final int type;
    private long precision;
    private int tableId;
    private int hash;
    private LobStorage lobStorage;
    private long lobId;
    private byte[] small;
    private DataHandler handler;
    private FileStore tempFile;
    private String fileName;

    private ValueLobDb(int n, LobStorage lobStorage, String string, int n2, long l, long l2) {
        this.type = n;
        this.lobStorage = lobStorage;
        this.fileName = string;
        this.tableId = n2;
        this.lobId = l;
        this.precision = l2;
    }

    private ValueLobDb(int n, byte[] byArray, long l) {
        this.type = n;
        this.small = byArray;
        this.precision = l;
    }

    public static ValueLobDb create(int n, LobStorage lobStorage, String string, int n2, long l, long l2) {
        return new ValueLobDb(n, lobStorage, string, n2, l, l2);
    }

    public static ValueLobDb createSmallLob(int n, byte[] byArray, long l) {
        return new ValueLobDb(n, byArray, l);
    }

    public Value convertTo(int n) {
        if (n == this.type) {
            return this;
        }
        if (n == 16) {
            if (this.lobStorage != null) {
                Value value = this.lobStorage.createClob(this.getReader(), -1L);
                return value;
            }
        } else if (n == 15 && this.lobStorage != null) {
            Value value = this.lobStorage.createBlob(this.getInputStream(), -1L);
            return value;
        }
        return super.convertTo(n);
    }

    public boolean isLinked() {
        return this.tableId != -1;
    }

    public void close() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            ValueLobDb.deleteFile(this.handler, this.fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler dataHandler, String string) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            IOUtils.delete(string);
        }
    }

    public void unlink() {
        if (this.small == null && this.tableId != -1) {
            this.lobStorage.setTable(this.lobId, -1);
            this.tableId = -1;
        }
    }

    public Value link(DataHandler dataHandler, int n) {
        if (this.small == null) {
            if (n != this.tableId) {
                if (this.tableId != -2) {
                    return this.lobStorage.copyLob(this.type, this.lobId, n, this.getPrecision());
                }
                this.lobStorage.setTable(this.lobId, n);
                this.tableId = n;
            }
        } else if (this.small.length > dataHandler.getMaxLengthInplaceLob()) {
            LobStorage lobStorage = dataHandler.getLobStorage();
            Value value = this.type == 15 ? lobStorage.createBlob(this.getInputStream(), this.getPrecision()) : lobStorage.createClob(this.getReader(), this.getPrecision());
            return value.link(dataHandler, n);
        }
        return this;
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public String getString() {
        int n = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return StringUtils.utf8Decode(this.small);
                }
                return IOUtils.readStringAndClose(this.getReader(), n);
            }
            byte[] byArray = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), n);
            return StringUtils.convertBytesToString(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    public byte[] getBytes() {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return Utils.cloneByteArray(byArray);
    }

    public byte[] getBytesNoCopy() {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.type == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        Object object;
        if (value instanceof ValueLobDb) {
            object = (ValueLobDb)value;
            if (value == this) {
                return 0;
            }
            if (this.lobId == ((ValueLobDb)object).lobId && this.small == null && ((ValueLobDb)object).small == null) {
                return 0;
            }
        }
        if (this.type == 16) {
            return Integer.signum(this.getString().compareTo(value.getString()));
        }
        object = value.getBytesNoCopy();
        return Utils.compareNotNull(this.getBytes(), (byte[])object);
    }

    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    public InputStream getInputStream() {
        if (this.small != null) {
            return new ByteArrayInputStream(this.small);
        }
        if (this.fileName != null) {
            FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
            boolean bl = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, false, bl), 4096);
        }
        try {
            return this.lobStorage.getInputStream(this.lobId);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        long l = this.getPrecision();
        if (l > Integer.MAX_VALUE || l <= 0L) {
            l = -1L;
        }
        if (this.type == 15) {
            preparedStatement.setBinaryStream(n, this.getInputStream(), (int)l);
        } else {
            preparedStatement.setCharacterStream(n, this.getReader(), (int)l);
        }
    }

    public String getSQL() {
        if (this.type == 16) {
            String string = this.getString();
            return StringUtils.quoteStringSQL(string);
        }
        byte[] byArray = this.getBytes();
        String string = StringUtils.convertBytesToString(byArray);
        return "X'" + string + "'";
    }

    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 16) {
            stringBuilder.append("SPACE(").append(this.getPrecision());
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        stringBuilder.append(" /* table: ").append(this.tableId).append(" id: ").append(this.lobId).append(" */)");
        return stringBuilder.toString();
    }

    public byte[] getSmall() {
        return this.small;
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    public boolean equals(Object object) {
        return object instanceof ValueLobDb && this.compareSecure((Value)object, null) == 0;
    }

    public boolean isFileBased() {
        return this.small == null;
    }

    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 104;
        }
        return 140;
    }

    public ValueLobDb copyToTemp() {
        return this;
    }

    public long getLobId() {
        return this.lobId;
    }

    public void setPrecision(long l) {
        this.precision = l;
    }

    public String toString() {
        return "lob: " + this.fileName + " table: " + this.tableId + " id: " + this.lobId;
    }

    public static ValueLobDb createTempClob(Reader reader, long l, DataHandler dataHandler) {
        try {
            char[] cArray;
            Object object;
            int n;
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l2 = Long.MAX_VALUE;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLobDb.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(reader, -1);
                cArray = ((String)object).toCharArray();
                n = cArray.length;
            } else {
                cArray = new char[n];
                int n2 = n = (n = IOUtils.readFully(reader, cArray, n)) < 0 ? 0 : n;
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                object = StringUtils.utf8Encode(new String(cArray, 0, n));
                return ValueLobDb.createSmallLob(16, (byte[])object, n);
            }
            object = new ValueLobDb(16, null, 0L);
            super.createTempFromReader(cArray, n, reader, l2, dataHandler);
            return object;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public static ValueLobDb createTempBlob(InputStream inputStream, long l, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n;
            boolean bl;
            long l2 = Long.MAX_VALUE;
            boolean bl2 = bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLobDb.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n = byArray.length;
            } else {
                byArray = Utils.newBytes(n);
                n = IOUtils.readFully(inputStream, byArray, 0, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray2 = Utils.newBytes(n);
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return ValueLobDb.createSmallLob(15, byArray2, byArray2.length);
            }
            ValueLobDb valueLobDb = new ValueLobDb(15, null, 0L);
            valueLobDb.createTempFromStream(byArray, n, inputStream, l2, dataHandler);
            return valueLobDb;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFromReader(char[] cArray, int n, Reader reader, long l, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.initTemp(dataHandler);
            try {
                do {
                    this.precision += (long)n;
                    byte[] byArray = StringUtils.utf8Encode(new String(cArray, 0, n));
                    fileStoreOutputStream.write(byArray, 0, byArray.length);
                    if ((l -= (long)n) <= 0L) {
                        break;
                    }
                    n = ValueLobDb.getBufferSize(dataHandler, false, l);
                } while ((n = IOUtils.readFully(reader, cArray, n)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempFromStream(byte[] byArray, int n, InputStream inputStream, long l, DataHandler dataHandler) {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.initTemp(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            try {
                do {
                    this.precision += (long)n;
                    fileStoreOutputStream.write(byArray, 0, n);
                    if ((l -= (long)n) <= 0L) {
                        break;
                    }
                    n = ValueLobDb.getBufferSize(dataHandler, bl, l);
                } while ((n = IOUtils.readFully(inputStream, byArray, 0, n)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private FileStoreOutputStream initTemp(DataHandler dataHandler) {
        Object object;
        this.precision = 0L;
        this.handler = dataHandler;
        this.lobStorage = dataHandler.getLobStorage();
        this.small = null;
        try {
            object = dataHandler.getDatabasePath();
            if (((String)object).length() == 0) {
                object = SysProperties.PREFIX_TEMP_FILE;
            }
            this.fileName = IOUtils.createTempFile((String)object, ".temp.db", true, true);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
        this.tempFile = dataHandler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        object = new FileStoreOutputStream(this.tempFile, null, null);
        return object;
    }

    private static int getBufferSize(DataHandler dataHandler, boolean bl, long l) {
        long l2;
        long l3;
        if (l < 0L || l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if ((l3 = (long)dataHandler.getMaxLengthInplaceLob()) >= Integer.MAX_VALUE) {
            l3 = l;
        }
        long l4 = l2 = bl ? 131072L : 4096L;
        if (l2 < l && l2 <= l3) {
            l2 = Math.min(l, l3 + 1L);
            l2 = MathUtils.roundUpLong(l2, 4096L);
        }
        l2 = Math.min(l, l2);
        if ((l2 = (long)MathUtils.convertLongToInt(l2)) < 0L) {
            l2 = Integer.MAX_VALUE;
        }
        return (int)l2;
    }
}

