/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DatabaseMetaDataBase;
import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.MemoryResultSetSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.util.VersionInfo;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseMetaDataSapDB
extends DatabaseMetaDataBase {
    public static final String defaultCatalogName = "";
    private VersionInfo dbVersionInfo = null;
    private String dbVersion = null;
    private boolean noNullableColumns = false;
    private final String typename2odbc_C = "'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111";
    private final String DataTypeSuffix_C = "'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype";

    DatabaseMetaDataSapDB(ConnectionSapDB connection, VersionInfo mydbVersionInfo) throws SQLException {
        super(connection);
        this.dbVersionInfo = mydbVersionInfo;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        ResultSet result;
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT 2 SCOPE, columnname COLUMN_NAME, decode (((decode (datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype))), 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, (decode(datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype)) TYPE_NAME, len COLUMN_SIZE, NULL BUFFER_LENGTH, dec DECIMAL_DIGITS, 1 PSEUDO_COLUMN FROM domain.columns ");
        cmd.append("WHERE tablename = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append("AND owner = '" + schema + "' ");
        }
        cmd.append("AND keypos is not null ");
        try {
            result = this.internalQuery(cmd.toString(), "getBestRowIdentifier");
            try {
                ((ResultSetSapDB)result).setFromMetaData(true);
            }
            catch (ClassCastException ccx) {}
        }
        catch (SQLException exc) {
            if (exc.getErrorCode() == 100) {
                String[] colHeadings = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
                Object[][] rows = new Object[][]{{new Integer(2), "SYSKEY", new Integer(-2), "CHARBYTE", new Integer(8), null, null, new Integer(2)}};
                result = new MemoryResultSetSapDB(colHeadings, rows);
            }
            throw exc;
        }
        return result;
    }

    public ResultSet getCatalogs() throws SQLException {
        String[] colHeadings = new String[]{"TABLE_CAT"};
        Object[][] rows = new Object[][]{{defaultCatalogName}};
        MemoryResultSetSapDB result = new MemoryResultSetSapDB(colHeadings, rows);
        return result;
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT '' TABLE_CAT, table_owner TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM domain.columnprivileges WHERE ");
        cmd.append("table_name = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append("AND table_owner = '" + schema + "' ");
        }
        if (this.realPatternQualification(columnNamePattern)) {
            cmd.append("AND column_name LIKE '" + columnNamePattern + "' ESCAPE '\\' ");
        }
        cmd.append(" ORDER BY column_name, privilege ");
        return this.internalQuery(cmd.toString(), "getColumnPrivileges");
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        StringBuffer qualification = new StringBuffer();
        String nullableString = this.noNullableColumns ? "decode(mode, 'OPT', 1, 0) NULLABLE," : "decode(NULLABLE, 'YES', 1, 0) NULLABLE,";
        cmd.append("SELECT '' TABLE_CAT, owner TABLE_SCHEM, tablename TABLE_NAME, columnname COLUMN_NAME, decode (((decode (datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype))), 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, (decode(datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype)) TYPE_NAME, len COLUMN_SIZE, NULL BUFFER_LENGTH, dec DECIMAL_DIGITS, 10 NUM_PREC_RADIX, " + nullableString + "comment REMARKS, " + "\"DEFAULT\" COLUMN_DEF, " + "NULL SQL_DATA_TYPE, " + "NULL SQL_DATETIME_SUB, " + "len CHAR_OCTET_LENGTH, ");
        if (this.connection.isSQLModeOracle) {
            cmd.append("ROWNUM ORDINAL_POSITION, ");
        } else {
            cmd.append("ROWNO ORDINAL_POSITION, ");
        }
        if (this.noNullableColumns) {
            cmd.append("decode (mode, 'OPT', 'YES', 'NO') IS_NULLABLE, ");
        } else {
            cmd.append("NULLABLE IS_NULLABLE,  ");
        }
        cmd.append("NULL                       AS SCOPE_CATLOG,NULL                       AS SCOPE_SCHEMA,NULL                       AS SCOPE_TABLE,NULL                       AS SOURCE_DATA_TYPE");
        if (this.dbVersionInfo.getMajorVersion() * 10000 + this.dbVersionInfo.getMinorVersion() * 100 + this.dbVersionInfo.getMinorMinorVersion() >= 70403) {
            cmd.append(" ,DEFAULTFUNCTION            AS COLUMN_DEF_FUNC ");
        }
        cmd.append(" FROM DOMAIN.COLUMNS ");
        if (this.realPatternQualification(schemaPattern)) {
            qualification.append("AND owner LIKE '" + schemaPattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(tableNamePattern)) {
            qualification.append("AND tablename LIKE '" + tableNamePattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(columnNamePattern)) {
            qualification.append("AND columnname LIKE '" + columnNamePattern + "' ESCAPE '\\' ");
        }
        if (qualification.length() > 0) {
            cmd.append(" WHERE 1 = 1 ");
            cmd.append(qualification.toString());
        }
        cmd.append(" ORDER BY owner, tablename, pos ");
        try {
            return this.internalQuery(cmd.toString(), "getColumns");
        }
        catch (SQLException sqlEx) {
            if (sqlEx.getErrorCode() == -4005 && !this.noNullableColumns) {
                this.noNullableColumns = true;
                return this.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            throw sqlEx;
        }
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT '' PKTABLE_CAT, PKTABLE_OWNER PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, '' FKTABLE_CAT, FKTABLE_OWNER FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, 1 UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, 7 DEFERRABILITY FROM sysodbcforeignkeys ");
        cmd.append("WHERE pktable_name = '" + primaryTable + "' ");
        cmd.append("AND fktable_name = '" + foreignTable + "' ");
        if (this.realQualification(primarySchema)) {
            cmd.append("AND PKTABLE_OWNER = '" + primarySchema + "' ");
        }
        if (this.realQualification(foreignSchema)) {
            cmd.append("AND FKTABLE_OWNER = '" + foreignSchema + "' ");
        }
        String fullCmd = cmd.toString();
        return this.internalQuery(fullCmd, "getCrossReference");
    }

    public String getDatabaseProductVersion() throws SQLException {
        String result;
        if (this.dbVersion != null) {
            return this.dbVersion;
        }
        ResultSet resultSet = this.internalQuery("Select kernel from domain.versions", "getDatabaseProductVersion");
        resultSet.next();
        this.dbVersion = result = resultSet.getString(1);
        resultSet.close();
        return result;
    }

    public int getDriverMajorVersion() {
        return DriverSapDB.singleton().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return DriverSapDB.singleton().getMinorVersion();
    }

    public String getDriverName() throws SQLException {
        return DriverSapDB.singleton().getName();
    }

    public String getDriverVersion() throws SQLException {
        return DriverSapDB.getVersionString();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT '' PKTABLE_CAT, PKTABLE_OWNER PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, '' FKTABLE_CAT, FKTABLE_OWNER FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, 1 UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, 7 DEFERRABILITY FROM sysodbcforeignkeys ");
        cmd.append("WHERE pktable_name = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append("AND PKTABLE_OWNER = '" + schema + "' ");
        }
        return this.internalQuery(cmd.toString(), "getExportedKeys");
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        String concat = " WHERE";
        cmd.append("SELECT '' FUNCTION_CAT, OWNER FUNCTION_SCHEM, DBFUNCNAME FUNCTION_NAME, COMMENT REMARKS, 1 FUNCTION_TYPE, DBFUNCNAME SPECIFIC_NAME FROM DOMAIN.DBFUNCTIONS");
        if (this.realQualification(functionNamePattern)) {
            cmd.append(concat);
            cmd.append(" DBFUNCNAME LIKE '" + functionNamePattern + "' ESCAPE '\\' ");
            concat = "AND ";
        }
        if (this.realQualification(schemaPattern)) {
            cmd.append(concat);
            cmd.append("OWNER LIKE '" + schemaPattern + "' ESCAPE '\\' ");
        }
        cmd.append(" ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME");
        return this.internalQuery(cmd.toString(), "getFunctions");
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT        FUNCTION_CAT,       FUNCTION_SCHEM,       FUNCTION_NAME,       COLUMN_NAME,       COLUMN_TYPE,       DATA_TYPE,       TYPE_NAME,       PRECISION,       length,       SCALE,       RADIX,       NULLABLE,       COMMENT AS REMARKS,       CHAR_OCTET_LENGTH,       ORDINAL_POSITION,       IS_NULLABLE,       SPECIFIC_NAME FROM SYSJDBC.FUNCTIONCOLUMNS ");
        cmd.append(" WHERE FUNCTION_SCHEM LIKE " + (this.realQualification(schemaPattern) ? schemaPattern : "%") + " ESCAPE '\\' ");
        cmd.append("   AND FUNCTION_NAME  LIKE " + (this.realQualification(functionNamePattern) ? functionNamePattern : "%") + " ESCAPE '\\' ");
        cmd.append("   AND COLUMN_NAME LIKE " + (this.realQualification(columnNamePattern) ? columnNamePattern : "%") + " ESCAPE '\\' ");
        cmd.append(" ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME");
        return this.internalQuery(cmd.toString(), "getFunctionColumns");
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT '' PKTABLE_CAT, PKTABLE_OWNER PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, '' FKTABLE_CAT, FKTABLE_OWNER FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, 1 UPDATE_RULE,DELETE_RULE, FK_NAME, PK_NAME, 7 DEFERRABILITY FROM sysodbcforeignkeys ");
        cmd.append("WHERE fktable_name = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append("AND FKTABLE_OWNER = '" + schema + "' ");
        }
        return this.internalQuery(cmd.toString(), "getImportedKeys");
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT '' TABLE_CAT, table_owner TABLE_SCHEM, TABLE_NAME, decode (non_unique, 1, 'true', 'false') NON_UNIQUE, INDEX_QUALIFIER, INDEX_NAME, TYPE, seq_in_index ORDINAL_POSITION, COLUMN_NAME, collation ASC_OR_DESC, CARDINALITY, PAGES, FILTER_CONDITION FROM sysodbcindexes ");
        cmd.append("WHERE INDEX_NAME <> 'SYSPRIMARYKEYINDEX' ");
        cmd.append("AND table_name = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append("AND table_owner = '" + schema + "' ");
        }
        if (unique) {
            cmd.append("AND non_unique = 0 ");
        }
        return this.internalQuery(cmd.toString(), "getIndexInfo");
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 8000;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 4000;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 32;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 128;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 128;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 1023;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1023;
    }

    public int getMaxConnections() throws SQLException {
        try {
            ResultSet rs = this.internalQuery("select value from dbparameters    where description = 'MAXUSERTASKS'", "getMaxConnections");
            rs.next();
            int max = rs.getInt(1);
            rs.close();
            return max;
        }
        catch (SQLException ex) {
            return 0;
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 32;
    }

    public int getMaxIndexLength() throws SQLException {
        return 1024;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 32;
    }

    public int getMaxRowSize() throws SQLException {
        return 8088;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 32;
    }

    public int getMaxStatementLength() throws SQLException {
        return this.connection.maxStatementLength();
    }

    public int getMaxStatements() throws SQLException {
        return Integer.MAX_VALUE;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 64;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 32;
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT '' TABLE_CAT, owner TABLE_SCHEM , tablename TABLE_NAME, columnname COLUMN_NAME, keypos KEY_SEQ, null PK_NAME FROM domain.columns ");
        cmd.append("WHERE tablename = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append("AND owner = '" + schema + "' ");
        }
        cmd.append("AND keypos is not null ");
        cmd.append(" ORDER BY column_name ");
        return this.internalQuery(cmd.toString(), "getPrimaryKeys");
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        StringBuffer qualification = new StringBuffer();
        cmd.append("SELECT '' PROCEDURE_CAT, owner PROCEDURE_SCHEM, dbprocname PROCEDURE_NAME, parametername COLUMN_NAME, decode (\"IN/OUT-TYPE\", 'IN', 1, '   OUT', 2, 'IN/OUT', 4, 0) COLUMN_TYPE, decode (((decode (datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype))), 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, (decode(datatype,'CHAR','CHAR()','VARCHAR','VARCHAR()','LONG','LONG','LONG RAW','LONG',datatype))|| (' ' || (codetype)) TYPE_NAME, len PRECISION, len \"LENGTH\", dec SCALE, 10 RADIX, 2 NULLABLE, NULL REMARKS FROM domain.dbprocparams ");
        if (this.realPatternQualification(schemaPattern)) {
            qualification.append("AND owner like '" + schemaPattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(procedureNamePattern)) {
            qualification.append("AND dbprocname like '" + procedureNamePattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(columnNamePattern)) {
            qualification.append("AND parametername like '" + columnNamePattern + "' ESCAPE '\\' ");
        }
        if (qualification.length() > 0) {
            cmd.append("WHERE TRUE ");
            cmd.append(qualification.toString());
        }
        cmd.append("ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, pos ");
        return this.internalQuery(cmd.toString(), "getProcedureColumns");
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        StringBuffer qualification = new StringBuffer();
        cmd.append("SELECT '' PROCEDURE_CAT, owner PROCEDURE_SCHEM, dbprocname PROCEDURE_NAME, NULL RESERVED4, NULL RESERVED5, NULL RESERVED6, comment REMARKS, 1 PROCEDURE_TYPE FROM domain.DBPROCEDURES ");
        if (this.realPatternQualification(schemaPattern)) {
            qualification.append("AND owner like '" + schemaPattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(procedureNamePattern)) {
            qualification.append("AND dbprocname like '" + procedureNamePattern + "' ESCAPE '\\' ");
        }
        if (qualification.length() > 0) {
            cmd.append("WHERE 1 = 1 ");
            cmd.append(qualification.toString());
        }
        return this.internalQuery(cmd.toString(), "getProcedures");
    }

    public ResultSet getSchemas() throws SQLException {
        return this.internalQuery("Select username TABLE_SCHEM,  '' AS TABLE_CATALOG from domain.users  WHERE USERMODE <> 'COLDUSER' order by TABLE_SCHEM", "getSchemas");
    }

    public ResultSet getSchemas(String schemapattern) throws SQLException {
        if (schemapattern == null) {
            return this.getSchemas();
        }
        return this.internalQuery("Select username TABLE_SCHEM,  '' AS TABLE_CATALOG from domain.users  WHERE USERMODE <> 'COLDUSER' AND OWNER like '" + schemapattern + "' ESCAPE '\\' " + "order by TABLE_SCHEM", "getSchemas");
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        StringBuffer cmd = new StringBuffer();
        StringBuffer qualification = new StringBuffer();
        cmd.append("SELECT '' TABLE_CAT, OWNER TABLE_SCHEM, TABLENAME TABLE_NAME, GRANTOR, GRANTEE, PRIVILEGE, IS_GRANTABLE FROM domain.tableprivileges ");
        if (this.realPatternQualification(schemaPattern)) {
            qualification.append("AND owner LIKE '" + schemaPattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(tableNamePattern)) {
            qualification.append("AND tablename LIKE '" + tableNamePattern + "' ESCAPE '\\' ");
        }
        if (qualification.length() > 0) {
            cmd.append("WHERE 1 = 1 ");
            cmd.append(qualification.toString());
        }
        cmd.append(" ORDER BY owner, tablename ");
        return this.internalQuery(cmd.toString(), "getTablePrivileges");
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT '' TABLE_CAT, owner TABLE_SCHEM, ");
        buf.append("tablename TABLE_NAME, type TABLE_TYPE, ");
        buf.append("comment REMARKS, NULL                 AS TYPE_CAT,  NULL                 AS TYPE_SCHEMA, NULL                 AS TYPE_NAME, NULL                 AS SELF_REFERENCING_COL_NAME, NULL                 AS REF_GENERATION, SAMPLE_PERCENT, SAMPLE_ROWS from domain.tables WHERE 1 = 1 ");
        if (this.realPatternQualification(schemaPattern)) {
            buf.append("AND owner LIKE '" + schemaPattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(tableNamePattern)) {
            buf.append("AND tablename LIKE '" + tableNamePattern + "' ESCAPE '\\' ");
        }
        if (types == null) {
            buf.append("AND type <> 'RESULT' ");
        } else if (types != null && types.length > 0) {
            buf.append("AND type in ('" + types[0] + "'");
            for (int i = 1; i < types.length; ++i) {
                buf.append(",'" + types[i] + "'");
            }
            buf.append(") ");
        }
        buf.append("ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        return this.internalQuery(buf.toString(), "getTables");
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] colHeadings = new String[]{"TABLE_TYPE"};
        Object[][] rows = new Object[][]{{"RESULT"}, {"SYNONYM"}, {"SYSTEM"}, {"TABLE"}, {"VIEW"}};
        MemoryResultSetSapDB result = new MemoryResultSetSapDB(colHeadings, rows);
        return result;
    }

    public ResultSet getTypeInfo() throws SQLException {
        StringBuffer cmd = new StringBuffer();
        cmd.append("SELECT TYPE_NAME, decode (TYPE_NAME, 'CHAR', 1, 'CHAR() ASCII', 1, 'CHAR() EBCDIC', 1, 'CHAR() UNICODE', 1, 'CHAR() BYTE', -2, 'VARCHAR', 12, 'VARCHAR() ASCII', 12, 'VARCHAR() EBCDIC', 12, 'VARCHAR() UNICODE', 12, 'VARCHAR() BYTE', -3, 'LONG', -1, 'LONG ASCII', -1, 'LONG EBCDIC', -1, 'LONG UNICODE', -1, 'LONG BYTE', -4, 'LONG RAW', -4, 'FIXED', 3, 'DECIMAL', 3, 'REAL', 7, 'FLOAT', 6, 'DOUBLE PRECISION', 8, 'SMALLINT', 5, 'INTEGER', 4, 'BOOLEAN', -7, 'TIME', 92, 'DATE', 91, 'TIMESTAMP', 93, 'NUMBER', 2, 1111) DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, CREATE_PARAMS, NULLABLE, CASE_SENSITIVE, SEARCHABLE, UNSIGNED_ATTRIBUTE, money FIXED_PREC_SCALE , AUTO_INCREMENT, LOCAL_TYPE_NAME, MINIMUM_SCALE, MAXIMUM_SCALE, NULL SQL_DATA_TYPE , NULL SQL_DATETIME_SUB , 10 NUM_PREC_RADIX FROM sysodbctypes ");
        if (this.connection.isSQLModeOracle) {
            cmd.append("WHERE TYPE_NAME NOT IN ('TIMESTAMP','TIME','BOOLEAN','FIXED') ");
        }
        cmd.append("ORDER BY DATA_TYPE ");
        return this.internalQuery(cmd.toString(), "getTypeInfo");
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"}, new Object[0][]);
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"}, new Object[0][]);
    }

    private boolean realPatternQualification(String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.length() == 0) {
            return false;
        }
        return !pattern.equals("*");
    }

    private boolean realQualification(String pattern) {
        if (pattern == null) {
            return false;
        }
        return pattern.length() != 0;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME"}, new Object[0][]);
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME"}, new Object[0][]);
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return new MemoryResultSetSapDB(new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"}, new Object[0][]);
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.dbVersionInfo.getMajorVersion();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.dbVersionInfo.getMinorVersion();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public ResultSet getConstraints(String catalog, String schemapattern, String tablepattern) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT '' TABLE_CAT, owner TABLE_SCHEM, tablename TABLE_NAME, CONSTRAINTNAME AS CONSTRAINT_NAME,DEFINITION AS CONSTRAINTS_DEFINITION ");
        buf.append("FROM DOMAIN.CONSTRAINTS WHERE 1 = 1 ");
        if (this.realPatternQualification(schemapattern)) {
            buf.append("AND owner LIKE '" + schemapattern + "' ESCAPE '\\' ");
        }
        if (this.realPatternQualification(tablepattern)) {
            buf.append("AND tablename LIKE '" + tablepattern + "' ESCAPE '\\' ");
        }
        buf.append("ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        return this.internalQuery(buf.toString(), "getConstraints");
    }

    public boolean isMultiVersionReadEnabled() throws SQLException {
        return false;
    }
}

