/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ProcReplyPacket
extends RequestPacket {
    public ProcReplyPacket(StructuredMem rawPacket) {
        super(rawPacket);
        this.initializePacket((short)1);
        this.initSegment();
    }

    public void initSegment() {
        StructuredMem packet = this.mem;
        int pos = this.createSegment(4);
        packet.putString("00000", pos + 13);
        packet.putInt2(pos, 18);
        packet.putInt4(pos, 20);
        packet.putInt2(pos, 24);
        packet.putInt2(pos, 26);
        packet.putInt2(pos, 28);
        packet.putInt1(pos, 30);
    }

    public void setStopInfo(int errorCode, String errorMessage) {
        StructuredMem packet = this.mem;
        int pos = this.segmOffs;
        packet.putInt2(errorCode, pos + 18);
        this.newDataPart(6);
        this.addString(errorMessage);
    }

    public void setExceptionInfo(Throwable exc) {
        this.setStopInfo(-4711, exc.toString());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream ostream = new PrintStream(bytes);
        exc.printStackTrace(ostream);
        this.newDataPart(31);
        this.addString(bytes.toString());
    }

    public void hexDump() {
        this.mem.traceOn(System.out, this.length());
    }

    public void hexDump(int length) {
        this.mem.traceOn(System.out, length);
    }
}

