/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.ColumnInfo;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.DataPartFixed;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.SQLPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.StreamInfo;
import com.sap.dbtech.jdbc.translators.TranslatorFactory;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.VDNNumber;
import com.sap.dbtech.vsp001.Feature;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Vector;

public class ReplyPacket
extends SQLPacket {
    private int cachedResultCount = Integer.MIN_VALUE;
    private int cachedPartCount = Integer.MIN_VALUE;
    private int[] partIndices;
    private int partIdx = -1;
    private int currentSegment;
    private int identifierEncoding;

    public ReplyPacket(StructuredMem rawPacket, boolean cesuIdentifierEncoding) {
        super(rawPacket);
        this.segmOffs = 32;
        this.currentSegment = 1;
        this.identifierEncoding = cesuIdentifierEncoding ? 2 : 0;
        this.clearPartCache();
    }

    public SQLException createException() {
        String state = this.sqlState();
        int rc = this.returnCode();
        String errmsg = this.getErrorMsg();
        int errorPos = this.errorPos();
        if (rc == -8000) {
            errmsg = MessageTranslator.translate("error.restart.required");
        }
        return errorPos > 1 ? SQLExceptionSapDB.generateDatabaseException("error.databaseexception", state, rc, errorPos, 0, Integer.toString(rc), Integer.toString(errorPos), errmsg) : SQLExceptionSapDB.generateDatabaseException("error.databaseexception.woerrpos", state, rc, errorPos, 0, Integer.toString(rc), errmsg);
    }

    public int partCount() {
        if (this.cachedPartCount == Integer.MIN_VALUE) {
            this.cachedPartCount = super.partCount();
            return this.cachedPartCount;
        }
        return this.cachedPartCount;
    }

    int dumpSegment(PrintStream stream, int maxBuf, int segmPos) {
        stream.println("   <SEGMENT ");
        stream.println("    type=\"REPLY\"");
        stream.println("    index=\"" + this.getInt2(segmPos + 10) + "\"");
        stream.println("    offset=\"" + this.getInt4(segmPos + 4) + "\"");
        stream.println("    length=\"" + this.getInt4(segmPos + 0) + "\"");
        stream.println("    number_of_parts=\"" + this.getInt2(segmPos + 8) + "\"");
        StringUtil.fprintfs(stream, "    <! %s (%d) Pos: %d  Warnings (%x, %x)  Function: %d >\n", new Object[]{this.getString(segmPos + 13, 5), new Integer(this.getInt2(segmPos + 18)), new Integer(this.getInt4(segmPos + 20)), new Integer(this.getInt2(segmPos + 24)), new Integer(this.getInt2(segmPos + 26)), new Integer(this.getInt2(segmPos + 28))});
        int partCount = this.getInt2(segmPos + 8);
        int pos = segmPos + 40;
        for (int i = 0; i < partCount; ++i) {
            pos += this.dumpPart(stream, maxBuf, pos);
        }
        stream.println("   </SEGMENT> ");
        return this.getInt4(segmPos + 0);
    }

    public int errorPos() {
        return this.mem.getInt4(this.segmOffs + 20);
    }

    public boolean existsPart(int requestedKind) {
        return this.findPart(requestedKind) != -1;
    }

    public int findPart(int requestedKind) {
        this.partOffs = -1;
        this.partIdx = -1;
        for (int partsLeft = this.partCount(); partsLeft > 0; --partsLeft) {
            this.nextPart();
            if (this.partKind() != requestedKind) continue;
            return this.partPos();
        }
        return -1;
    }

    public int firstSegment() {
        int result = this.segmCount() > 0 ? 32 : -1;
        this.segmOffs = result;
        this.currentSegment = 1;
        this.clearPartCache();
        return result;
    }

    public int functionCode() {
        return this.mem.getInt2(this.segmOffs + 28);
    }

    public byte[] getDataBytes(int pos, int len) {
        byte defByte = this.mem.getInt1(pos);
        if (defByte == 255) {
            return null;
        }
        byte[] result = this.mem.getBytes(pos + 1, len - 1);
        return result;
    }

    public String getErrorMsg() {
        String result;
        if (this.findPart(6) != -1) {
            int dataPos = this.getPartDataPos();
            int partLen = this.partLength();
            result = this.getIdentifier(dataPos, partLen).trim();
        } else {
            result = MessageTranslator.translate("error");
        }
        return result;
    }

    public int getPartDataPos() {
        return this.partOffs + 16;
    }

    int nextPart() {
        ++this.partIdx;
        this.partOffs = this.partIndices[this.partIdx];
        return this.partOffs;
    }

    public int nextSegment() {
        if (this.segmCount() <= this.currentSegment++) {
            return -1;
        }
        this.segmOffs += this.segmLength();
        this.clearPartCache();
        return this.segmOffs;
    }

    public ColumnInfo[] parseSchemaTableColumnNames(ColumnInfo[] result) {
        int j;
        String name;
        int nameLen;
        int i;
        int count = this.partArguments();
        if (result == null || result.length == 0) {
            result = new ColumnInfo[count];
            for (i = 0; i < result.length; ++i) {
                result[i] = new ColumnInfo();
            }
        }
        int pos = this.getPartDataPos();
        count = this.getInt2(pos);
        pos += 2;
        int[] tableMap = new int[count];
        int[] schemaMap = new int[count];
        for (i = 0; i < count; ++i) {
            nameLen = this.getInt2(pos);
            pos += 2;
            if (nameLen == 0) continue;
            tableMap[i] = nameLen;
            nameLen = this.getInt2(pos);
            result[i].columnName = this.getString(pos += 2, nameLen, 2);
            pos += nameLen;
        }
        count = this.getInt2(pos);
        pos += 2;
        for (i = 0; i < count; ++i) {
            int index = this.getInt2(pos);
            nameLen = this.getInt2(pos += 2);
            name = this.getString(pos += 2, nameLen);
            pos += nameLen;
            for (j = 0; j < tableMap.length; ++j) {
                if (tableMap[j] - 1 != i) continue;
                result[j].tableName = name;
                schemaMap[j] = index;
            }
        }
        count = this.getInt2(pos);
        pos += 2;
        for (i = 0; i < count; ++i) {
            nameLen = this.getInt2(pos);
            name = this.getString(pos += 2, nameLen);
            pos += nameLen;
            for (j = 0; j < schemaMap.length; ++j) {
                if (schemaMap[j] - 1 != i) continue;
                result[j].schemaName = name;
            }
        }
        return result;
    }

    public ColumnInfo[] parseColumnNames(ColumnInfo[] result) {
        int i;
        int columnCount = this.partArguments();
        if (result == null || result.length == 0) {
            result = new ColumnInfo[columnCount];
            for (i = 0; i < result.length; ++i) {
                result[i] = new ColumnInfo();
            }
        }
        int pos = this.getPartDataPos();
        for (i = 0; i < columnCount; ++i) {
            byte nameLen = this.getInt1(pos);
            result[i].columnDisplayName = this.getIdentifier(pos + 1, nameLen);
            if (result[i].columnName == null) {
                result[i].columnName = result[i].columnDisplayName;
            }
            pos += nameLen + 1;
        }
        return result;
    }

    public byte[][] parseLongDescriptors() {
        if (!this.existsPart(18)) {
            return null;
        }
        int argCount = this.partArguments();
        byte[][] result = new byte[argCount][];
        for (int i = 0; i < argCount; ++i) {
            int pos = i * 41 + 1;
            result[i] = this.getBytes(this.getPartDataPos() + pos, 40);
        }
        return result;
    }

    public DBTechTranslator[] parseShortFields(ConnectionSapDB conn, boolean isDBProcedure, DBProcParameterInfo[] procParameters, boolean isVardata) throws SQLException {
        boolean serial = false;
        boolean readOnly = false;
        boolean isVariableInputOn = conn.isKernelFeaturesupported(3);
        boolean isVariableOutputOn = conn.isKernelFeaturesupported(12);
        int columnCount = this.partArguments();
        DBTechTranslator[] result = new DBTechTranslator[columnCount];
        int pos = this.getPartDataPos();
        for (int i = 0; i < columnCount; ++i) {
            int bufpos_in;
            int bufpos_out;
            DBProcParameterInfo info = null;
            if (procParameters != null && procParameters.length > i) {
                info = procParameters[i];
            }
            byte mode = this.getInt1(pos + 0);
            byte ioType = this.getInt1(pos + 1);
            byte dataType = this.getInt1(pos + 2);
            byte frac = this.getInt1(pos + 3);
            int len = this.getInt2(pos + 4);
            int ioLen = this.getInt2(pos + 6);
            if (isVardata) {
                if (ioType == 0 && isVariableInputOn || ioType == 1 && isVariableOutputOn) {
                    bufpos_in = bufpos_out = this.getInt2(pos + 8);
                    byte colProps = this.getInt1(pos + 10);
                    readOnly = (colProps & 1) != 0;
                    serial = (colProps & 2) != 0;
                } else {
                    bufpos_in = this.getInt2(pos + 8);
                    bufpos_out = this.getInt2(pos + 10);
                }
            } else {
                bufpos_in = bufpos_out = this.getInt4(pos + 8);
            }
            result[i] = this.getTranslator(mode, ioType, dataType, frac, len, ioLen, bufpos_in, bufpos_out, conn.isSpaceoptionSet(), isDBProcedure, info, readOnly, serial, conn.isDateTimeFormatInternal());
            pos += 12;
        }
        return result;
    }

    protected DBTechTranslator getTranslator(int mode, int ioType, int dataType, int frac, int len, int ioLen, int bufpos_in, int bufpos_out, boolean spaceoption, boolean isDBProcedure, DBProcParameterInfo procParamInfo, boolean readOnly, boolean autoIncre, boolean dateTimeFormatInternal) throws SQLException {
        return TranslatorFactory.create(mode, ioType, dataType, frac, len, ioLen, bufpos_in, bufpos_out, spaceoption, isDBProcedure, procParamInfo, readOnly, autoIncre, dateTimeFormatInternal);
    }

    public int partArguments() {
        return this.mem.getInt2(this.partOffs + 2);
    }

    public PartEnumeration partEnumeration() {
        this.partIdx = -1;
        this.partOffs = -1;
        return new PartEnumeration(this);
    }

    int partKind() {
        return this.mem.getInt1(this.partOffs + 0);
    }

    public int partLength() {
        return this.mem.getInt4(this.partOffs + 8);
    }

    int partPos() {
        return this.partOffs;
    }

    public int resultCount(boolean positionedAtPart) throws SQLException {
        if (this.cachedResultCount == Integer.MIN_VALUE) {
            if (!positionedAtPart && this.findPart(12) == -1) {
                this.cachedResultCount = -1;
                return -1;
            }
            byte[] rawNumber = this.getDataBytes(this.partOffs + 16, this.partLength());
            this.cachedResultCount = VDNNumber.number2int(rawNumber);
            return this.cachedResultCount;
        }
        return this.cachedResultCount;
    }

    public int getSessionID() {
        int result = this.findPart(20) != -1 ? this.mem.getInt4(this.getPartDataPos() - 1 + 2) : -1;
        return result;
    }

    public DataPartVariable getVarDataPart() throws SQLException {
        if (this.findPart(33) != -1) {
            int argCount = 1;
            return new DataPartVariable((StructuredMem)new StructuredBytes(this.mem.getBytes(this.getPartDataPos(), this.partLength())), argCount);
        }
        return null;
    }

    public int findDataPart() throws SQLException {
        this.partOffs = -1;
        this.partIdx = -1;
        for (int partsLeft = this.partCount(); partsLeft > 0; --partsLeft) {
            this.nextPart();
            int partKind = this.partKind();
            if (partKind != 5 && partKind != 33) continue;
            return partKind;
        }
        return -1;
    }

    public DataPart getDataPart() throws SQLException {
        int partKind = this.findDataPart();
        if (partKind == -1) {
            return null;
        }
        if (partKind == 5) {
            return new DataPartFixed((StructuredMem)new StructuredBytes(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments());
        }
        if (partKind == 33) {
            return new DataPartVariable((StructuredMem)new StructuredBytes(this.mem.getBytes(this.getPartDataPos(), this.partLength())), this.partArguments());
        }
        return null;
    }

    public int getKernelMajorVersion() {
        int result = this.findPart(20) != -1 ? Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2200, 1)) : -1;
        return result;
    }

    public int getKernelMinorVersion() {
        int result = this.findPart(20) != -1 ? Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2201, 2)) : -1;
        return result;
    }

    public boolean supportsKernelUnicode() {
        boolean result = this.findPart(20) != -1 ? this.mem.getInt1(this.getPartDataPos() - 1 + 1) == 1 : false;
        return result;
    }

    public short getDateTimeFormat() {
        short result = this.findPart(20) != -1 ? (short)this.mem.getInt1(this.getPartDataPos() - 1 + 170) : (short)-1;
        return result;
    }

    public byte[] getFeatures() {
        byte[] kernelFeatures = Feature.createNewFeatureSet();
        if (this.findPart(34) != -1) {
            int copyLen;
            int argCntLen = 2 * this.partArguments();
            if (argCntLen != (copyLen = this.partLength())) {
                copyLen = argCntLen > copyLen ? copyLen : argCntLen;
            }
            byte[] returnFeature = this.mem.getBytes(this.getPartDataPos(), copyLen);
            for (int i = 0; i < returnFeature.length; i += 2) {
                if (returnFeature[i + 1] == 0) continue;
                kernelFeatures[2 * (returnFeature[i] - 1) + 1] = 1;
            }
            if (kernelFeatures[23] == 1) {
                kernelFeatures[5] = 1;
                kernelFeatures[11] = 1;
                kernelFeatures[13] = 1;
            }
        }
        return kernelFeatures;
    }

    public int getKernelCorrectionLevel() {
        int result = this.findPart(20) != -1 ? Integer.parseInt(this.mem.getString(this.getPartDataPos() + 2203, 2)) : -1;
        return result;
    }

    public final int returnCode() {
        return this.mem.getInt2(this.segmOffs + 18);
    }

    private int segmLength() {
        return this.mem.getInt4(this.segmOffs + 0);
    }

    public String sqlState() {
        return this.mem.getString(this.segmOffs + 13, 5);
    }

    public boolean wasLastPart() {
        byte partAttributes = this.getInt1(this.partOffs + 1);
        boolean result = (partAttributes & 1) != 0;
        return result;
    }

    public final int weakReturnCode() {
        int result = this.returnCode();
        if (result == 100) {
            switch (this.functionCode()) {
                case 34: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 247: 
                case 248: 
                case 1206: 
                case 1207: 
                case 1208: 
                case 1209: 
                case 1210: 
                case 1211: 
                case 1247: {
                    break;
                }
                default: {
                    result = 0;
                }
            }
        }
        return result;
    }

    private final void clearPartCache() {
        this.cachedResultCount = Integer.MIN_VALUE;
        this.cachedPartCount = Integer.MIN_VALUE;
        int pc = this.mem.getInt2(this.segmOffs + 8);
        this.partIndices = new int[pc];
        int partofs = 0;
        for (int i = 0; i < pc; ++i) {
            if (i == 0) {
                partofs = this.partIndices[i] = this.segmOffs + 40;
                continue;
            }
            int partlen = this.mem.getInt4(partofs + 8);
            partofs = this.partIndices[i] = partofs + this.aligned(partlen + 16);
        }
    }

    public StreamInfo[] parseStreamInfos() throws SQLException {
        Vector<StreamInfo> v = new Vector<StreamInfo>();
        PartEnumeration e = this.partEnumeration();
        while (e.hasMoreElements()) {
            e.nextElement();
            if (e.partKind() != 25) continue;
            int tabid = this.getInt4(this.getPartDataPos());
            short rowcount = (short)this.partArguments();
            v.addElement(new StreamInfo(true, tabid, rowcount));
        }
        return v.toArray(new StreamInfo[v.size()]);
    }

    public int parseABAPTabIDForInput() throws SQLException {
        if (this.findPart(25) == -1) {
            throw new SQLException("Internal error: expected ABAP input stream part.");
        }
        return this.getInt4(this.getPartDataPos());
    }

    public int parseABAPTabIDForOutput() throws SQLException {
        if (this.findPart(26) == -1) {
            throw new SQLException("Internal error: expected ABAP output stream part.");
        }
        return this.getInt4(this.getPartDataPos());
    }

    public boolean isResultSetClosed() {
        byte slow = this.getInt1(this.segmOffs + 26);
        return (slow & 1) != 0;
    }

    protected String getIdentifier(int pos, int nameLen) {
        return this.getString(pos, nameLen, this.identifierEncoding);
    }

    public String getTablename() {
        return this.getIdentifier(this.getPartDataPos(), this.partLength());
    }

    public String getCursorName() {
        return this.getIdentifier(this.getPartDataPos(), this.partLength());
    }

    public String toString() {
        StringBuffer erg = new StringBuffer(super.toString());
        byte[] packet = this.mem.getBytes(0, this.size());
        erg.append("Receive Packet: [\n");
        erg.append(Tracer.Hex2String(packet));
        erg.append("\n]\n");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        this.traceOn(ps);
        try {
            erg.append(os.toString("ISO-8859-1"));
        }
        catch (Exception e) {
            erg.append(e.toString());
        }
        return erg.toString();
    }

    public byte[] getRawPart() {
        return this.mem.getBytes(this.getPartDataPos(), this.partLength());
    }
}

