/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.translators.AbstractGetval;
import com.sap.dbtech.jdbc.translators.ReaderInputStream;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.UnicodeUtil;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.SQLException;

public class GetvalUnicode
extends AbstractGetval {
    public GetvalUnicode(ConnectionSapDB connection, byte[] descriptor, StructuredMem dataPart, boolean isUnicodeColumn, boolean isPacketEncodingUnicode) {
        super(connection, descriptor, dataPart, 2, isPacketEncodingUnicode);
        this.isUnicodeColumn = isUnicodeColumn;
    }

    public long length() throws SQLException {
        return this.lengthInBytes() / (long)(this.isUnicodeColumn ? 2 : 1);
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ReaderInputStream(this.getCharacterStream(), false);
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ReaderInputStream(this.getCharacterStream(), false);
    }

    public java.io.Reader getCharacterStream() throws SQLException {
        return new Reader();
    }

    public byte[] transSearchPattern(String searchPattern) {
        byte[] pattern;
        if (this.isUnicodeColumn) {
            char[] chars = searchPattern.toCharArray();
            pattern = UnicodeUtil.char2BigUnicode(chars);
        } else {
            pattern = StringUtil.bytes_iso8859_1(searchPattern);
        }
        return pattern;
    }

    public long position(Clob lob, long start) throws SQLException {
        return super.position(lob, start);
    }

    public long position(String searchstr, long start) throws SQLException {
        if (this.isUnicodeColumn) {
            long pos = 2L * (start - 1L) + 1L;
            long erg = super.position(searchstr, pos);
            return erg == -1L ? erg : (erg - 1L) / 2L + 1L;
        }
        return super.position(searchstr, start);
    }

    public class Reader
    extends java.io.Reader {
        public int read() throws StreamIOException {
            if (GetvalUnicode.this.itemsInBuffer <= 0) {
                GetvalUnicode.this.nextChunk();
            }
            if (GetvalUnicode.this.atEnd) {
                return -1;
            }
            char result = GetvalUnicode.this.streamBuffer.getBigUnicodeChar(0);
            GetvalUnicode.this.streamBuffer.moveBase(2);
            --GetvalUnicode.this.itemsInBuffer;
            ++GetvalUnicode.this.longPosition;
            return result;
        }

        public int read(char[] b, int off, int len) throws StreamIOException {
            int charsCopied = 0;
            while (len > 0 && !GetvalUnicode.this.atEnd) {
                if (GetvalUnicode.this.itemsInBuffer <= 0) {
                    GetvalUnicode.this.nextChunk();
                }
                if (GetvalUnicode.this.atEnd) continue;
                int chunkChars = Math.min(len, GetvalUnicode.this.itemsInBuffer);
                int chunkBytes = chunkChars * 2;
                char[] chunk = GetvalUnicode.this.streamBuffer.getBigUnicode(0, chunkBytes);
                System.arraycopy(chunk, 0, b, off, chunkChars);
                len -= chunkChars;
                off += chunkChars;
                GetvalUnicode.this.itemsInBuffer -= chunkChars;
                GetvalUnicode.this.streamBuffer.moveBase(chunkBytes);
                charsCopied += chunkChars;
            }
            if (charsCopied == 0 && GetvalUnicode.this.atEnd) {
                charsCopied = -1;
            } else {
                GetvalUnicode.this.longPosition += (long)charsCopied;
            }
            return charsCopied;
        }

        protected void dumpReadResult(char[] b, int offs, int charsCopied) {
            String repr;
            if (charsCopied <= 32) {
                repr = new String(b, offs, charsCopied);
            } else {
                String start = new String(b, offs, 16);
                String end = new String(b, offs + charsCopied - 16, 16);
                repr = start + "..." + end;
            }
            System.out.println("        => [" + charsCopied + "] '" + repr + "'");
        }

        public void close() {
        }
    }
}

