/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimestampTranslator;
import com.sap.dbtech.util.UnicodeUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class UnicodeTimestampTranslator
extends TimestampTranslator {
    UnicodeTimestampTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getString(this.bufpos_output, this.physicalLength - 1);
        }
        return result;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int year = (raw[1] - 48) * 1000;
            year += (raw[3] - 48) * 100;
            year += (raw[5] - 48) * 10;
            year += raw[7] - 48;
            int month = (raw[11] - 48) * 10;
            month += raw[13] - 48;
            int day = (raw[17] - 48) * 10;
            day += raw[19] - 48;
            int hour = (raw[23] - 48) * 10;
            hour += raw[25] - 48;
            int min = (raw[29] - 48) * 10;
            min += raw[31] - 48;
            int sec = (raw[35] - 48) * 10;
            sec += raw[37] - 48;
            int milli = (raw[41] - 48) * 100;
            milli += (raw[43] - 48) * 10;
            int nano = ((milli += raw[45] - 48) * 10 + (raw[47] - 48)) * 100;
            nano += (raw[49] - 48) * 10;
            nano += raw[51] - 48;
            nano *= 1000;
            if (cal == null) {
                result = new Timestamp(year - 1900, month - 1, day, hour, min, sec, nano);
            } else {
                cal.clear();
                cal.set(year, month - 1, day, hour, min, sec);
                result = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, nano);
            }
        }
        return result;
    }

    protected void putSpecific(DataPart dataPart, Object data) {
        dataPart.putDefineByte(1, this.bufpos_input - 1);
        dataPart.putUnicodeBytes((byte[])data, this.bufpos_input, this.physicalLength - 1);
    }

    public Object transTimestampForInput(Timestamp arg, Calendar cal) throws SQLException {
        if (arg == null) {
            return null;
        }
        byte[] chars = (byte[])super.transTimestampForInput(arg, cal);
        byte[] bytes = UnicodeUtil.bytes2BigUnicode(chars);
        this.checkFieldLimits(bytes.length);
        return bytes;
    }
}

