/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.trace.TraceControl;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.NativeComm;
import com.sap.dbtech.rte.comm.NiCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AuthenticationManager;
import com.sap.dbtech.util.security.AuthenticationManagerInterface;
import com.sap.dbtech.util.security.NativeAuthenticationManagerDBM;
import com.sap.dbtech.util.security.ScrammMD5Authentication;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.zip.InflaterInputStream;

public class DBM {
    public static final String hostKeyC = "host";
    public static final String dbnameKeyC = "dbname";
    public static final String dbrootKeyC = "dbroot";
    public static final String userKeyC = "user";
    public static final String compressionC = "compression";
    public static final String replylengthKeyC = "replylength";
    public static final String transportC = "transport";
    private static final String hostDefaultC = "";
    private static final String dbnameDefaultC = "";
    private static final String dbrootDefaultC = "";
    private static final String pgmNameC = "dbmsrv";
    private static final String replyCompressionKeyC = "replycompression";
    private static final String replylengthDefaultC = "256 kb";
    private static final String replyCompressionDefaultC = "auto";
    private static final int alignSizeC = 8;
    static final int indicatorLengthC = 4;
    private JdbcCommunication connection;
    private boolean inCommunication;
    private DBMException storedException = null;
    private byte[] lastResult = null;
    private boolean compressionSupported = false;
    private boolean inAsciiCommunication = true;
    private int communicationEncoding = 0;
    private Properties dbminfo = new Properties();
    private TraceControl m_trcCtl;
    private boolean isTransportNative;
    private String replylength;
    private String treatment;
    private String compressedPrefix;
    private static final String compressedNext_C = "dbm_execute_next ";

    public DBM(Properties properties) throws RTEException {
        String host = properties.getProperty(hostKeyC, "");
        String dbname = properties.getProperty(dbnameKeyC, "");
        String dbroot = properties.getProperty(dbrootKeyC, "");
        this.replylength = properties.getProperty(replylengthKeyC, replylengthDefaultC);
        this.treatment = properties.getProperty(replyCompressionKeyC, replyCompressionDefaultC);
        this.m_trcCtl = DriverSapDB.openTrace(properties);
        this.isTransportNative = properties.getProperty(transportC, "socket").equalsIgnoreCase("native");
        if (!"off".equalsIgnoreCase(this.treatment)) {
            this.compressedPrefix = "dbm_execute_new replylength " + this.replylength + " treatment " + this.treatment + " dbmcommand ";
        }
        JdbcCommFactory factory = null;
        try {
            try {
                if (host.startsWith("sapni:")) {
                    int endPattern = host.indexOf(":inpas", 6);
                    if (-1 == endPattern) {
                        throw new RTEException(MessageTranslator.translate("error.host.wrongconnecturl", "closing token \":inpas\" not found for SAP routerstring"), -709, this.getTracer(), 1);
                    }
                    host = host.substring(6, endPattern);
                    factory = NiCommunication.factory;
                } else if (this.isTransportNative && DriverSapDB.loadNativeCommunication() == 2) {
                    factory = NativeComm.factory;
                } else {
                    this.isTransportNative = false;
                    factory = SocketComm.factory;
                }
                this.trace("new DBM Connection ", properties);
                this.connection = factory.xopen(host, dbname, dbroot, pgmNameC, properties, this.getTracer());
            }
            catch (Error linkErr) {
                factory = SocketComm.factory;
                this.connection = factory.xopen(host, dbname, dbroot, pgmNameC, properties, this.getTracer());
            }
        }
        catch (RTEException rteExc) {
            this.trace("using " + factory);
            this.trace("=> FAILED");
            throw rteExc;
        }
        try {
            String replytreatment;
            this.getDBMInfo();
            String code = this.dbminfo.getProperty("CODE", "ASCII");
            if (code.equalsIgnoreCase("UTF8")) {
                this.inAsciiCommunication = false;
                this.communicationEncoding = 2;
            }
            if ((replytreatment = this.dbminfo.getProperty("REPLYTREATMENT", "")).indexOf("zlib") != -1 && this.compressedPrefix != null) {
                this.compressionSupported = true;
            }
        }
        catch (DBMException ex) {
            this.storedException = ex;
        }
        this.trace("using " + this.connection + "\n");
        this.trace("    communication=" + (this.inAsciiCommunication ? "ASCII" : "UTF8") + "\n");
        if (!this.compressionSupported) {
            this.trace("    compression is not enabled\n");
        } else {
            this.trace("    compression is enabled\n");
            this.trace("    reply compression :" + this.treatment + "\n");
            this.trace("    reply length      :" + this.replylength + "\n");
        }
        this.trace("=> " + this);
    }

    private void getDBMInfo() throws DBMException, RTEException {
        String dbmversionreply = this.cmd("dbm_version");
        do {
            String l;
            int endl;
            if ((endl = dbmversionreply.indexOf(10)) == -1) {
                l = dbmversionreply.trim();
                dbmversionreply = null;
            } else {
                l = dbmversionreply.substring(0, endl).trim();
                dbmversionreply = dbmversionreply.substring(endl + 1);
            }
            int eqpos = l.indexOf(61);
            if (eqpos == -1) continue;
            String k = l.substring(0, eqpos).trim();
            String v = l.substring(eqpos + 1).trim();
            this.dbminfo.setProperty(k, v);
        } while (dbmversionreply != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws RTEException {
        this.trace(this + "->release ()");
        if (this.connection != null) {
            try {
                try {
                    this.cmd("release");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.connection != null) {
                    this.connection.release();
                }
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void finalize() throws RTEException {
        this.release();
    }

    private String userLogon(String logonData) throws RTEException, DBMException {
        try {
            return this.userLogonNewStyle(logonData);
        }
        catch (DBMException e) {
            int errCode = e.getErrorCode();
            if (errCode == -24977) {
                return this.cmd("USER_LOGON " + logonData, false);
            }
            if (errCode == -24946) {
                return this.userLogonOldStyle(logonData);
            }
            throw e;
        }
    }

    private String userLogonNewStyle(String logonData) throws RTEException, DBMException {
        String user = logonData;
        String pass = null;
        int sepPos = logonData.indexOf(44);
        if (-1 != sepPos) {
            user = logonData.substring(0, sepPos);
            pass = logonData.substring(sepPos + 1).toUpperCase();
        }
        try {
            boolean isUserPasswdAscii = StringUtil.isIso8859_1(pass);
            AuthenticationManagerInterface auth = this.isTransportNative ? new NativeAuthenticationManagerDBM(this, user, pass, isUserPasswdAscii) : new AuthenticationManager(this, user, pass);
            String cmd = auth.getFinalDBMConnectCmd(pass, !isUserPasswdAscii);
            String erg = this.cmd(cmd, false);
            return erg;
        }
        catch (SQLException e) {
            if (pass == null || pass.length() == 0) {
                throw new DBMException(-24950, "ERR_USRFAIL:", e.getMessage());
            }
            return this.cmd("USER_LOGON " + logonData, false);
        }
    }

    private String userLogonOldStyle(String logonData) throws RTEException, DBMException {
        ScrammMD5Authentication auth = new ScrammMD5Authentication();
        int sepPos = logonData.indexOf(44);
        if (-1 == sepPos) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [password not set]");
        }
        String user = logonData.substring(0, sepPos);
        String pass = logonData.substring(sepPos + 1).toUpperCase();
        String erg = null;
        try {
            erg = this.cmd("USER_GETCHALLENGE " + user + " METHODS " + "SCRAMMD5" + " " + Tracer.Hex2String(auth.getClientchallenge()).toUpperCase(), false);
        }
        catch (SQLException ex) {
            return this.cmd("USER_LOGON " + logonData, false);
        }
        catch (DBMException e) {
            if (e.getErrorID().equalsIgnoreCase("ERR_COMMAND") && e.getErrorCode() == -24977) {
                return this.cmd("USER_LOGON " + logonData, false);
            }
            throw e;
        }
        if (!erg.startsWith("SCRAMMD5")) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [unknown authentication algorithm received]");
        }
        sepPos = erg.indexOf(10);
        if (-1 == sepPos) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [wrong format of server challenge]");
        }
        erg = erg.substring(sepPos + 1, erg.length() - 1);
        try {
            auth.parseServerChallenge(Tracer.String2Hex(erg));
            boolean isUserPasswdAscii = StringUtil.isIso8859_1(pass);
            erg = this.cmd("USER_RESPONSE " + Tracer.Hex2String(auth.getFinalData(pass, !isUserPasswdAscii)).toUpperCase(), false);
            return erg;
        }
        catch (SQLException ex1) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "User authorization failed [" + ex1.toString() + "]");
        }
    }

    public String cmd(String cmdString) throws RTEException, DBMException {
        try {
            this.trace(this + "->cmd (" + cmdString + ")");
            String erg = this.compressionSupported ? this.cmdCompressed(cmdString, true) : this.cmd(cmdString, true);
            this.trace("=> " + erg);
            String string = erg;
            return string;
        }
        catch (DBMException e) {
            this.trace(" <-!");
            if (this.storedException != null) {
                DBMException tmpExcp = this.storedException;
                this.traceException(this.storedException);
                throw tmpExcp;
            }
            this.traceException(e);
            throw e;
        }
        catch (RTEException err) {
            this.trace(" <-!");
            if (this.storedException != null) {
                DBMException tmpExcp = this.storedException;
                this.traceException(this.storedException);
                throw tmpExcp;
            }
            this.traceException(err);
            throw err;
        }
        finally {
            this.storedException = null;
        }
    }

    public byte[] getBinaryResult() {
        return this.lastResult;
    }

    private String cmdCompressed(String cmdString, boolean checkLogon) throws RTEException, DBMException {
        int alignedLen;
        this.resetResult();
        if (checkLogon && (cmdString = cmdString.trim()).toUpperCase().startsWith("USER_LOGON")) {
            cmdString = cmdString.substring("USER_LOGON".length()).trim();
            return this.userLogon(cmdString);
        }
        cmdString = this.compressedPrefix + cmdString;
        StructuredMem request = this.connection.getRequestPacket();
        if (this.inAsciiCommunication) {
            alignedLen = (cmdString.length() + 8 - 1) / 8 * 8;
            request.putString(cmdString, 0);
        } else {
            byte[] byteArr = null;
            try {
                byteArr = cmdString.getBytes(this.communicationEncoding == 0 ? "ISO8859_1" : "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new DBMException(-24950, "ERR_USRFAIL:", "this version of java doesn't support encoding " + this.communicationEncoding);
            }
            alignedLen = (byteArr.length + 8 - 1) / 8 * 8;
            request.putBytes(byteArr, 0);
        }
        this.connection.request(request, alignedLen);
        try {
            this.inCommunication = true;
            StructuredMem reply = this.connection.receive();
            this.inCommunication = false;
            String errorIndicator = reply.getString(0, Math.min(4, reply.size()));
            if (errorIndicator.startsWith("OK")) {
                int dataStart = errorIndicator.indexOf(10) + 1;
                String string = this.processCompressionResult(reply, dataStart);
                return string;
            }
            throw DBMException.create(reply);
        }
        finally {
            this.inCommunication = false;
        }
    }

    private String processCompressionResult(StructuredMem reply, int dataStart) throws DBMException, RTEException {
        SplitCommandResultInputStream scs = new SplitCommandResultInputStream(reply, dataStart);
        InputStream is = scs;
        if (scs.getTreatment().equals("zlib")) {
            is = new InflaterInputStream(scs);
        } else if (scs.getTreatment().startsWith("zlib")) {
            try {
                for (int numcom = Integer.parseInt(scs.getTreatment().substring(5, 6)); numcom > 0; --numcom) {
                    is = new InflaterInputStream(is);
                }
            }
            catch (Exception e) {
                throw new DBMException(-24977, "ERR_COMMAND", "Treatment '" + scs.getTreatment() + "' not supported:" + e.getMessage());
            }
        } else if (!scs.getTreatment().equals("none")) {
            throw new DBMException(-24977, "ERR_COMMAND", "Treatment '" + scs.getTreatment() + "' not supported");
        }
        int firstchar = 0;
        int secondchar = 0;
        try {
            firstchar = is.read();
            secondchar = is.read();
        }
        catch (IOException ioEx) {
            scs.throwLastException();
            throw new DBMException(-24977, "ERR_COMMAND", "I/O exception while reading data: " + ioEx.getMessage());
        }
        if (firstchar == 79 && secondchar == 75) {
            int skipchar = -1;
            do {
                try {
                    skipchar = is.read();
                }
                catch (IOException e) {
                    scs.throwLastException();
                    throw new DBMException(-24977, "ERR_COMMAND", "I/O exception while reading data: " + e.getMessage());
                }
            } while (skipchar != 10 && skipchar != -1);
            if (skipchar == -1) {
                this.lastResult = new byte[0];
                return "";
            }
            byte[] tmpArray = new byte[32768];
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            try {
                int sz;
                while ((sz = is.read(tmpArray)) != -1) {
                    bo.write(tmpArray, 0, sz);
                }
            }
            catch (IOException ioEx) {
                scs.throwLastException();
                throw new DBMException(-24977, "ERR_COMMAND", "I/O exception while reading data: " + ioEx.getMessage());
            }
            this.lastResult = bo.toByteArray();
            try {
                return bo.toString(this.communicationEncoding == 0 ? "ISO8859_1" : "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new DBMException(-24950, "ERR_USRFAIL:", "this version of java doesn't support encoding " + this.communicationEncoding);
            }
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(firstchar);
        bo.write(secondchar);
        byte[] tmpArray = new byte[2048];
        int sz = 0;
        try {
            while ((sz = is.read(tmpArray)) != -1) {
                bo.write(tmpArray, 0, sz);
            }
        }
        catch (IOException ioEx) {
            scs.throwLastException();
            throw new DBMException(-24977, "ERR_COMMAND", "I/O exception while reading data: " + ioEx.getMessage());
        }
        try {
            throw DBMException.create(bo.toString(this.communicationEncoding == 0 ? "ISO8859_1" : "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DBMException(-24950, "ERR_USRFAIL:", "this version of java doesn't support encoding " + this.communicationEncoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String cmd(String cmdString, boolean checklogon) throws RTEException, DBMException {
        int alignedLen;
        this.resetResult();
        if (checklogon && (cmdString = cmdString.trim()).toUpperCase().startsWith("USER_LOGON")) {
            cmdString = cmdString.substring("USER_LOGON".length()).trim();
            return this.userLogon(cmdString);
        }
        StructuredMem request = this.connection.getRequestPacket();
        if (this.inAsciiCommunication) {
            alignedLen = (cmdString.length() + 8 - 1) / 8 * 8;
            request.putString(cmdString, 0);
        } else {
            byte[] byteArr = null;
            try {
                byteArr = cmdString.getBytes(this.communicationEncoding == 0 ? "ISO8859_1" : "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new DBMException(-24950, "ERR_USRFAIL:", "this version of java doesn't support encoding " + this.communicationEncoding);
            }
            alignedLen = (byteArr.length + 8 - 1) / 8 * 8;
            request.putBytes(byteArr, 0);
        }
        this.connection.request(request, alignedLen);
        try {
            this.inCommunication = true;
            StructuredMem reply = this.connection.receive();
            this.inCommunication = false;
            String errorIndicator = reply.getString(0, Math.min(4, reply.size()));
            if (!errorIndicator.startsWith("OK")) {
                throw DBMException.create(reply);
            }
            int dataStart = errorIndicator.indexOf(10) + 1;
            String result = reply.getString(dataStart, reply.size() - dataStart, this.communicationEncoding);
            this.lastResult = reply.getBytes(dataStart, reply.size() - dataStart);
            String string = result;
            return string;
        }
        finally {
            this.inCommunication = false;
        }
    }

    public void cancel() throws SQLException {
        if (this.inCommunication) {
            this.connection.cancel();
        }
    }

    public static DBM dbDBM(String host, String dbname) throws RTEException {
        Properties props = new Properties();
        if (host != null) {
            props.put(hostKeyC, host);
        }
        if (dbname != null) {
            props.put(dbnameKeyC, dbname);
        }
        return new DBM(props);
    }

    public static DBM dbrootDBM(String host, String dbroot) throws RTEException {
        Properties props = new Properties();
        if (host != null) {
            props.put(hostKeyC, host);
        }
        props.put(dbrootKeyC, dbroot);
        return new DBM(props);
    }

    private void resetResult() {
        this.lastResult = null;
    }

    public void trace(String txt) {
        if (this.m_trcCtl != null) {
            this.m_trcCtl.tracer.print(txt);
        }
    }

    private void trace(String txt, Properties properties) {
        if (this.m_trcCtl != null) {
            this.m_trcCtl.tracer.print(txt, properties);
        }
    }

    public void traceException(Exception ex) {
        if (this.m_trcCtl != null) {
            this.m_trcCtl.tracer.traceException(ex);
        }
    }

    public Tracer getTracer() {
        return this.m_trcCtl != null ? this.m_trcCtl.tracer : null;
    }

    class SplitCommandResultInputStream
    extends InputStream {
        private String treatment;
        private String id;
        private byte[] currentbuffer;
        private int currentpos;
        private boolean lastbuffer;
        private DBMException lastDBMException;
        private RTEException lastRTEException;

        SplitCommandResultInputStream(StructuredMem reply, int dataStart) throws DBMException {
            this.evalReply(reply, dataStart);
        }

        private void evalReply(StructuredMem reply, int dataStart) throws DBMException {
            String header = reply.getString(dataStart, Math.min(320, reply.size() - dataStart));
            int nl = header.indexOf(10);
            if (nl == -1) {
                throw new DBMException(-24977, "ERR_COMMAND", "Invalid header for compressed result");
            }
            this.id = header.substring(0, nl).trim();
            int start = nl + 1;
            if ((nl = header.indexOf(10, start)) == -1) {
                throw new DBMException(-24977, "ERR_COMMAND", "Invalid header for compressed result");
            }
            int byteslength = 0;
            try {
                byteslength = Integer.parseInt(header.substring(start, nl).trim());
            }
            catch (NumberFormatException nfe) {
                throw new DBMException(-24977, "ERR_COMMAND", "Invalid header for compressed result");
            }
            start = nl + 1;
            nl = header.indexOf(10, start);
            if (nl == -1) {
                throw new DBMException(-24977, "ERR_COMMAND", "Invalid header for compressed result");
            }
            this.treatment = header.substring(start, nl).trim();
            start = nl + 1;
            if ((nl = header.indexOf(10, start)) == -1) {
                throw new DBMException(-24977, "ERR_COMMAND", "Invalid header for compressed result");
            }
            String nextpacket = header.substring(start, nl).trim();
            this.lastbuffer = !nextpacket.equals("1");
            int restlength = reply.size() - dataStart - ++nl;
            if (restlength != byteslength) {
                throw new DBMException(-24977, "ERR_COMMAND", "Reply length (" + restlength + ") doesn't match with output header (" + byteslength + ")");
            }
            this.currentbuffer = reply.getBytes(dataStart + nl, byteslength);
            this.currentpos = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nextPart() throws IOException {
            block8: {
                try {
                    StructuredMem request = DBM.this.connection.getRequestPacket();
                    String cmdString = DBM.compressedNext_C + this.id;
                    int alignedLen = (cmdString.length() + 8 - 1) / 8 * 8;
                    request.putString(cmdString, 0);
                    DBM.this.connection.request(request, alignedLen);
                    try {
                        DBM.this.inCommunication = true;
                        StructuredMem reply = DBM.this.connection.receive();
                        DBM.this.inCommunication = false;
                        String errorIndicator = reply.getString(0, Math.min(4, reply.size()));
                        if (errorIndicator.startsWith("OK")) {
                            int dataStart = errorIndicator.indexOf(10) + 1;
                            try {
                                this.evalReply(reply, dataStart);
                                break block8;
                            }
                            catch (DBMException dbmEx) {
                                this.lastDBMException = dbmEx;
                                throw new IOException();
                            }
                        }
                        this.lastDBMException = DBMException.create(reply);
                        throw new IOException();
                    }
                    finally {
                        DBM.this.inCommunication = false;
                    }
                }
                catch (RTEException rteEx) {
                    this.lastRTEException = rteEx;
                    throw new IOException();
                }
            }
        }

        public int read() throws IOException {
            if (this.currentpos == this.currentbuffer.length) {
                if (this.lastbuffer) {
                    return -1;
                }
                this.nextPart();
                return this.read();
            }
            return this.currentbuffer[this.currentpos++] & 0xFF;
        }

        public int read(byte[] buf, int pos, int length) throws IOException {
            if (length > 0 && this.currentpos == this.currentbuffer.length && this.lastbuffer) {
                return -1;
            }
            int copiedbytes = 0;
            while (length > 0) {
                int available_length = this.currentbuffer.length - this.currentpos;
                if (available_length >= length) {
                    System.arraycopy(this.currentbuffer, this.currentpos, buf, pos, length);
                    copiedbytes += length;
                    this.currentpos += length;
                    length = 0;
                    continue;
                }
                System.arraycopy(this.currentbuffer, this.currentpos, buf, pos, available_length);
                pos += available_length;
                copiedbytes += available_length;
                this.currentpos += available_length;
                if (this.lastbuffer) {
                    length = 0;
                    continue;
                }
                length -= available_length;
                this.nextPart();
            }
            return copiedbytes;
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        String getTreatment() {
            return this.treatment;
        }

        void throwLastException() throws DBMException, RTEException {
            if (this.lastDBMException != null) {
                throw this.lastDBMException;
            }
            if (this.lastRTEException != null) {
                throw this.lastRTEException;
            }
        }
    }
}

