/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.util.StructuredMem;

public class DBMException
extends Exception {
    private int errorCode;
    private String errorID;

    DBMException(int eCode, String eID, String msg) {
        super(msg);
        this.errorCode = eCode;
        this.errorID = eID;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorID() {
        return this.errorID;
    }

    public String toString() {
        return "<DBMException " + this.errorCode + " " + this.errorID + " " + this.getMessage() + ">";
    }

    static DBMException create(StructuredMem packet) {
        int errorCode = 0;
        String errorID = "";
        String message = null;
        int chunkStart = 0;
        if (packet.size() < 4) {
            return new DBMException(-807, "", "Invalid size of DBM reply message (" + packet.size() + " bytes)");
        }
        String rawString = packet.getString(4, packet.size() - 4);
        int chunkEnd = rawString.indexOf(44);
        if (chunkEnd != -1) {
            errorCode = Integer.parseInt(rawString.substring(0, chunkEnd));
            chunkStart = chunkEnd + 1;
            if ((chunkEnd = rawString.indexOf(58, chunkStart)) != -1) {
                errorID = rawString.substring(chunkStart, chunkEnd);
                message = rawString.substring(chunkEnd + 1).trim();
            }
        }
        if (message == null) {
            message = rawString;
        }
        return new DBMException(errorCode, errorID, message);
    }

    static DBMException create(String reply) {
        if (reply.length() < 4) {
            return new DBMException(-807, "", "Invalid size of DBM reply message (" + reply.length() + " bytes)");
        }
        String rawString = reply.substring(4);
        int chunkEnd = rawString.indexOf(44);
        int errorCode = 0;
        String errorID = "";
        String message = null;
        if (chunkEnd != -1) {
            errorCode = Integer.parseInt(rawString.substring(0, chunkEnd));
            int chunkStart = chunkEnd + 1;
            if ((chunkEnd = rawString.indexOf(58, chunkStart)) != -1) {
                errorID = rawString.substring(chunkStart, chunkEnd);
                message = rawString.substring(chunkEnd + 1).trim();
            }
        }
        if (message == null) {
            message = rawString;
        }
        return new DBMException(errorCode, errorID, message);
    }
}

