/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionInfo {
    private int majorVersion = 7;
    private int minorVersion = 4;
    private int clVersion = 4;
    private int plVersion = 0;
    private String buildNumber = "Build 000-000-000-000";
    private String packagePrefix = "";
    private String makeVersion = "unknown";

    public VersionInfo(int amajorVersion, int aminorVersion, int aclVersion, int aplVersion, String aBuildNumber) {
        this.majorVersion = amajorVersion;
        this.minorVersion = aminorVersion;
        this.clVersion = aclVersion;
        this.plVersion = aplVersion;
        this.buildNumber = aBuildNumber;
    }

    public VersionInfo(String packageName, String defaultString) {
        try {
            Class<?> cls = this.getClass();
            String clazz = cls.getResource("/com/sap/dbtech/util/VersionInfo.class").toString();
            clazz = clazz.substring(0, clazz.indexOf("com/sap/dbtech/util/VersionInfo.class")) + "META-INF/MANIFEST.MF";
            Manifest mani = new Manifest(new URL(clazz).openStream());
            Attributes attr = mani.getAttributes("com/sap/dbtech/jdbc/");
            StringBuffer result = new StringBuffer();
            result.append("package com.sap.dbtech.jdbc");
            result.append(", ");
            result.append(attr.getValue("Implementation-Title"));
            result.append(", ");
            result.append(attr.getValue("Implementation-Vendor"));
            result.append(", ");
            this.packagePrefix = result.toString();
            this.parseVersion(attr.getValue("Implementation-Version"));
            this.makeVersion = attr.getValue("Make-Version");
        }
        catch (Exception e) {
            StringBuffer result = new StringBuffer();
            try {
                Package p = Package.getPackage(packageName);
                if (p != null) {
                    result.append("package ");
                    result.append(p.getName());
                    result.append(", ");
                    result.append(p.getImplementationTitle());
                    result.append(", ");
                    result.append(p.getImplementationVendor());
                    result.append(", ");
                    this.packagePrefix = result.toString();
                    this.parseVersion(p.getImplementationVersion());
                }
            }
            catch (Exception exc) {
                this.packagePrefix = defaultString;
            }
        }
    }

    public void parseVersion(String VersionString) {
        int startpos = 0;
        int endpos = 0;
        int curpos = 0;
        while (Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        startpos = curpos;
        while (VersionString.charAt(curpos) != '.') {
            ++curpos;
        }
        endpos = curpos++;
        this.majorVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        startpos = curpos;
        while (VersionString.charAt(curpos) != '.') {
            ++curpos;
        }
        endpos = curpos++;
        this.minorVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        startpos = curpos;
        while (!Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        endpos = curpos;
        this.clVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
        while (Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        this.buildNumber = VersionString.substring(curpos);
        while (!Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        while (Character.isSpaceChar(VersionString.charAt(curpos))) {
            ++curpos;
        }
        startpos = curpos;
        while (VersionString.charAt(curpos) != '-') {
            ++curpos;
        }
        endpos = curpos;
        this.plVersion = Integer.parseInt(VersionString.substring(startpos, endpos));
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMinorMinorVersion() {
        return this.clVersion;
    }

    public int getCorrectionLevel() {
        return this.plVersion;
    }

    public String getVersionName() {
        return this.buildNumber;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public String toMiniString() {
        StringBuffer result = new StringBuffer();
        result.append(this.majorVersion);
        result.append('.');
        result.append(this.minorVersion);
        result.append('.');
        result.append(this.clVersion);
        result.append(" ");
        result.append(this.buildNumber);
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.packagePrefix);
        result.append(this.majorVersion);
        result.append('.');
        result.append(this.minorVersion);
        result.append('.');
        if (this.clVersion < 10) {
            result.append('0');
        }
        result.append(this.clVersion);
        result.append(" ");
        result.append(this.buildNumber);
        result.append(" (Make-Version: ");
        result.append(this.makeVersion);
        result.append(")");
        return result.toString();
    }
}

