/*
 * Decompiled with CFR 0.152.
 */
package com.mimer.jdbc;

import com.mimer.jdbc.Connection;
import com.mimer.jdbc.NativeConnection;
import com.mimer.jdbc.ad;
import com.mimer.jdbc.u;
import java.io.PrintStream;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Driver
implements java.sql.Driver {
    private static Driver a;

    public final java.sql.Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        properties = Driver.a(string, properties);
        Properties properties2 = Driver.a();
        return new Connection(string, ad.a("protocol", properties, properties2), ad.a("serverName", properties, properties2), ad.a("portNumber", properties, properties2), ad.a("databaseName", properties, properties2), ad.a("user", properties, properties2), ad.a("password", properties, properties2), ad.a("VAR", properties, properties2), ad.a("VAC", properties, properties2), ad.a("simtim", properties, properties2), ad.a("program", properties, properties2), ad.a("programpwd", properties, properties2));
    }

    public final boolean acceptsURL(String string) throws SQLException {
        return string.regionMatches(true, 0, "jdbc:mimer:", 0, 11);
    }

    public final DriverPropertyInfo[] getPropertyInfo(String driverPropertyInfoArray, Properties properties) throws SQLException {
        if (!this.acceptsURL((String)driverPropertyInfoArray)) {
            return null;
        }
        driverPropertyInfoArray = Driver.a((String)driverPropertyInfoArray, properties);
        properties = Driver.a();
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("protocol", ad.a("protocol", (Properties)driverPropertyInfoArray, properties));
        new DriverPropertyInfo("protocol", ad.a("protocol", (Properties)driverPropertyInfoArray, properties)).required = false;
        driverPropertyInfo.description = "Protocol to use for the connection";
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("serverName", ad.a("serverName", (Properties)driverPropertyInfoArray, properties));
        new DriverPropertyInfo("serverName", ad.a("serverName", (Properties)driverPropertyInfoArray, properties)).required = false;
        driverPropertyInfo2.description = "Host name of Mimer SQL server";
        DriverPropertyInfo driverPropertyInfo3 = new DriverPropertyInfo("portNumber", ad.a("portNumber", (Properties)driverPropertyInfoArray, properties));
        new DriverPropertyInfo("portNumber", ad.a("portNumber", (Properties)driverPropertyInfoArray, properties)).required = false;
        driverPropertyInfo3.description = "Port number that the Mimer SQL server listens to";
        DriverPropertyInfo driverPropertyInfo4 = new DriverPropertyInfo("databaseName", ad.a("databaseName", (Properties)driverPropertyInfoArray, properties));
        new DriverPropertyInfo("databaseName", ad.a("databaseName", (Properties)driverPropertyInfoArray, properties)).required = true;
        driverPropertyInfo4.description = "Name of the database";
        DriverPropertyInfo driverPropertyInfo5 = new DriverPropertyInfo("user", ad.a("user", (Properties)driverPropertyInfoArray, properties));
        new DriverPropertyInfo("user", ad.a("user", (Properties)driverPropertyInfoArray, properties)).required = true;
        driverPropertyInfo5.description = "Database user name";
        driverPropertyInfoArray = new DriverPropertyInfo("password", ad.a("password", (Properties)driverPropertyInfoArray, properties));
        v0.required = true;
        driverPropertyInfoArray.description = "Password for authentication";
        driverPropertyInfoArray = new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2, driverPropertyInfo3, driverPropertyInfo4, driverPropertyInfo5, driverPropertyInfoArray};
        return driverPropertyInfoArray;
    }

    public final int getMajorVersion() {
        return 3;
    }

    public final int getMinorVersion() {
        return 30;
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    private static Properties a() {
        Properties properties = new Properties();
        properties.put("protocol", "");
        properties.put("serverName", "localhost");
        properties.put("portNumber", "1360");
        properties.put("user", "");
        properties.put("password", "");
        properties.put("databaseName", "");
        return properties;
    }

    private static Properties a(String object, Properties properties) {
        boolean bl;
        properties = new Properties(properties);
        object = new u((String)object);
        String string = "";
        ((u)object).a(11);
        String string2 = ((u)object).a(":/?");
        boolean bl2 = bl = string2.length() > 0;
        if (((u)object).a(':')) {
            properties.put("protocol", string2);
            if (bl) {
                properties.put("serverName", "");
                properties.put("portNumber", "");
            }
            bl = false;
        }
        if (!bl && ((u)object).a('/') && ((u)object).a('/')) {
            string2 = ((u)object).a(":@/?[");
            boolean bl3 = false;
            if (((u)object).a('[')) {
                string2 = ((u)object).a("]");
                ((u)object).a(":/?");
            }
            if (((u)object).a(':')) {
                string = ((u)object).a("@/?[");
                bl3 = true;
            }
            if (((u)object).a('@')) {
                properties.put("user", string2);
                if (bl3) {
                    properties.put("password", string);
                }
                string2 = ((u)object).a(":/?]");
                bl3 = false;
                if (((u)object).a('[')) {
                    string2 = ((u)object).a("]");
                    ((u)object).a(":/?");
                }
                if (((u)object).a(':')) {
                    string = ((u)object).a("/?");
                    bl3 = true;
                }
            }
            properties.put("serverName", string2);
            if (bl3) {
                properties.put("portNumber", string);
            }
            ((u)object).a('/');
        }
        if (!bl) {
            string2 = ((u)object).a("?");
        }
        if (string2.length() > 0) {
            properties.put("databaseName", string2);
        }
        if (((u)object).a('?')) {
            do {
                string2 = ((u)object).a("&=");
                string = ((u)object).a('=') ? ((u)object).a("&") : "";
                if (string2.length() <= 0 || properties.containsKey(string2)) continue;
                properties.put(string2, string);
            } while (((u)object).a('&'));
        }
        return properties;
    }

    private static void a() {
        System.out.println("Usage: com.mimer.jdbc.Driver <options>");
        System.out.println();
        System.out.println("where <options> include:");
        System.out.println("    -version     Display driver version");
        System.out.println("    -sysprop     Display all system properties");
        System.out.println("    -errors      List all JDBC error codes");
        System.out.println("    -ping url    Test the database at the specified url");
        System.out.println("    -mimcomm     Try to load the mimcomm JNI class");
        System.exit(0);
    }

    private static void a(String object, int n2, PrintStream printStream) {
        try {
            if (a.acceptsURL((String)object)) {
                object = (Connection)a.connect((String)object, null);
                DatabaseMetaData databaseMetaData = ((Connection)object).getMetaData();
                printStream.println("Database connection established.");
                printStream.println("getDatabaseProductName():    " + databaseMetaData.getDatabaseProductName());
                printStream.println("getDatabaseProductVersion(): " + databaseMetaData.getDatabaseProductVersion());
                printStream.println();
                printStream.println("Ping tests:");
                long l2 = Long.MAX_VALUE;
                long l3 = 0L;
                long l4 = 0L;
                for (int i2 = 0; i2 < 10; ++i2) {
                    long l5 = System.currentTimeMillis();
                    ((Connection)object).a(0, 0);
                    l5 = System.currentTimeMillis() - l5;
                    if (l5 < l2) {
                        l2 = l5;
                    }
                    if (l5 > l3) {
                        l3 = l5;
                    }
                    l4 += l5;
                    printStream.println(ad.a(String.valueOf(i2), 3) + ad.a(String.valueOf(l5), 6) + " ms");
                }
                printStream.println("avg" + ad.a(String.valueOf(l4 / 10L), 6) + " ms      min" + ad.a(String.valueOf(l2), 6) + " ms      max" + ad.a(String.valueOf(l3), 6) + " ms");
                ((Connection)object).close();
                return;
            }
            printStream.println("Unrecognized URL prefix");
        }
        catch (Exception exception) {
            printStream.println(exception);
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        String string = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equalsIgnoreCase("-version")) {
                bl = true;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-sysprop")) {
                bl3 = true;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-mimcomm")) {
                bl4 = true;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-errors")) {
                bl2 = true;
                n2 = 0;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-errorshtml")) {
                bl2 = true;
                n2 = 1;
                continue;
            }
            if (stringArray[i2].equalsIgnoreCase("-ping")) {
                if (++i2 < stringArray.length) {
                    string = stringArray[i2];
                    continue;
                }
                System.out.println("-ping: missing url argument");
                Driver.a();
                continue;
            }
            System.out.println(stringArray[i2] + ": illegal argument");
            Driver.a();
        }
        if (!(bl || bl2 || bl3 || bl4 || string.length() != 0)) {
            Driver.a();
        }
        if (bl) {
            ad.a(System.out);
        }
        if (bl3) {
            System.getProperties().list(System.out);
        }
        if (bl2) {
            ad.a(System.out, n2);
        }
        if (bl4) {
            NativeConnection.c();
        }
        if (string.length() > 0) {
            Driver.a(string, 10, System.out);
        }
    }

    static {
        DriverManager.println("Driver class loaded");
        a = new Driver();
        try {
            DriverManager.registerDriver(a);
        }
        catch (SQLException sQLException) {
            DriverManager.println("Unable to register driver: " + sQLException.getMessage());
        }
    }
}

